/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.libraries.obr.data;

import com.intellij.dmserver.libraries.ProgressListener;
import com.intellij.dmserver.libraries.obr.data.AbstractCodeDataDetails;
import com.intellij.dmserver.libraries.obr.data.LibraryBundleData;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LibraryDetails
extends AbstractCodeDataDetails<LibraryBundleData> {
    private String myLibraryDefLink;

    public LibraryDetails(String link, ProgressListener progressListener) throws IOException, XPathExpressionException {
        super(link, progressListener);
    }

    @Override
    protected LibraryBundleData createDependency(String name, String version, String link) {
        return new LibraryBundleData(name, version, link);
    }

    @Override
    protected void retrieveCustomDetails(Node root) throws XPathExpressionException {
        this.myLibraryDefLink = LibraryDetails.scrapNamedLink(root, "Library Definition");
        HashMap<String, LibraryBundleData> dependencyName2Bundle = new HashMap<String, LibraryBundleData>();
        for (LibraryBundleData dependency : this.getDependencies()) {
            dependencyName2Bundle.put(dependency.getName(), dependency);
        }
        NodeList includedNodeList = LibraryDetails.scrapTableRows(root, "bundles");
        for (int iIncluded = 0; iIncluded < includedNodeList.getLength(); ++iIncluded) {
            Node includedNode = includedNodeList.item(iIncluded);
            String includedName = this.evaluateXpath("td[1]/a/text()", includedNode).trim();
            LibraryBundleData includedDependency = (LibraryBundleData)dependencyName2Bundle.get(includedName);
            if (includedDependency == null) continue;
            includedDependency.setIncluded(true);
        }
    }

    public String getLibraryDefLink() {
        return this.myLibraryDefLink;
    }
}

