/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.libraries.tree;

import com.intellij.dmserver.editor.AvailableBundlesProvider;
import com.intellij.dmserver.integration.RepositoryPattern;
import com.intellij.dmserver.libraries.LibraryDefinition;
import com.intellij.dmserver.libraries.ServerLibrariesContext;
import com.intellij.dmserver.libraries.tree.LibraryElement;
import com.intellij.dmserver.libraries.tree.RepositoryFolderElementBase;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class LibraryFolderElement
extends RepositoryFolderElementBase {
    private static final Comparator<LibraryElement> BY_LIBRARY_FILE_NAME = (o1, o2) -> {
        String name1 = o1.getLibraryDefinition().getLibDefFile().getName();
        String name2 = o2.getLibraryDefinition().getLibDefFile().getName();
        return name1.compareTo(name2);
    };

    public LibraryFolderElement(ServerLibrariesContext context, RepositoryPattern repositoryPattern) {
        super(context, repositoryPattern, "libraries-folder");
    }

    protected void update(PresentationData presentation) {
        presentation.setPresentableText(DmServerBundle.message("LibraryFolderElement.name", new Object[0]));
        LibraryFolderElement.updateIcons(presentation);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList<LibraryElement> result = new ArrayList<LibraryElement>();
        for (LibraryDefinition libraryDefinition : AvailableBundlesProvider.getInstance(this.getProject()).getRepositoryLibraries(this.getRepositoryPattern())) {
            result.add(new LibraryElement(this.getContext(), libraryDefinition));
        }
        Collections.sort(result, BY_LIBRARY_FILE_NAME);
        ArrayList<LibraryElement> arrayList = result;
        if (arrayList == null) {
            LibraryFolderElement.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/libraries/tree/LibraryFolderElement", "getChildren"));
    }
}

