/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.run;

import com.intellij.dmserver.install.DMServerInstallation;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import java.io.File;
import org.jetbrains.annotations.NonNls;

public class DMServerCommandLineBase {
    protected static final VirtualFileFilter VFS_LIST_JARS = new VirtualFileFilter(){

        public boolean accept(VirtualFile pathname) {
            return pathname != null && "jar".equals(pathname.getExtension());
        }
    };

    protected final void defineTempDir(ParametersList vmParams, DMServerInstallation installation) {
        vmParams.defineProperty("java.io.tmpdir", this.relative2absolutePath(installation.getHome(), "work/temp"));
    }

    protected final String relative2absolutePath(VirtualFile root, @NonNls String relativePath) {
        File file = new File(VfsUtil.virtualToIoFile((VirtualFile)root), FileUtil.toSystemDependentName((String)relativePath));
        return file.getAbsolutePath();
    }

    protected final String getAbsolutePath(VirtualFile file) {
        return FileUtil.toSystemDependentName((String)file.getPath());
    }
}

