/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.library;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.JarVersionDetectionUtil;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.patterns.PatternCondition;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootLibraryUtil {
    public static final PatternCondition<PsiElement> SB_1_3_OR_HIGHER = new PatternCondition<PsiElement>("SB1_3OrHigher"){

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            return SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootVersion.VERSION_1_3_0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/library/SpringBootLibraryUtil$1", "accepts"));
        }
    };
    public static final PatternCondition<PsiElement> SB_1_5_OR_HIGHER = new PatternCondition<PsiElement>("SB1_5OrHigher"){

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            if (element == null) {
                2.$$$reportNull$$$0(0);
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            return SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootVersion.VERSION_1_5_0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/library/SpringBootLibraryUtil$2", "accepts"));
        }
    };
    public static final PatternCondition<PsiElement> SB_2_0_OR_HIGHER = new PatternCondition<PsiElement>("SB2_0OrHigher"){

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            if (element == null) {
                3.$$$reportNull$$$0(0);
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            return SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootVersion.VERSION_2_0_0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/library/SpringBootLibraryUtil$3", "accepts"));
        }
    };

    public static boolean hasConfigurationMetadataAnnotationProcessor(@NotNull Module module) {
        PsiClass processor;
        if (module == null) {
            SpringBootLibraryUtil.$$$reportNull$$$0(0);
        }
        return (processor = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.boot.configurationprocessor.ConfigurationMetadataAnnotationProcessor")) != null;
    }

    public static boolean hasSpringBootLibrary(Project project) {
        if (project.isDisposed()) {
            return false;
        }
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            DumbService dumbService = DumbService.getInstance((Project)project);
            if (dumbService.isDumb()) {
                return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{dumbService.getModificationTracker()});
            }
            boolean foundMarkerClass = JavaPsiFacade.getInstance((Project)project).findClass(SpringBootVersion.ANY.getDetectionClassFqn(), ProjectScope.getAllScope((Project)project)) != null;
            return CachedValueProvider.Result.createSingleDependency((Object)foundMarkerClass, (Object)ProjectRootManager.getInstance((Project)project));
        });
    }

    public static boolean hasSpringBootLibrary(@Nullable Module module) {
        return SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootVersion.ANY);
    }

    public static boolean isAtLeastVersion(@Nullable Module module, SpringBootVersion version) {
        if (module == null || module.isDisposed()) {
            return false;
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary(module.getProject())) {
            return false;
        }
        SpringBootVersion cached = SpringBootLibraryUtil.getCachedSpringBootVersion(module);
        return cached != null && cached.isAtLeast(version);
    }

    @Nullable
    public static String getVersionFromJar(@NotNull Module module) {
        if (module == null) {
            SpringBootLibraryUtil.$$$reportNull$$$0(1);
        }
        return JarVersionDetectionUtil.detectJarVersion((String)SpringBootVersion.ANY.getDetectionClassFqn(), (Module)module);
    }

    public static boolean hasDevtools(@Nullable Module module) {
        return SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.boot.devtools.RemoteSpringApplication") != null;
    }

    public static boolean hasActuators(@Nullable Module module) {
        if (SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootVersion.VERSION_2_0_0)) {
            return SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.boot.actuate.endpoint.annotation.Endpoint") != null;
        }
        return SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.boot.actuate.endpoint.Endpoint") != null;
    }

    public static boolean hasRequestMappings(@Nullable Module module) {
        return SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.handler.AbstractHandlerMethodMapping") != null;
    }

    @Nullable
    private static SpringBootVersion getCachedSpringBootVersion(@NotNull Module module) {
        if (module == null) {
            SpringBootLibraryUtil.$$$reportNull$$$0(2);
        }
        Project project = module.getProject();
        return (SpringBootVersion)((Object)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            if (module == null) {
                SpringBootLibraryUtil.$$$reportNull$$$0(3);
            }
            GlobalSearchScope scope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false);
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
            SpringBootVersion detected = null;
            for (SpringBootVersion version : (SpringBootVersion[])ArrayUtil.reverseArray((Object[])SpringBootVersion.values())) {
                PsiClass psiClass = javaPsiFacade.findClass(version.getDetectionClassFqn(), scope);
                if (psiClass == null) continue;
                detected = version;
                break;
            }
            return CachedValueProvider.Result.create(detected, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "module";
        objectArray2[1] = "com/intellij/spring/boot/library/SpringBootLibraryUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasConfigurationMetadataAnnotationProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getVersionFromJar";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getCachedSpringBootVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getCachedSpringBootVersion$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum SpringBootVersion {
        ANY("org.springframework.boot.SpringApplication"),
        VERSION_1_2_0("org.springframework.boot.jta.XADataSourceWrapper"),
        VERSION_1_3_0("org.springframework.boot.context.event.ApplicationReadyEvent"),
        VERSION_1_4_0("org.springframework.boot.diagnostics.FailureAnalysis"),
        VERSION_1_5_0("org.springframework.boot.autoconfigure.AbstractDatabaseInitializer"),
        VERSION_2_0_0("org.springframework.boot.WebApplicationType");

        private final String myDetectionClassFqn;

        private SpringBootVersion(String detectionClassFqn) {
            this.myDetectionClassFqn = detectionClassFqn;
        }

        boolean isAtLeast(SpringBootVersion reference) {
            if (reference == ANY) {
                return true;
            }
            return this.ordinal() >= reference.ordinal();
        }

        public String getDetectionClassFqn() {
            return this.myDetectionClassFqn;
        }
    }
}

