/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.jam;

import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamEnumAttributeMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemKey;
import com.intellij.spring.boot.model.SpringBootConfigValueSearcher;
import com.intellij.spring.boot.model.autoconfigure.jam.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.jam.ConditionalOnJamElement;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.scope.SpringBeanScopeManager;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConditionalOnWebApplication
implements ConditionalOnJamElement {
    private static final JamEnumAttributeMeta.Single<Type> TYPE_ATTRIBUTE_META = JamAttributeMeta.singleEnum((String)"type", Type.class);
    private static final JamAnnotationMeta ANNOTATION_META = new JamAnnotationMeta("org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication").addAttribute(TYPE_ATTRIBUTE_META);
    private static final SemKey<ConditionalOnWebApplication> SEM_KEY = CONDITIONAL_JAM_ELEMENT_KEY.subKey("ConditionalOnWebApplication", new SemKey[0]);
    public static final JamClassMeta<ConditionalOnWebApplication> CLASS_META = new JamClassMeta(null, ConditionalOnWebApplication.class, SEM_KEY).addAnnotation(ANNOTATION_META);
    public static final JamMethodMeta<ConditionalOnWebApplication> METHOD_META = new JamMethodMeta(null, ConditionalOnWebApplication.class, SEM_KEY).addAnnotation(ANNOTATION_META);
    private static final String WEB_APPLICATION_CONTEXT = "org.springframework.web.context.support.GenericWebApplicationContext";
    private static final Condition<SpringBeanScope> SESSION_SCOPE = scope -> scope.getValue().equals("session");
    static final Condition<ConditionalOnEvaluationContext> SERVLET_CONDITION = context -> {
        if (SpringCommonUtils.findLibraryClass((Module)context.getModule(), (String)WEB_APPLICATION_CONTEXT) != null) {
            return true;
        }
        List scopes = SpringBeanScopeManager.getInstance().getCustomBeanScopes((PsiElement)context.getAutoConfigClass());
        return ContainerUtil.exists((Iterable)scopes, SESSION_SCOPE);
    };
    @NonNls
    private static final String WEB_FLUX_CONFIGURER = "org.springframework.web.reactive.config.WebFluxConfigurer";
    @NonNls
    private static final String WEB_MVC_CONFIGURER = "org.springframework.web.servlet.config.annotation.WebMvcConfigurer";
    @NonNls
    private static final String WEB_APPLICATION_TYPE_KEY = "spring.main.web-application-type";
    static final Condition<ConditionalOnEvaluationContext> REACTIVE_CONDITION = context -> {
        if (SpringCommonUtils.findLibraryClass((Module)context.getModule(), (String)"reactor.core.publisher.Flux") == null || SpringCommonUtils.findLibraryClass((Module)context.getModule(), (String)WEB_FLUX_CONFIGURER) == null) {
            return false;
        }
        if (SpringCommonUtils.findLibraryClass((Module)context.getModule(), (String)WEB_MVC_CONFIGURER) != null) {
            SpringBootConfigValueSearcher searcher = SpringBootConfigValueSearcher.productionForProfiles(context.getModule(), WEB_APPLICATION_TYPE_KEY, context.getActiveProfiles());
            String webApplicationType = searcher.findValueText();
            return Comparing.strEqual((String)webApplicationType, (String)Type.REACTIVE.name(), (boolean)false);
        }
        return true;
    };
    private final PsiElementRef<PsiAnnotation> myAnnotationRef;

    public ConditionalOnWebApplication(PsiModifierListOwner owner) {
        this.myAnnotationRef = ANNOTATION_META.getAnnotationRef(owner);
    }

    public boolean value(ConditionalOnEvaluationContext context) {
        if (this.getType() == Type.REACTIVE) {
            return REACTIVE_CONDITION.value((Object)context);
        }
        return SERVLET_CONDITION.value((Object)context);
    }

    @NotNull
    public Type getType() {
        Type filterType = (Type)TYPE_ATTRIBUTE_META.getJam(this.myAnnotationRef).getValue();
        if (filterType != null) {
            Type type = filterType;
            if (type == null) {
                ConditionalOnWebApplication.$$$reportNull$$$0(0);
            }
            return type;
        }
        Type type = Type.ANY;
        if (type == null) {
            ConditionalOnWebApplication.$$$reportNull$$$0(1);
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/jam/ConditionalOnWebApplication", "getType"));
    }

    static enum Type {
        ANY,
        SERVLET,
        REACTIVE;

    }
}

