/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.highlighting;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.hibernate.CriteriaApiReferenceProvider;
import com.intellij.hibernate.HibernateMessages;
import com.intellij.hibernate.model.HibernateConstants;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import java.text.MessageFormat;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CriteriaApiResolveInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "CriteriaApiResolveInspection";

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = HibernateConstants.HIBERNATE_INSPECTIONS_GROUP;
        if (string == null) {
            CriteriaApiResolveInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            CriteriaApiResolveInspection.$$$reportNull$$$0(1);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public String getDisplayName() {
        String string = HibernateMessages.message("inspection.name.hibernate.criteria.api", new Object[0]);
        if (string == null) {
            CriteriaApiResolveInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if (SHORT_NAME == null) {
            CriteriaApiResolveInspection.$$$reportNull$$$0(3);
        }
        return SHORT_NAME;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            CriteriaApiResolveInspection.$$$reportNull$$$0(4);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                CriteriaApiResolveInspection.checkQueryApiReferences(expression, holder, isOnTheFly);
            }
        };
        if (javaElementVisitor == null) {
            CriteriaApiResolveInspection.$$$reportNull$$$0(5);
        }
        return javaElementVisitor;
    }

    private static void checkQueryApiReferences(PsiLiteralExpression literalExpression, ProblemsHolder holder, boolean isOnTheFly) {
        if (!CriteriaApiReferenceProvider.ALL_PATTERNS.accepts((Object)literalExpression)) {
            return;
        }
        JpaUtil.processReferencesOfType((PsiReference[])literalExpression.getReferences(), CriteriaApiReferenceProvider.CriteriaAttributeReference.class, reference -> {
            boolean badResolve;
            boolean bl = badResolve = reference.resolve() == null;
            if (badResolve) {
                String message = MessageFormat.format(reference.getUnresolvedMessagePattern(), reference.getCanonicalText());
                holder.registerProblem(holder.getManager().createProblemDescriptor(reference.getElement(), reference.getRangeInElement(), message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, reference.getQuickFixes()));
                return false;
            }
            return true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/hibernate/highlighting/CriteriaApiResolveInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/hibernate/highlighting/CriteriaApiResolveInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

