/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.webservices;

import com.microsoft.webservices.ExtensionMapper;
import com.microsoft.webservices.LocationServiceData;
import com.microsoft.webservices.TeamFoundationIdentity;
import com.microsoft.wsdl.types.Guid;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axis2.databinding.ADBBean;
import org.apache.axis2.databinding.ADBDataSource;
import org.apache.axis2.databinding.ADBException;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.axis2.databinding.utils.reader.ADBXMLStreamReaderImpl;
import org.apache.axis2.databinding.utils.writer.MTOMAwareXMLStreamWriter;

public class ConnectionData
implements ADBBean {
    protected TeamFoundationIdentity localAuthenticatedUser;
    protected boolean localAuthenticatedUserTracker = false;
    protected TeamFoundationIdentity localAuthorizedUser;
    protected boolean localAuthorizedUserTracker = false;
    protected LocationServiceData localLocationServiceData;
    protected boolean localLocationServiceDataTracker = false;
    protected Guid localInstanceId;
    protected Guid localCatalogResourceId;
    protected String localWebApplicationRelativeDirectory;
    protected int localServerCapabilities;
    protected String localServerVersion;

    private static String generatePrefix(String namespace) {
        if (namespace.equals("http://microsoft.com/webservices/")) {
            return "";
        }
        return BeanUtil.getUniquePrefix();
    }

    public TeamFoundationIdentity getAuthenticatedUser() {
        return this.localAuthenticatedUser;
    }

    public void setAuthenticatedUser(TeamFoundationIdentity param) {
        this.localAuthenticatedUserTracker = param != null;
        this.localAuthenticatedUser = param;
    }

    public TeamFoundationIdentity getAuthorizedUser() {
        return this.localAuthorizedUser;
    }

    public void setAuthorizedUser(TeamFoundationIdentity param) {
        this.localAuthorizedUserTracker = param != null;
        this.localAuthorizedUser = param;
    }

    public LocationServiceData getLocationServiceData() {
        return this.localLocationServiceData;
    }

    public void setLocationServiceData(LocationServiceData param) {
        this.localLocationServiceDataTracker = param != null;
        this.localLocationServiceData = param;
    }

    public Guid getInstanceId() {
        return this.localInstanceId;
    }

    public void setInstanceId(Guid param) {
        this.localInstanceId = param;
    }

    public Guid getCatalogResourceId() {
        return this.localCatalogResourceId;
    }

    public void setCatalogResourceId(Guid param) {
        this.localCatalogResourceId = param;
    }

    public String getWebApplicationRelativeDirectory() {
        return this.localWebApplicationRelativeDirectory;
    }

    public void setWebApplicationRelativeDirectory(String param) {
        this.localWebApplicationRelativeDirectory = param;
    }

    public int getServerCapabilities() {
        return this.localServerCapabilities;
    }

    public void setServerCapabilities(int param) {
        this.localServerCapabilities = param;
    }

    public String getServerVersion() {
        return this.localServerVersion;
    }

    public void setServerVersion(String param) {
        this.localServerVersion = param;
    }

    public static boolean isReaderMTOMAware(XMLStreamReader reader) {
        boolean isReaderMTOMAware = false;
        try {
            isReaderMTOMAware = Boolean.TRUE.equals(reader.getProperty("IsDatahandlersAwareParsing"));
        }
        catch (IllegalArgumentException e) {
            isReaderMTOMAware = false;
        }
        return isReaderMTOMAware;
    }

    public OMElement getOMElement(QName parentQName, final OMFactory factory) throws ADBException {
        ADBDataSource dataSource = new ADBDataSource(this, parentQName){

            public void serialize(MTOMAwareXMLStreamWriter xmlWriter) throws XMLStreamException {
                ConnectionData.this.serialize(this.parentQName, factory, xmlWriter);
            }
        };
        return new OMSourcedElementImpl(parentQName, factory, (OMDataSource)dataSource);
    }

    public void serialize(QName parentQName, OMFactory factory, MTOMAwareXMLStreamWriter xmlWriter) throws XMLStreamException, ADBException {
        this.serialize(parentQName, factory, xmlWriter, false);
    }

    public void serialize(QName parentQName, OMFactory factory, MTOMAwareXMLStreamWriter xmlWriter, boolean serializeType) throws XMLStreamException, ADBException {
        String prefix = null;
        String namespace = null;
        prefix = parentQName.getPrefix();
        namespace = parentQName.getNamespaceURI();
        if (namespace != null && namespace.trim().length() > 0) {
            String writerPrefix = xmlWriter.getPrefix(namespace);
            if (writerPrefix != null) {
                xmlWriter.writeStartElement(namespace, parentQName.getLocalPart());
            } else {
                if (prefix == null) {
                    prefix = ConnectionData.generatePrefix(namespace);
                }
                xmlWriter.writeStartElement(prefix, parentQName.getLocalPart(), namespace);
                xmlWriter.writeNamespace(prefix, namespace);
                xmlWriter.setPrefix(prefix, namespace);
            }
        } else {
            xmlWriter.writeStartElement(parentQName.getLocalPart());
        }
        if (serializeType) {
            String namespacePrefix = this.registerPrefix((XMLStreamWriter)xmlWriter, "http://microsoft.com/webservices/");
            if (namespacePrefix != null && namespacePrefix.trim().length() > 0) {
                this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", namespacePrefix + ":ConnectionData", (XMLStreamWriter)xmlWriter);
            } else {
                this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", "ConnectionData", (XMLStreamWriter)xmlWriter);
            }
        }
        if (this.localInstanceId == null) {
            throw new ADBException("required attribute localInstanceId is null");
        }
        this.writeAttribute("", "InstanceId", this.localInstanceId.toString(), (XMLStreamWriter)xmlWriter);
        if (this.localCatalogResourceId == null) {
            throw new ADBException("required attribute localCatalogResourceId is null");
        }
        this.writeAttribute("", "CatalogResourceId", this.localCatalogResourceId.toString(), (XMLStreamWriter)xmlWriter);
        if (this.localWebApplicationRelativeDirectory != null) {
            this.writeAttribute("", "WebApplicationRelativeDirectory", ConverterUtil.convertToString((String)this.localWebApplicationRelativeDirectory), (XMLStreamWriter)xmlWriter);
        }
        if (this.localServerCapabilities != Integer.MIN_VALUE) {
            this.writeAttribute("", "ServerCapabilities", ConverterUtil.convertToString((int)this.localServerCapabilities), (XMLStreamWriter)xmlWriter);
        }
        if (this.localServerVersion != null) {
            this.writeAttribute("", "ServerVersion", ConverterUtil.convertToString((String)this.localServerVersion), (XMLStreamWriter)xmlWriter);
        }
        if (this.localAuthenticatedUserTracker) {
            if (this.localAuthenticatedUser == null) {
                throw new ADBException("AuthenticatedUser cannot be null!!");
            }
            this.localAuthenticatedUser.serialize(new QName("http://microsoft.com/webservices/", "AuthenticatedUser"), factory, xmlWriter);
        }
        if (this.localAuthorizedUserTracker) {
            if (this.localAuthorizedUser == null) {
                throw new ADBException("AuthorizedUser cannot be null!!");
            }
            this.localAuthorizedUser.serialize(new QName("http://microsoft.com/webservices/", "AuthorizedUser"), factory, xmlWriter);
        }
        if (this.localLocationServiceDataTracker) {
            if (this.localLocationServiceData == null) {
                throw new ADBException("LocationServiceData cannot be null!!");
            }
            this.localLocationServiceData.serialize(new QName("http://microsoft.com/webservices/", "LocationServiceData"), factory, xmlWriter);
        }
        xmlWriter.writeEndElement();
    }

    private void writeAttribute(String prefix, String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (xmlWriter.getPrefix(namespace) == null) {
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        xmlWriter.writeAttribute(namespace, attName, attValue);
    }

    private void writeAttribute(String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (namespace.equals("")) {
            xmlWriter.writeAttribute(attName, attValue);
        } else {
            this.registerPrefix(xmlWriter, namespace);
            xmlWriter.writeAttribute(namespace, attName, attValue);
        }
    }

    private void writeQNameAttribute(String namespace, String attName, QName qname, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String attributeNamespace = qname.getNamespaceURI();
        String attributePrefix = xmlWriter.getPrefix(attributeNamespace);
        if (attributePrefix == null) {
            attributePrefix = this.registerPrefix(xmlWriter, attributeNamespace);
        }
        String attributeValue = attributePrefix.trim().length() > 0 ? attributePrefix + ":" + qname.getLocalPart() : qname.getLocalPart();
        if (namespace.equals("")) {
            xmlWriter.writeAttribute(attName, attributeValue);
        } else {
            this.registerPrefix(xmlWriter, namespace);
            xmlWriter.writeAttribute(namespace, attName, attributeValue);
        }
    }

    private void writeQName(QName qname, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String namespaceURI = qname.getNamespaceURI();
        if (namespaceURI != null) {
            String prefix = xmlWriter.getPrefix(namespaceURI);
            if (prefix == null) {
                prefix = ConnectionData.generatePrefix(namespaceURI);
                xmlWriter.writeNamespace(prefix, namespaceURI);
                xmlWriter.setPrefix(prefix, namespaceURI);
            }
            if (prefix.trim().length() > 0) {
                xmlWriter.writeCharacters(prefix + ":" + ConverterUtil.convertToString((QName)qname));
            } else {
                xmlWriter.writeCharacters(ConverterUtil.convertToString((QName)qname));
            }
        } else {
            xmlWriter.writeCharacters(ConverterUtil.convertToString((QName)qname));
        }
    }

    private void writeQNames(QName[] qnames, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (qnames != null) {
            StringBuffer stringToWrite = new StringBuffer();
            String namespaceURI = null;
            String prefix = null;
            for (int i = 0; i < qnames.length; ++i) {
                if (i > 0) {
                    stringToWrite.append(" ");
                }
                if ((namespaceURI = qnames[i].getNamespaceURI()) != null) {
                    prefix = xmlWriter.getPrefix(namespaceURI);
                    if (prefix == null || prefix.length() == 0) {
                        prefix = ConnectionData.generatePrefix(namespaceURI);
                        xmlWriter.writeNamespace(prefix, namespaceURI);
                        xmlWriter.setPrefix(prefix, namespaceURI);
                    }
                    if (prefix.trim().length() > 0) {
                        stringToWrite.append(prefix).append(":").append(ConverterUtil.convertToString((QName)qnames[i]));
                        continue;
                    }
                    stringToWrite.append(ConverterUtil.convertToString((QName)qnames[i]));
                    continue;
                }
                stringToWrite.append(ConverterUtil.convertToString((QName)qnames[i]));
            }
            xmlWriter.writeCharacters(stringToWrite.toString());
        }
    }

    private String registerPrefix(XMLStreamWriter xmlWriter, String namespace) throws XMLStreamException {
        String prefix = xmlWriter.getPrefix(namespace);
        if (prefix == null) {
            prefix = ConnectionData.generatePrefix(namespace);
            while (xmlWriter.getNamespaceContext().getNamespaceURI(prefix) != null) {
                prefix = BeanUtil.getUniquePrefix();
            }
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        return prefix;
    }

    public XMLStreamReader getPullParser(QName qName) throws ADBException {
        ArrayList<Object> elementList = new ArrayList<Object>();
        ArrayList<Object> attribList = new ArrayList<Object>();
        if (this.localAuthenticatedUserTracker) {
            elementList.add(new QName("http://microsoft.com/webservices/", "AuthenticatedUser"));
            if (this.localAuthenticatedUser == null) {
                throw new ADBException("AuthenticatedUser cannot be null!!");
            }
            elementList.add(this.localAuthenticatedUser);
        }
        if (this.localAuthorizedUserTracker) {
            elementList.add(new QName("http://microsoft.com/webservices/", "AuthorizedUser"));
            if (this.localAuthorizedUser == null) {
                throw new ADBException("AuthorizedUser cannot be null!!");
            }
            elementList.add(this.localAuthorizedUser);
        }
        if (this.localLocationServiceDataTracker) {
            elementList.add(new QName("http://microsoft.com/webservices/", "LocationServiceData"));
            if (this.localLocationServiceData == null) {
                throw new ADBException("LocationServiceData cannot be null!!");
            }
            elementList.add(this.localLocationServiceData);
        }
        attribList.add(new QName("", "InstanceId"));
        attribList.add(this.localInstanceId.toString());
        attribList.add(new QName("", "CatalogResourceId"));
        attribList.add(this.localCatalogResourceId.toString());
        attribList.add(new QName("", "WebApplicationRelativeDirectory"));
        attribList.add(ConverterUtil.convertToString((String)this.localWebApplicationRelativeDirectory));
        attribList.add(new QName("", "ServerCapabilities"));
        attribList.add(ConverterUtil.convertToString((int)this.localServerCapabilities));
        attribList.add(new QName("", "ServerVersion"));
        attribList.add(ConverterUtil.convertToString((String)this.localServerVersion));
        return new ADBXMLStreamReaderImpl(qName, elementList.toArray(), attribList.toArray());
    }

    public static class Factory {
        public static ConnectionData parse(XMLStreamReader reader) throws Exception {
            ConnectionData object = new ConnectionData();
            Object nillableValue = null;
            String prefix = "";
            String namespaceuri = "";
            try {
                String fullTypeName;
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type") != null && (fullTypeName = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) != null) {
                    String nsPrefix = null;
                    if (fullTypeName.indexOf(":") > -1) {
                        nsPrefix = fullTypeName.substring(0, fullTypeName.indexOf(":"));
                    }
                    nsPrefix = nsPrefix == null ? "" : nsPrefix;
                    String type = fullTypeName.substring(fullTypeName.indexOf(":") + 1);
                    if (!"ConnectionData".equals(type)) {
                        String nsUri = reader.getNamespaceContext().getNamespaceURI(nsPrefix);
                        return (ConnectionData)ExtensionMapper.getTypeObject(nsUri, type, reader);
                    }
                }
                Vector<String> handledAttributes = new Vector<String>();
                String tempAttribInstanceId = reader.getAttributeValue(null, "InstanceId");
                if (tempAttribInstanceId == null) {
                    throw new ADBException("Required attribute InstanceId is missing");
                }
                String content = tempAttribInstanceId;
                object.setInstanceId(Guid.Factory.fromString(reader, tempAttribInstanceId));
                handledAttributes.add("InstanceId");
                String tempAttribCatalogResourceId = reader.getAttributeValue(null, "CatalogResourceId");
                if (tempAttribCatalogResourceId == null) {
                    throw new ADBException("Required attribute CatalogResourceId is missing");
                }
                String content2 = tempAttribCatalogResourceId;
                object.setCatalogResourceId(Guid.Factory.fromString(reader, tempAttribCatalogResourceId));
                handledAttributes.add("CatalogResourceId");
                String tempAttribWebApplicationRelativeDirectory = reader.getAttributeValue(null, "WebApplicationRelativeDirectory");
                if (tempAttribWebApplicationRelativeDirectory != null) {
                    String content3 = tempAttribWebApplicationRelativeDirectory;
                    object.setWebApplicationRelativeDirectory(ConverterUtil.convertToString((String)tempAttribWebApplicationRelativeDirectory));
                }
                handledAttributes.add("WebApplicationRelativeDirectory");
                String tempAttribServerCapabilities = reader.getAttributeValue(null, "ServerCapabilities");
                if (tempAttribServerCapabilities != null) {
                    String content4 = tempAttribServerCapabilities;
                    object.setServerCapabilities(ConverterUtil.convertToInt((String)tempAttribServerCapabilities));
                } else {
                    object.setServerCapabilities(Integer.MIN_VALUE);
                }
                handledAttributes.add("ServerCapabilities");
                String tempAttribServerVersion = reader.getAttributeValue(null, "ServerVersion");
                if (tempAttribServerVersion != null) {
                    String content5 = tempAttribServerVersion;
                    object.setServerVersion(ConverterUtil.convertToString((String)tempAttribServerVersion));
                }
                handledAttributes.add("ServerVersion");
                reader.next();
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("http://microsoft.com/webservices/", "AuthenticatedUser").equals(reader.getName())) {
                    object.setAuthenticatedUser(TeamFoundationIdentity.Factory.parse(reader));
                    reader.next();
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("http://microsoft.com/webservices/", "AuthorizedUser").equals(reader.getName())) {
                    object.setAuthorizedUser(TeamFoundationIdentity.Factory.parse(reader));
                    reader.next();
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("http://microsoft.com/webservices/", "LocationServiceData").equals(reader.getName())) {
                    object.setLocationServiceData(LocationServiceData.Factory.parse(reader));
                    reader.next();
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement()) {
                    throw new ADBException("Unexpected subelement " + reader.getLocalName());
                }
            }
            catch (XMLStreamException e) {
                throw new Exception(e);
            }
            return object;
        }
    }
}

