/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3TemplateParameterDefinitionImpl;
import com.intellij.javaee.openshift.cloud.OSBundle;
import com.intellij.javaee.openshift.cloud.OSCloudConfiguration;
import com.intellij.javaee.openshift.cloud.OSDeploymentDetector;
import com.intellij.javaee.openshift.cloud.OSServerRuntimeInstance;
import com.intellij.javaee.openshift.cloud.deploymentSource.OS3LocalTemplateDeploymentSource;
import com.intellij.javaee.openshift.cloud.deploymentSource.OS3ServerTemplateDeploymentSource;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.util.RepositoryDeploymentConfiguration;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudDeploymentNameProvider;
import com.intellij.remoteServer.util.CloudGitDeploymentChecker;
import com.intellij.remoteServer.util.CloudGitDeploymentDetector;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OSDeploymentConfiguration
extends CloudDeploymentNameConfiguration<OSDeploymentConfiguration>
implements RepositoryDeploymentConfiguration {
    public static final String OS3_VERSION_WARNING = OSBundle.getText("OSDeploymentConfiguration.os.version.warning", new Object[0]);
    public static final CloudDeploymentNameProvider DEPLOYMENT_NAME_PROVIDER = new CloudDeploymentNameProvider(){

        @NotNull
        public String getDeploymentName(@NotNull DeploymentSource deploymentSource) {
            if (deploymentSource == null) {
                1.$$$reportNull$$$0(0);
            }
            String string = CloudDeploymentNameProvider.DEFAULT_NAME_PROVIDER.getDeploymentName(deploymentSource).replace("_", "");
            if (string == null) {
                1.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deploymentSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javaee/openshift/cloud/OSDeploymentConfiguration$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javaee/openshift/cloud/OSDeploymentConfiguration$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeploymentName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getDeploymentName";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final CloudGitDeploymentChecker<OSDeploymentConfiguration, OSCloudConfiguration, OSServerRuntimeInstance> ourCloudGitDeploymentChecker = new CloudGitDeploymentChecker((CloudGitDeploymentDetector)new OSDeploymentDetector());
    private String myRepositoryPath;
    private Integer myDebugPort;
    private String myProjectName;
    private String myTemplateName;
    private List<OS3TemplateParameterDefinitionImpl> myTemplateParameters = new ArrayList<OS3TemplateParameterDefinitionImpl>();

    public String getRepositoryPath() {
        return this.myRepositoryPath;
    }

    public void setRepositoryPath(String repositoryPath) {
        this.myRepositoryPath = repositoryPath;
    }

    public Integer getDebugPort() {
        return this.myDebugPort;
    }

    public void setDebugPort(Integer debugPort) {
        this.myDebugPort = debugPort;
    }

    protected String getDefaultDeploymentSourceName(DeploymentSource deploymentSource) {
        return DEPLOYMENT_NAME_PROVIDER.getDeploymentName(deploymentSource);
    }

    public void checkConfiguration(RemoteServer<?> server, DeploymentSource deploymentSource) throws RuntimeConfigurationException {
        boolean isOS3DeploymentSource;
        RemoteServer<?> remoteServer = server;
        boolean isOS3Server = ((OSCloudConfiguration)remoteServer.getConfiguration()).isOS3();
        boolean bl = isOS3DeploymentSource = deploymentSource instanceof OS3LocalTemplateDeploymentSource || deploymentSource instanceof OS3ServerTemplateDeploymentSource;
        if (isOS3Server ^ isOS3DeploymentSource) {
            throw new RuntimeConfigurationError(OS3_VERSION_WARNING);
        }
        if (!isOS3Server) {
            ourCloudGitDeploymentChecker.checkGitUrl(remoteServer, deploymentSource, (CloudDeploymentNameConfiguration)this);
        }
    }

    public String getProjectName() {
        return this.myProjectName;
    }

    public void setProjectName(String projectName) {
        this.myProjectName = projectName;
    }

    public List<OS3TemplateParameterDefinitionImpl> getTemplateParameters() {
        return this.myTemplateParameters;
    }

    public void setTemplateParameters(List<OS3TemplateParameterDefinitionImpl> templateParameters) {
        this.myTemplateParameters = templateParameters;
    }

    public String getTemplateName() {
        return this.myTemplateName;
    }

    public void setTemplateName(String templateName) {
        this.myTemplateName = templateName;
    }
}

