/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.openshift.cloud.OSDeploymentConfiguration;
import com.intellij.javaee.openshift.cloud.OSDeploymentNameEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.DeploymentNameConfiguration;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class OSDeploymentEditor
extends SettingsEditor<OSDeploymentConfiguration> {
    private OSDeploymentNameEditor myDeploymentNameEditor;
    private JPanel myMainPanel;
    private JTextField myDebugPortField;
    private JPanel myDeploymentNamePanel;

    public OSDeploymentEditor() {
        this.$$$setupUI$$$();
        Disposer.register((Disposable)this, (Disposable)this.getDeploymentNameEditor());
    }

    protected void resetEditorFrom(@NotNull OSDeploymentConfiguration s) {
        if (s == null) {
            OSDeploymentEditor.$$$reportNull$$$0(0);
        }
        this.myDeploymentNameEditor.resetEditorFrom((DeploymentNameConfiguration)s);
        Integer port = s.getDebugPort();
        String debugPort = port != null ? String.valueOf(port) : "";
        this.myDebugPortField.setText(debugPort);
    }

    protected void applyEditorTo(@NotNull OSDeploymentConfiguration s) throws ConfigurationException {
        if (s == null) {
            OSDeploymentEditor.$$$reportNull$$$0(1);
        }
        this.myDeploymentNameEditor.applyEditorTo((DeploymentNameConfiguration)s);
        s.setDebugPort(this.parsePort());
    }

    private void createUIComponents() {
        this.myDeploymentNamePanel = (JPanel)this.getDeploymentNameEditor().getComponent();
    }

    private OSDeploymentNameEditor getDeploymentNameEditor() {
        if (this.myDeploymentNameEditor == null) {
            this.myDeploymentNameEditor = new OSDeploymentNameEditor();
        }
        return this.myDeploymentNameEditor;
    }

    private Integer parsePort() throws RuntimeConfigurationException {
        String debugPort = this.myDebugPortField.getText();
        if (StringUtil.isEmpty((String)debugPort)) {
            return null;
        }
        try {
            return Integer.parseInt(debugPort);
        }
        catch (NumberFormatException e) {
            throw new RuntimeConfigurationException("Invalid port number");
        }
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            OSDeploymentEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/openshift/cloud/OSDeploymentEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/openshift/cloud/OSDeploymentEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = this.myDeploymentNamePanel;
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Debug Port: ");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myDebugPortField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

