/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsNotifier;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubNotifications {
    private static final Logger LOG = GithubUtil.LOG;

    private static boolean isOperationCanceled(@NotNull Exception e) {
        if (e == null) {
            GithubNotifications.$$$reportNull$$$0(0);
        }
        return e instanceof GithubOperationCanceledException || e instanceof ProcessCanceledException;
    }

    public static void showInfo(@NotNull Project project, @NotNull String title, @NotNull String message) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(1);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(2);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(3);
        }
        LOG.info(title + "; " + message);
        VcsNotifier.getInstance((Project)project).notifyImportantInfo(title, message);
    }

    public static void showWarning(@NotNull Project project, @NotNull String title, @NotNull String message) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(4);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(5);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(6);
        }
        LOG.info(title + "; " + message);
        VcsNotifier.getInstance((Project)project).notifyImportantWarning(title, message);
    }

    public static void showWarning(@NotNull Project project, @NotNull String title, @NotNull Exception e) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(7);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(8);
        }
        if (e == null) {
            GithubNotifications.$$$reportNull$$$0(9);
        }
        LOG.info(title + "; ", (Throwable)e);
        if (GithubNotifications.isOperationCanceled(e)) {
            return;
        }
        VcsNotifier.getInstance((Project)project).notifyImportantWarning(title, GithubUtil.getErrorTextFromException(e));
    }

    public static void showError(@NotNull Project project, @NotNull String title, @NotNull String message) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(10);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(11);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(12);
        }
        LOG.info(title + "; " + message);
        VcsNotifier.getInstance((Project)project).notifyError(title, message);
    }

    public static void showError(@NotNull Project project, @NotNull String title, @NotNull String message, @NotNull String logDetails) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(13);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(14);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(15);
        }
        if (logDetails == null) {
            GithubNotifications.$$$reportNull$$$0(16);
        }
        LOG.warn(title + "; " + message + "; " + logDetails);
        VcsNotifier.getInstance((Project)project).notifyError(title, message);
    }

    public static void showError(@NotNull Project project, @NotNull String title, @NotNull Exception e) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(17);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(18);
        }
        if (e == null) {
            GithubNotifications.$$$reportNull$$$0(19);
        }
        LOG.warn(title + "; ", (Throwable)e);
        if (GithubNotifications.isOperationCanceled(e)) {
            return;
        }
        VcsNotifier.getInstance((Project)project).notifyError(title, GithubUtil.getErrorTextFromException(e));
    }

    public static void showInfoURL(@NotNull Project project, @NotNull String title, @NotNull String message, @NotNull String url) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(20);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(21);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(22);
        }
        if (url == null) {
            GithubNotifications.$$$reportNull$$$0(23);
        }
        LOG.info(title + "; " + message + "; " + url);
        VcsNotifier.getInstance((Project)project).notifyImportantInfo(title, "<a href='" + url + "'>" + message + "</a>", NotificationListener.URL_OPENING_LISTENER);
    }

    public static void showWarningURL(@NotNull Project project, @NotNull String title, @NotNull String prefix, @NotNull String highlight, @NotNull String postfix, @NotNull String url) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(24);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(25);
        }
        if (prefix == null) {
            GithubNotifications.$$$reportNull$$$0(26);
        }
        if (highlight == null) {
            GithubNotifications.$$$reportNull$$$0(27);
        }
        if (postfix == null) {
            GithubNotifications.$$$reportNull$$$0(28);
        }
        if (url == null) {
            GithubNotifications.$$$reportNull$$$0(29);
        }
        LOG.info(title + "; " + prefix + highlight + postfix + "; " + url);
        VcsNotifier.getInstance((Project)project).notifyImportantWarning(title, prefix + "<a href='" + url + "'>" + highlight + "</a>" + postfix, NotificationListener.URL_OPENING_LISTENER);
    }

    public static void showErrorURL(@NotNull Project project, @NotNull String title, @NotNull String prefix, @NotNull String highlight, @NotNull String postfix, @NotNull String url) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(30);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(31);
        }
        if (prefix == null) {
            GithubNotifications.$$$reportNull$$$0(32);
        }
        if (highlight == null) {
            GithubNotifications.$$$reportNull$$$0(33);
        }
        if (postfix == null) {
            GithubNotifications.$$$reportNull$$$0(34);
        }
        if (url == null) {
            GithubNotifications.$$$reportNull$$$0(35);
        }
        LOG.info(title + "; " + prefix + highlight + postfix + "; " + url);
        VcsNotifier.getInstance((Project)project).notifyError(title, prefix + "<a href='" + url + "'>" + highlight + "</a>" + postfix, NotificationListener.URL_OPENING_LISTENER);
    }

    public static void showInfoDialog(@Nullable Project project, @NotNull String title, @NotNull String message) {
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(36);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(37);
        }
        LOG.info(title + "; " + message);
        Messages.showInfoMessage((Project)project, (String)message, (String)title);
    }

    public static void showInfoDialog(@NotNull Component component, @NotNull String title, @NotNull String message) {
        if (component == null) {
            GithubNotifications.$$$reportNull$$$0(38);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(39);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(40);
        }
        LOG.info(title + "; " + message);
        Messages.showInfoMessage((Component)component, (String)message, (String)title);
    }

    public static void showWarningDialog(@Nullable Project project, @NotNull String title, @NotNull String message) {
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(41);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(42);
        }
        LOG.info(title + "; " + message);
        Messages.showWarningDialog((Project)project, (String)message, (String)title);
    }

    public static void showWarningDialog(@NotNull Component component, @NotNull String title, @NotNull String message) {
        if (component == null) {
            GithubNotifications.$$$reportNull$$$0(43);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(44);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(45);
        }
        LOG.info(title + "; " + message);
        Messages.showWarningDialog((Component)component, (String)message, (String)title);
    }

    public static void showErrorDialog(@Nullable Project project, @NotNull String title, @NotNull String message) {
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(46);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(47);
        }
        LOG.info(title + "; " + message);
        Messages.showErrorDialog((Project)project, (String)message, (String)title);
    }

    public static void showErrorDialog(@Nullable Project project, @NotNull String title, @NotNull Exception e) {
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(48);
        }
        if (e == null) {
            GithubNotifications.$$$reportNull$$$0(49);
        }
        LOG.warn(title, (Throwable)e);
        if (GithubNotifications.isOperationCanceled(e)) {
            return;
        }
        Messages.showErrorDialog((Project)project, (String)GithubUtil.getErrorTextFromException(e), (String)title);
    }

    public static void showErrorDialog(@NotNull Component component, @NotNull String title, @NotNull Exception e) {
        if (component == null) {
            GithubNotifications.$$$reportNull$$$0(50);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(51);
        }
        if (e == null) {
            GithubNotifications.$$$reportNull$$$0(52);
        }
        LOG.info(title, (Throwable)e);
        if (GithubNotifications.isOperationCanceled(e)) {
            return;
        }
        Messages.showErrorDialog((Component)component, (String)GithubUtil.getErrorTextFromException(e), (String)title);
    }

    public static void showErrorDialog(@NotNull Component component, @NotNull String title, @NotNull String prefix, @NotNull Exception e) {
        if (component == null) {
            GithubNotifications.$$$reportNull$$$0(53);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(54);
        }
        if (prefix == null) {
            GithubNotifications.$$$reportNull$$$0(55);
        }
        if (e == null) {
            GithubNotifications.$$$reportNull$$$0(56);
        }
        LOG.info(title, (Throwable)e);
        if (GithubNotifications.isOperationCanceled(e)) {
            return;
        }
        Messages.showErrorDialog((Component)component, (String)(prefix + GithubUtil.getErrorTextFromException(e)), (String)title);
    }

    @Messages.YesNoResult
    public static boolean showYesNoDialog(@Nullable Project project, @NotNull String title, @NotNull String message) {
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(57);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(58);
        }
        return 0 == Messages.showYesNoDialog((Project)project, (String)message, (String)title, (Icon)Messages.getQuestionIcon());
    }

    @Messages.YesNoResult
    public static boolean showYesNoDialog(@Nullable Project project, @NotNull String title, @NotNull String message, @NotNull DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(59);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(60);
        }
        if (doNotAskOption == null) {
            GithubNotifications.$$$reportNull$$$0(61);
        }
        return 0 == Messages.showYesNoDialog((Project)project, (String)message, (String)title, (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)doNotAskOption);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 20: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 18: 
            case 21: 
            case 25: 
            case 31: 
            case 36: 
            case 39: 
            case 41: 
            case 44: 
            case 46: 
            case 48: 
            case 51: 
            case 54: 
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 6: 
            case 12: 
            case 15: 
            case 22: 
            case 37: 
            case 40: 
            case 42: 
            case 45: 
            case 47: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logDetails";
                break;
            }
            case 23: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 26: 
            case 32: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlight";
                break;
            }
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfix";
                break;
            }
            case 38: 
            case 43: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doNotAskOption";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/github/util/GithubNotifications";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isOperationCanceled";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showInfo";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "showWarning";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "showError";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "showInfoURL";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "showWarningURL";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorURL";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "showInfoDialog";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[2] = "showWarningDialog";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorDialog";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[2] = "showYesNoDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

