/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.quirksmode;

import com.intellij.openapi.util.Comparing;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssAttribute;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssPseudoClass;
import com.intellij.psi.css.CssPseudoElement;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.quirksmode.CssPatterns;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CssSelectorPattern
extends PsiElementPattern<CssSelector, CssSelectorPattern> {
    public CssSelectorPattern() {
        super(CssSelector.class);
    }

    public CssSelectorPattern withClassDefinition() {
        return this.withClassDefinitions((ElementPattern<Collection<CssClass>>)StandardPatterns.not((ElementPattern)StandardPatterns.collection(CssClass.class).empty()));
    }

    public CssSelectorPattern withClassDefinitions(@NotNull ElementPattern<Collection<CssClass>> pattern) {
        if (pattern == null) {
            CssSelectorPattern.$$$reportNull$$$0(0);
        }
        return (CssSelectorPattern)this.withChild((ElementPattern)CssPatterns.cssSimpleSelector().withSuffices((ElementPattern)StandardPatterns.collection(CssClass.class).filter((ElementPattern)StandardPatterns.instanceOf(CssClass.class), pattern)));
    }

    public CssSelectorPattern withClassDefinition(@NotNull @NonNls String className) {
        if (className == null) {
            CssSelectorPattern.$$$reportNull$$$0(1);
        }
        return this.withClassDefinitions((ElementPattern<Collection<CssClass>>)StandardPatterns.collection(CssClass.class).atLeastOne((ElementPattern)PlatformPatterns.psiElement(CssClass.class).withName(className)));
    }

    public CssSelectorPattern withPseudoClass(final String ... classNames) {
        if (classNames == null) {
            CssSelectorPattern.$$$reportNull$$$0(2);
        }
        return (CssSelectorPattern)this.withChild((ElementPattern)CssPatterns.cssSimpleSelector().withSuffices((ElementPattern)StandardPatterns.collection(CssPseudoClass.class).atLeastOne((ElementPattern)StandardPatterns.instanceOf(CssPseudoClass.class).with((PatternCondition)new PatternCondition<CssPseudoClass>("withPseudoClass"){

            public boolean accepts(@NotNull CssPseudoClass cssPseudoClass, ProcessingContext context) {
                if (cssPseudoClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (String className : classNames) {
                    if (!Comparing.equal((String)cssPseudoClass.getName(), (String)className)) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cssPseudoClass", "com/jetbrains/quirksmode/CssSelectorPattern$1", "accepts"));
            }
        }))));
    }

    public CssSelectorPattern withPseudoElement(final String ... classNames) {
        if (classNames == null) {
            CssSelectorPattern.$$$reportNull$$$0(3);
        }
        return (CssSelectorPattern)this.withChild((ElementPattern)CssPatterns.cssSimpleSelector().withSuffices((ElementPattern)StandardPatterns.collection(CssPseudoElement.class).atLeastOne((ElementPattern)StandardPatterns.instanceOf(CssPseudoElement.class).with((PatternCondition)new PatternCondition<CssPseudoElement>("withPseudoElement"){

            public boolean accepts(@NotNull CssPseudoElement cssPseudoElement, ProcessingContext context) {
                if (cssPseudoElement == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (String className : classNames) {
                    if (!Comparing.equal((String)cssPseudoElement.getName(), (String)className)) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cssPseudoElement", "com/jetbrains/quirksmode/CssSelectorPattern$2", "accepts"));
            }
        }))));
    }

    public CssSelectorPattern withCssDeclaration(final @NotNull String name, final String ... values) {
        if (name == null) {
            CssSelectorPattern.$$$reportNull$$$0(4);
        }
        if (values == null) {
            CssSelectorPattern.$$$reportNull$$$0(5);
        }
        return (CssSelectorPattern)this.with((PatternCondition)new PatternCondition<CssSelector>("withCssDeclaration"){

            public boolean accepts(@NotNull CssSelector cssSelector, ProcessingContext context) {
                CssRuleset cssRuleset;
                if (cssSelector == null) {
                    3.$$$reportNull$$$0(0);
                }
                return (cssRuleset = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)cssSelector, CssRuleset.class)) != null && CssPatterns.cssRuleset().withDeclaration(name, values).accepts(cssRuleset);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cssSelector", "com/jetbrains/quirksmode/CssSelectorPattern$3", "accepts"));
            }
        });
    }

    public CssSelectorPattern withTagName(@NotNull @NonNls String tagName) {
        if (tagName == null) {
            CssSelectorPattern.$$$reportNull$$$0(6);
        }
        return (CssSelectorPattern)this.withChild((ElementPattern)CssPatterns.cssSimpleSelector().withTagName(tagName));
    }

    public CssSelectorPattern withNoClassDefenition() {
        return (CssSelectorPattern)this.and((ElementPattern)StandardPatterns.not((ElementPattern)this.withClassDefinition()));
    }

    public CssSelectorPattern isUniversalSelector() {
        return (CssSelectorPattern)this.withChild((ElementPattern)CssPatterns.cssSimpleSelector().isUniversalSelector());
    }

    public CssSelectorPattern withGreaterSuffix() {
        return this.withCombinator(CssSelector.Combinator.CHILD);
    }

    public CssSelectorPattern withPlusSuffix() {
        return this.withCombinator(CssSelector.Combinator.SIBLING);
    }

    public CssSelectorPattern withTildeSuffix() {
        return this.withCombinator(CssSelector.Combinator.FOLLOWING_SIBLING);
    }

    public CssSelectorPattern withCombinator(final CssSelector.Combinator combinator) {
        return (CssSelectorPattern)this.with((PatternCondition)new PatternCondition<CssSelector>("withCombinator"){

            public boolean accepts(@NotNull CssSelector selector, ProcessingContext context) {
                if (selector == null) {
                    4.$$$reportNull$$$0(0);
                }
                return ArrayUtil.contains((Object)combinator, (Object[])selector.getCombinators());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/jetbrains/quirksmode/CssSelectorPattern$4", "accepts"));
            }
        });
    }

    public CssSelectorPattern withAttribute() {
        return (CssSelectorPattern)this.withChild((ElementPattern)CssPatterns.cssSimpleSelector().withSuffices((ElementPattern)StandardPatterns.collection(CssAttribute.class).atLeastOne((ElementPattern)StandardPatterns.instanceOf(CssAttribute.class))));
    }

    public CssSelectorPattern withPseudoElement() {
        return (CssSelectorPattern)this.withChild((ElementPattern)CssPatterns.cssSimpleSelector().withSuffices((ElementPattern)StandardPatterns.collection(CssPseudoElement.class).atLeastOne((ElementPattern)StandardPatterns.instanceOf(CssPseudoElement.class))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classNames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/quirksmode/CssSelectorPattern";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "withClassDefinitions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "withClassDefinition";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "withPseudoClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "withPseudoElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "withCssDeclaration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "withTagName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

