/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.quirksmode;

import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.XmlFilePattern;
import com.intellij.psi.impl.source.xml.XmlDoctypeImpl;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SharedProcessingContext;
import com.jetbrains.quirksmode.Browser;
import com.jetbrains.quirksmode.BrowserSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HtmlFilePattern
extends XmlFilePattern<HtmlFilePattern> {
    public static final Key<BrowserSet> ACTIVE_BROWSERS_KEY = new Key("QUIRKS_MODE_ACTIVE_BROWSERS");
    @NonNls
    private static final Set<String> STD_IDS = new HashSet<String>(Arrays.asList("-//W3C//DTD HTML 4.01//EN", "-//W3C//DTD HTML 4.0//EN", "-//W3C//DTD XHTML 1.0 Strict//EN", "ISO/IEC 15445:2000//DTD HyperText Markup Language//EN", "ISO/IEC 15445:2000//DTD HTML//EN", "-//IETF//DTD HTML i18n//EN"));
    @NonNls
    private static final Set<String> ALMOST_STD_IDS = new HashSet<String>(Arrays.asList("-//W3C//DTD XHTML 1.0 Transitional//EN", "-//W3C//DTD XHTML 1.0 Frameset//EN"));
    @NonNls
    private static final Set<String> ALMOST_STD_WITH_SYSTEM = new HashSet<String>(Arrays.asList("-//W3C//DTD HTML 4.01 Transitional//EN", "-//W3C//DTD HTML 4.01 Frameset//EN"));

    public HtmlFilePattern inQuirksMode() {
        return (HtmlFilePattern)this.with((PatternCondition)new PatternCondition<XmlFile>("inQuirksMode"){

            public boolean accepts(@NotNull XmlFile xmlFile, ProcessingContext context) {
                if (xmlFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                return HtmlFilePattern.isInQuirksMode(xmlFile, context.getSharedContext());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/jetbrains/quirksmode/HtmlFilePattern$1", "accepts"));
            }
        });
    }

    private static boolean isInQuirksMode(@NotNull XmlFile file, @NotNull SharedProcessingContext context) {
        BrowserSet browserSet;
        if (file == null) {
            HtmlFilePattern.$$$reportNull$$$0(0);
        }
        if (context == null) {
            HtmlFilePattern.$$$reportNull$$$0(1);
        }
        if ((browserSet = (BrowserSet)context.get(ACTIVE_BROWSERS_KEY)) == null) {
            browserSet = BrowserSet.ALL;
        }
        return HtmlFilePattern.isInQuirksMode(file, browserSet);
    }

    private static boolean isInQuirksMode(@NotNull XmlFile file, @NotNull BrowserSet browserSet) {
        if (file == null) {
            HtmlFilePattern.$$$reportNull$$$0(2);
        }
        if (browserSet == null) {
            HtmlFilePattern.$$$reportNull$$$0(3);
        }
        if (browserSet.contains(Browser.IE_55_WINDOWS)) {
            return true;
        }
        if (XHTMLLanguage.INSTANCE.equals(file.getLanguage())) {
            return false;
        }
        XmlDocument document = file.getDocument();
        if (document == null) {
            return true;
        }
        XmlProlog prolog = document.getProlog();
        if (prolog == null) {
            return true;
        }
        XmlDoctypeImpl xmlDoctype = (XmlDoctypeImpl)prolog.getDoctype();
        if (xmlDoctype == null) {
            return true;
        }
        if (null != xmlDoctype.findChildByRole(228)) {
            return false;
        }
        if (xmlDoctype.getDtdUrlElement() == null) {
            return false;
        }
        String publicId = xmlDoctype.getPublicId();
        return !STD_IDS.contains(publicId) && !ALMOST_STD_IDS.contains(publicId) && !ALMOST_STD_WITH_SYSTEM.contains(publicId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "browserSet";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/quirksmode/HtmlFilePattern";
        objectArray[2] = "isInQuirksMode";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

