/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.augment;

import com.intellij.lang.aspectj.AspectJFileType;
import com.intellij.lang.aspectj.augment.LightInterTypeMethod;
import com.intellij.lang.aspectj.index.stub.AspectJInterTypeClassIndex;
import com.intellij.lang.aspectj.index.stub.AspectJInterTypeFieldIndex;
import com.intellij.lang.aspectj.index.stub.AspectJInterTypeMethodIndex;
import com.intellij.lang.aspectj.psi.PsiInterTypeDeclaration;
import com.intellij.lang.aspectj.psi.PsiInterTypeMethod;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AjPsiAugmentProvider
extends PsiAugmentProvider {
    @NotNull
    public <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement element, @NotNull Class<Psi> type) {
        if (element == null) {
            AjPsiAugmentProvider.$$$reportNull$$$0(0);
        }
        if (type == null) {
            AjPsiAugmentProvider.$$$reportNull$$$0(1);
        }
        List<Psi> list = AjPsiAugmentProvider.getAjAugments(element, type);
        if (list == null) {
            AjPsiAugmentProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static <Psi extends PsiElement> List<Psi> getAjAugments(@NotNull PsiElement element, @NotNull Class<Psi> type) {
        if (element == null) {
            AjPsiAugmentProvider.$$$reportNull$$$0(3);
        }
        if (type == null) {
            AjPsiAugmentProvider.$$$reportNull$$$0(4);
        }
        if (element instanceof PsiClass && AjPsiAugmentProvider.hasAspectJ(element.getProject())) {
            List<Psi> list = AjPsiAugmentProvider.getClassAugments((PsiClass)element, type);
            if (list == null) {
                AjPsiAugmentProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            AjPsiAugmentProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static boolean hasAspectJ(@NotNull Project project) {
        if (project == null) {
            AjPsiAugmentProvider.$$$reportNull$$$0(7);
        }
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            if (project == null) {
                AjPsiAugmentProvider.$$$reportNull$$$0(23);
            }
            boolean value = FileTypeIndex.containsFileOfType((FileType)AspectJFileType.INSTANCE, (GlobalSearchScope)ProjectScope.getProjectScope((Project)project));
            return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @NotNull
    private static <Psi extends PsiElement> List<Psi> getClassAugments(@NotNull PsiClass aClass, @NotNull Class<Psi> type) {
        if (aClass == null) {
            AjPsiAugmentProvider.$$$reportNull$$$0(8);
        }
        if (type == null) {
            AjPsiAugmentProvider.$$$reportNull$$$0(9);
        }
        ArrayList augments = ContainerUtil.newArrayList();
        if (!aClass.isEnum()) {
            if (!(aClass instanceof PsiAnonymousClass)) {
                AjPsiAugmentProvider.addClassAugments(augments, aClass, type);
            }
            if (aClass instanceof PsiAnonymousClass) {
                PsiClass baseClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)((NullableComputable)() -> {
                    if (aClass == null) {
                        AjPsiAugmentProvider.$$$reportNull$$$0(22);
                    }
                    return ((PsiAnonymousClass)aClass).getBaseClassType().resolve();
                }));
                if (baseClass != null && baseClass.isInterface()) {
                    AjPsiAugmentProvider.addInterfaceAugments(augments, baseClass, aClass, type);
                }
            } else if (!aClass.isInterface()) {
                PsiClass[] interfaces;
                for (PsiClass anInterface : interfaces = (PsiClass[])ReadAction.compute(() -> {
                    if (aClass == null) {
                        AjPsiAugmentProvider.$$$reportNull$$$0(21);
                    }
                    return aClass.getInterfaces();
                })) {
                    AjPsiAugmentProvider.addInterfaceAugments(augments, anInterface, aClass, type);
                }
            }
        }
        ArrayList arrayList = augments;
        if (arrayList == null) {
            AjPsiAugmentProvider.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static <Psi extends PsiElement> void addClassAugments(@NotNull Collection<Psi> augments, final @NotNull PsiClass aClass, @NotNull Class<Psi> type) {
        LightMethod psi;
        Collection<PsiInterTypeDeclaration> declarations;
        if (augments == null) {
            AjPsiAugmentProvider.$$$reportNull$$$0(11);
        }
        if (aClass == null) {
            AjPsiAugmentProvider.$$$reportNull$$$0(12);
        }
        if (type == null) {
            AjPsiAugmentProvider.$$$reportNull$$$0(13);
        }
        if ((declarations = AjPsiAugmentProvider.getAllDeclarations(aClass, type)) == null) {
            return;
        }
        boolean isInterface = aClass.isInterface();
        for (PsiInterTypeDeclaration psiInterTypeDeclaration : declarations) {
            if (isInterface && !AjPsiAugmentProvider.isAbstractMethod(psiInterTypeDeclaration) && type != PsiField.class) continue;
            PsiInterTypeDeclaration psi2 = psiInterTypeDeclaration;
            augments.add(psi2);
        }
        if (isInterface && type == PsiMethod.class) {
            List ownMethods = null;
            block1: for (PsiInterTypeDeclaration declaration : declarations) {
                if (AjPsiAugmentProvider.isAbstractMethod(declaration)) continue;
                MethodSignature candidateSignature = ((PsiMethod)declaration).getSignature(PsiSubstitutor.EMPTY);
                for (PsiElement augment : augments) {
                    if (!candidateSignature.equals(((PsiMethod)augment).getSignature(PsiSubstitutor.EMPTY))) continue;
                    continue block1;
                }
                if (ownMethods == null) {
                    ownMethods = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)aClass, PsiMethod.class);
                }
                for (PsiMethod ownMethod : ownMethods) {
                    if (!candidateSignature.equals(ownMethod.getSignature(PsiSubstitutor.EMPTY))) continue;
                    continue block1;
                }
                for (Iterator<Object> iterator : aClass.getInterfaces()) {
                    PsiMethod same = (PsiMethod)RecursionManager.doPreventingRecursion((Object)aClass, (boolean)true, (Computable)((NullableComputable)() -> parent.findMethodBySignature((PsiMethod)declaration, true)));
                    if (same != null) continue block1;
                }
                psi = new LightInterTypeMethod((PsiInterTypeMethod)declaration, aClass);
                augments.add(psi);
            }
        }
        if (type == PsiMethod.class) {
            boolean shouldAddCtor = false;
            for (PsiInterTypeDeclaration declaration : declarations) {
                PsiMethod method2;
                if (!(declaration instanceof PsiMethod) || !(method2 = (PsiMethod)declaration).isConstructor()) continue;
                shouldAddCtor = true;
                if (method2.getParameterList().getParametersCount() != 0) continue;
                shouldAddCtor = false;
                break;
            }
            if (shouldAddCtor) {
                List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)aClass, PsiMethod.class);
                boolean bl = shouldAddCtor = !ContainerUtil.exists((Iterable)list, method -> method.isConstructor());
                if (shouldAddCtor) {
                    PsiElementFactory factory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
                    PsiMethod method2 = factory.createMethodFromText("public " + aClass.getName() + "() {}", (PsiElement)aClass);
                    psi = new LightMethod(aClass.getManager(), method2, aClass){

                        @NotNull
                        public PsiElement getNavigationElement() {
                            PsiElement psiElement = aClass.getNavigationElement();
                            if (psiElement == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return psiElement;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/augment/AjPsiAugmentProvider$1", "getNavigationElement"));
                        }
                    };
                    augments.add(psi);
                }
            }
        }
    }

    private static <Psi extends PsiElement> void addInterfaceAugments(@NotNull Collection<Psi> augments, @NotNull PsiClass anInterface, @NotNull PsiClass aClass, @NotNull Class<Psi> type) {
        Collection<PsiInterTypeDeclaration> declarations;
        if (augments == null) {
            AjPsiAugmentProvider.$$$reportNull$$$0(14);
        }
        if (anInterface == null) {
            AjPsiAugmentProvider.$$$reportNull$$$0(15);
        }
        if (aClass == null) {
            AjPsiAugmentProvider.$$$reportNull$$$0(16);
        }
        if (type == null) {
            AjPsiAugmentProvider.$$$reportNull$$$0(17);
        }
        if ((declarations = AjPsiAugmentProvider.getAllDeclarations(anInterface, type)) == null) {
            return;
        }
        List ownMethods = null;
        block0: for (PsiInterTypeDeclaration declaration : declarations) {
            if (type != PsiMethod.class || AjPsiAugmentProvider.isAbstractMethod(declaration)) continue;
            MethodSignature candidateSignature = ((PsiMethod)declaration).getSignature(PsiSubstitutor.EMPTY);
            if (ownMethods == null) {
                ownMethods = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)aClass, PsiMethod.class);
            }
            for (PsiMethod ownMethod : ownMethods) {
                if (!candidateSignature.equals(ownMethod.getSignature(PsiSubstitutor.EMPTY))) continue;
                continue block0;
            }
            LightInterTypeMethod psi = new LightInterTypeMethod((PsiInterTypeMethod)declaration, aClass);
            augments.add(psi);
        }
    }

    @Nullable
    private static Collection<PsiInterTypeDeclaration> getAllDeclarations(@NotNull PsiClass aClass, @NotNull Class<?> type) {
        String className;
        if (aClass == null) {
            AjPsiAugmentProvider.$$$reportNull$$$0(18);
        }
        if (type == null) {
            AjPsiAugmentProvider.$$$reportNull$$$0(19);
        }
        if ((className = (String)ReadAction.compute(() -> {
            if (aClass == null) {
                AjPsiAugmentProvider.$$$reportNull$$$0(20);
            }
            return aClass.getName();
        })) == null) {
            return null;
        }
        Project project = aClass.getProject();
        if (DumbService.getInstance((Project)project).isDumb()) {
            return null;
        }
        GlobalSearchScope scope = ProjectScope.getProjectScope((Project)project);
        Collection<PsiInterTypeDeclaration> rawResults = null;
        try {
            if (type == PsiField.class) {
                rawResults = AspectJInterTypeFieldIndex.getInstance().get(className, project, scope);
            } else if (type == PsiMethod.class) {
                rawResults = AspectJInterTypeMethodIndex.getInstance().get(className, project, scope);
            } else if (type == PsiClass.class) {
                rawResults = AspectJInterTypeClassIndex.getInstance().get(className, project, scope);
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        if (rawResults == null) {
            return null;
        }
        LinkedList filteredResults = ContainerUtil.newLinkedList();
        for (PsiInterTypeDeclaration psiInterTypeDeclaration : rawResults) {
            if (!aClass.isEquivalentTo((PsiElement)psiInterTypeDeclaration.getInterTypeReference().getReferencedClass())) continue;
            filteredResults.add(psiInterTypeDeclaration);
        }
        return filteredResults;
    }

    private static boolean isAbstractMethod(@Nullable PsiInterTypeDeclaration member) {
        return member instanceof PsiMethod && ((PsiMethod)member).getModifierList().hasExplicitModifier("abstract");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/aspectj/augment/AjPsiAugmentProvider";
                break;
            }
            case 7: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "augments";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anInterface";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/aspectj/augment/AjPsiAugmentProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAugments";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAjAugments";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassAugments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAugments";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAjAugments";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasAspectJ";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getClassAugments";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addClassAugments";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addInterfaceAugments";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAllDeclarations";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAllDeclarations$5";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getClassAugments$2";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getClassAugments$1";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$hasAspectJ$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

