/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.psi.impl;

import com.intellij.aop.AopAdviceType;
import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.aspectj.parsing.AspectJTokenType;
import com.intellij.lang.aspectj.psi.AjAdvice;
import com.intellij.lang.aspectj.psi.AjElementVisitor;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.impl.AjKeywordImpl;
import com.intellij.lang.aspectj.psi.util.InterTypeResolveUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AjAdviceImpl
extends ASTWrapperPsiElement
implements AjAdvice {
    private static final String PROCEED = "proceed";
    private static final Map<String, String> THIS_JOIN_POINTS = ContainerUtil.newHashMap((Pair)Pair.pair((Object)"thisJoinPoint", (Object)"org.aspectj.lang.JoinPoint"), (Pair[])new Pair[]{Pair.pair((Object)"thisJoinPointStaticPart", (Object)"org.aspectj.lang.JoinPoint.StaticPart"), Pair.pair((Object)"thisEnclosingJoinPointStaticPart", (Object)"org.aspectj.lang.JoinPoint.EnclosingStaticPart")});

    public AjAdviceImpl(@NotNull ASTNode node) {
        if (node == null) {
            AjAdviceImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @NotNull
    public PsiAspect getAspect() {
        PsiAspect psiAspect = (PsiAspect)this.getParent();
        if (psiAspect == null) {
            AjAdviceImpl.$$$reportNull$$$0(1);
        }
        return psiAspect;
    }

    @Override
    @NotNull
    public AopAdviceType getAdviceType() {
        AopAdviceType type = this.getCachedAdviceType();
        assert (type != null) : "Unable to calc type: " + this.getText();
        AopAdviceType aopAdviceType = type;
        if (aopAdviceType == null) {
            AjAdviceImpl.$$$reportNull$$$0(2);
        }
        return aopAdviceType;
    }

    private AopAdviceType getCachedAdviceType() {
        return (AopAdviceType)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            AopAdviceType result = null;
            List keywords = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, AjKeywordImpl.class);
            if (keywords.size() > 0) {
                IElementType type = ((AjKeywordImpl)((Object)((Object)keywords.get(0)))).getTokenType();
                if (type == AspectJTokenType.BEFORE_KEYWORD) {
                    result = AopAdviceType.BEFORE;
                } else if (type == AspectJTokenType.AROUND_KEYWORD) {
                    result = AopAdviceType.AROUND;
                } else if (type == AspectJTokenType.AFTER_KEYWORD) {
                    IElementType subType;
                    IElementType iElementType = subType = keywords.size() > 1 ? ((AjKeywordImpl)((Object)((Object)keywords.get(1)))).getTokenType() : null;
                    if (subType == null) {
                        result = AopAdviceType.AFTER;
                    } else if (subType == AspectJTokenType.RETURNING_KEYWORD) {
                        result = AopAdviceType.AFTER_RETURNING;
                    } else if (subType == AspectJTokenType.THROWING_KEYWORD) {
                        result = AopAdviceType.AFTER_THROWING;
                    }
                }
            }
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        });
    }

    @Override
    public PsiTypeElement getTypeElement() {
        return (PsiTypeElement)PsiTreeUtil.getChildOfType((PsiElement)this, PsiTypeElement.class);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        block13: {
            PsiMethod candidate;
            if (processor == null) {
                AjAdviceImpl.$$$reportNull$$$0(3);
            }
            if (state == null) {
                AjAdviceImpl.$$$reportNull$$$0(4);
            }
            if (place == null) {
                AjAdviceImpl.$$$reportNull$$$0(5);
            }
            if (!(lastParent instanceof PsiCodeBlock)) break block13;
            NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
            String name = nameHint != null ? nameHint.getName(state) : null;
            ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
            if (!(classHint != null && !classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD) || nameHint != null && !PROCEED.equals(name) || processor.execute((PsiElement)(candidate = this.getCachedProceedMethod()), state))) {
                return false;
            }
            if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.FIELD) || classHint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) {
                if (nameHint == null || THIS_JOIN_POINTS.containsKey(name)) {
                    Map<String, PsiField> points = this.getCachedThisJoinPoints();
                    if (name != null) {
                        PsiField candidate2 = points.get(name);
                        if (!processor.execute((PsiElement)candidate2, state)) {
                            return false;
                        }
                    } else {
                        for (PsiField candidate3 : points.values()) {
                            if (processor.execute((PsiElement)candidate3, state)) continue;
                            return false;
                        }
                    }
                } else {
                    List parameterLists = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, PsiParameterList.class);
                    for (PsiParameterList parameterList : parameterLists) {
                        for (PsiParameter parameter : parameterList.getParameters()) {
                            if (processor.execute((PsiElement)parameter, state)) continue;
                            return false;
                        }
                    }
                }
            }
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    private PsiMethod getCachedProceedMethod() {
        return (PsiMethod)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            PsiTypeElement typeElement = this.getTypeElement();
            String type = typeElement != null ? typeElement.getText() : "void";
            String text = "public " + type + " " + PROCEED + "(Object... args) {}";
            PsiMethod method = InterTypeResolveUtil.createArtificialMethod(text, this.getAspect());
            return CachedValueProvider.Result.create((Object)method, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        });
    }

    private Map<String, PsiField> getCachedThisJoinPoints() {
        return (Map)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            HashMap result = ContainerUtil.newHashMap();
            for (Map.Entry<String, String> entry : THIS_JOIN_POINTS.entrySet()) {
                String text = "public " + entry.getValue() + " " + entry.getKey();
                result.put(entry.getKey(), InterTypeResolveUtil.createArtificialField(text, this.getAspect()));
            }
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        });
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            AjAdviceImpl.$$$reportNull$$$0(6);
        }
        if (visitor instanceof AjElementVisitor) {
            ((AjElementVisitor)visitor).visitAdvice(this);
        } else {
            super.accept(visitor);
        }
    }

    public String toString() {
        return "AjAdvice:" + this.getAdviceType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/aspectj/psi/impl/AjAdviceImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/aspectj/psi/impl/AjAdviceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAspect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdviceType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

