/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.aspectj.psi.AjElementVisitor;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.PsiInterTypeReference;
import com.intellij.lang.aspectj.psi.util.InterTypeResolveUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiInterTypeReferenceImpl
extends ASTWrapperPsiElement
implements PsiInterTypeReference {
    private CachedValue<PsiClass> myRefCache;

    public PsiInterTypeReferenceImpl(@NotNull ASTNode node) {
        if (node == null) {
            PsiInterTypeReferenceImpl.$$$reportNull$$$0(0);
        }
        super(node);
        this.myRefCache = null;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement getReferenceElement() {
        PsiTypeElement type = (PsiTypeElement)PsiTreeUtil.getRequiredChildOfType((PsiElement)this, PsiTypeElement.class);
        PsiJavaCodeReferenceElement reference = type.getInnermostComponentReferenceElement();
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = reference != null ? reference : (PsiJavaCodeReferenceElement)PsiTreeUtil.getRequiredChildOfType((PsiElement)type, PsiJavaCodeReferenceElement.class);
        if (psiJavaCodeReferenceElement == null) {
            PsiInterTypeReferenceImpl.$$$reportNull$$$0(1);
        }
        return psiJavaCodeReferenceElement;
    }

    @Override
    @Nullable
    public PsiClass getReferencedClass() {
        return (PsiClass)this.getRefCache().getValue();
    }

    private synchronized CachedValue<PsiClass> getRefCache() {
        if (this.myRefCache == null) {
            this.myRefCache = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
                PsiClass value = (PsiClass)ReadAction.compute(() -> (PsiClass)this.getReferenceElement().resolve());
                return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{value != null ? value : PsiModificationTracker.MODIFICATION_COUNT});
            });
        }
        return this.myRefCache;
    }

    @Override
    @NotNull
    public String getReferencedClassName() {
        PsiJavaCodeReferenceElement refElement = this.getReferenceElement();
        PsiElement nameElement = refElement.getReferenceNameElement();
        assert (nameElement != null) : refElement;
        String string = nameElement.getText();
        if (string == null) {
            PsiInterTypeReferenceImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        ElementClassHint hint;
        if (processor == null) {
            PsiInterTypeReferenceImpl.$$$reportNull$$$0(3);
        }
        if (state == null) {
            PsiInterTypeReferenceImpl.$$$reportNull$$$0(4);
        }
        if (place == null) {
            PsiInterTypeReferenceImpl.$$$reportNull$$$0(5);
        }
        if ((hint = (ElementClassHint)processor.getHint(ElementClassHint.KEY)) != null && hint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            PsiClass target;
            String name;
            Pair<Integer, PsiTypeElement> result;
            NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
            if (nameHint != null && (result = InterTypeResolveUtil.findTypeReferenceByName(this, name = nameHint.getName(state))) != null && ((PsiTypeElement)result.second).equals(place.getParent()) && (target = this.getReferencedClass()) != null && !InterTypeResolveUtil.resolveToClassTypeParameter(target, (Integer)result.first, processor, state, name)) {
                return false;
            }
            PsiAspect aspect = this.getAspect();
            if (aspect != null && !aspect.processDeclarations(processor, state, lastParent, place)) {
                return false;
            }
            this.getContainingFile().processDeclarations(processor, state, lastParent, place);
            return false;
        }
        return true;
    }

    @Nullable
    private PsiAspect getAspect() {
        PsiElement aspect;
        PsiElement declaration = this.getParent();
        if (declaration != null && (aspect = declaration.getParent()) instanceof PsiAspect) {
            return (PsiAspect)aspect;
        }
        return null;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiInterTypeReferenceImpl.$$$reportNull$$$0(6);
        }
        if (visitor instanceof AjElementVisitor) {
            ((AjElementVisitor)visitor).visitInterTypeReference(this);
        } else {
            super.accept(visitor);
        }
    }

    public String toString() {
        return "PsiInterTypeReference:" + this.getText().trim();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/aspectj/psi/impl/PsiInterTypeReferenceImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/aspectj/psi/impl/PsiInterTypeReferenceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

