/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.refactoring.pushIn;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.refactoring.pushIn.ConflictUsageInfo;
import com.intellij.lang.aspectj.refactoring.pushIn.InterTypeUsageInfo;
import com.intellij.lang.aspectj.refactoring.pushIn.PushInConflictsUtil;
import com.intellij.lang.aspectj.refactoring.pushIn.PushInHandler;
import com.intellij.lang.aspectj.refactoring.pushIn.PushInProcessingTask;
import com.intellij.lang.aspectj.refactoring.pushIn.PushInVisitor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PushInProcessor
extends BaseRefactoringProcessor {
    private final List<PsiElement> myElements;
    private final boolean myDeleteAspects;

    public PushInProcessor(Project project, List<PsiElement> elements, boolean deleteAspects) {
        super(project, EmptyRunnable.INSTANCE);
        this.myElements = elements;
        this.myDeleteAspects = deleteAspects;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        PushInVisitor visitor = new PushInVisitor();
        HashSet visited = ContainerUtil.newHashSet();
        for (PsiElement element : this.myElements) {
            PushInProcessor.collectUsages(element, visitor, visited);
        }
        UsageInfo[] usageInfoArray = UsageViewUtil.toUsageInfoArray(visitor.getUsages());
        if (usageInfoArray == null) {
            PushInProcessor.$$$reportNull$$$0(0);
        }
        return usageInfoArray;
    }

    private static void collectUsages(PsiElement element, PushInVisitor visitor, Set<PsiDirectory> visited) {
        if (element instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)element;
            if (!visited.add(directory)) {
                return;
            }
            Project project = directory.getProject();
            if (ProjectRootsUtil.isProjectHome((PsiDirectory)directory)) {
                VirtualFile[] roots = ProjectRootManager.getInstance((Project)project).getContentSourceRoots();
                PushInProcessor.collectUsages(visitor, visited, directory, roots);
                return;
            }
            if (ProjectRootsUtil.isModuleContentRoot((PsiDirectory)directory)) {
                Module module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(directory.getVirtualFile());
                VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
                PushInProcessor.collectUsages(visitor, visited, directory, roots);
                return;
            }
            if (!ProjectRootsUtil.isSourceRoot((PsiDirectory)directory) && !ProjectRootsUtil.isInSource((PsiDirectory)directory)) {
                return;
            }
        }
        element.accept((PsiElementVisitor)visitor);
    }

    private static void collectUsages(PushInVisitor visitor, Set<PsiDirectory> visited, PsiDirectory directory, VirtualFile[] roots) {
        PsiManager psiManager = directory.getManager();
        for (VirtualFile root : roots) {
            PsiDirectory rootDirectory = psiManager.findDirectory(root);
            assert (rootDirectory != null) : root;
            if (rootDirectory.equals(directory)) {
                rootDirectory.accept((PsiElementVisitor)visitor);
                continue;
            }
            PushInProcessor.collectUsages((PsiElement)rootDirectory, visitor, visited);
        }
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            PushInProcessor.$$$reportNull$$$0(1);
        }
        if (!super.preprocessUsages(refUsages)) {
            return false;
        }
        ArrayList filtered = ContainerUtil.newArrayListWithCapacity((int)((UsageInfo[])refUsages.get()).length);
        MultiMap conflicts = new MultiMap();
        for (UsageInfo usage : (UsageInfo[])refUsages.get()) {
            if (usage instanceof InterTypeUsageInfo) {
                filtered.add((InterTypeUsageInfo)usage);
                continue;
            }
            if (usage instanceof ConflictUsageInfo) {
                conflicts.putValue((Object)usage.getElement(), (Object)((ConflictUsageInfo)usage).getMessage());
                continue;
            }
            conflicts.putValue((Object)usage.getElement(), (Object)("Unknown usage of element " + usage.getElement()));
        }
        PushInConflictsUtil.checkNameConflicts(filtered, (MultiMap<PsiElement, String>)conflicts);
        PushInConflictsUtil.checkReferenceConflicts(filtered, (MultiMap<PsiElement, String>)conflicts);
        if (filtered.isEmpty() && conflicts.isEmpty()) {
            String message = AspectJBundle.message("action.push.in.nothing.found", new Object[0]);
            CommonRefactoringUtil.showErrorMessage((String)PushInHandler.getRefactoringName(), (String)message, (String)"Using_the_Push_ITDs_In_refactoring", (Project)this.myProject);
            return false;
        }
        if (conflicts.isEmpty()) {
            return true;
        }
        UsageInfo[] usages = UsageViewUtil.toUsageInfoArray((Collection)filtered);
        refUsages.set((Object)usages);
        return this.showConflicts(conflicts, (UsageInfo[])(usages.length > 0 ? usages : null));
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            PushInProcessor.$$$reportNull$$$0(2);
        }
        MyUsageViewDescriptor myUsageViewDescriptor = new MyUsageViewDescriptor(PsiUtilCore.toPsiElementArray(this.myElements), usages);
        if (myUsageViewDescriptor == null) {
            PushInProcessor.$$$reportNull$$$0(3);
        }
        return myUsageViewDescriptor;
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            PushInProcessor.$$$reportNull$$$0(4);
        }
        HashSet elementsToWrite = ContainerUtil.newHashSet();
        for (UsageInfo usage : ((MyUsageViewDescriptor)descriptor).getUsages()) {
            if (!(usage instanceof InterTypeUsageInfo)) continue;
            elementsToWrite.add(((InterTypeUsageInfo)usage).getSource());
            elementsToWrite.add(((InterTypeUsageInfo)usage).getTarget());
        }
        HashSet hashSet = elementsToWrite;
        if (hashSet == null) {
            PushInProcessor.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    protected String getCommandName() {
        return AspectJBundle.message("action.push.in.title", new Object[0]);
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            PushInProcessor.$$$reportNull$$$0(6);
        }
        SequentialModalProgressTask progressTask = new SequentialModalProgressTask(this.myProject, PushInHandler.getRefactoringName(), false);
        progressTask.setMinIterationTime(200L);
        progressTask.setTask((SequentialTask)new PushInProcessingTask(usages, progressTask, this.myDeleteAspects));
        ProgressManager.getInstance().run((Task)progressTask);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/aspectj/refactoring/pushIn/PushInProcessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/aspectj/refactoring/pushIn/PushInProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToWrite";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToWrite";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyUsageViewDescriptor
    implements UsageViewDescriptor {
        private final PsiElement[] myElements;
        private final UsageInfo[] myUsages;

        public MyUsageViewDescriptor(PsiElement[] elements, UsageInfo[] usages) {
            this.myUsages = usages;
            this.myElements = elements;
        }

        @NotNull
        public PsiElement[] getElements() {
            if (this.myElements == null) {
                MyUsageViewDescriptor.$$$reportNull$$$0(0);
            }
            return this.myElements;
        }

        @NotNull
        public UsageInfo[] getUsages() {
            if (this.myUsages == null) {
                MyUsageViewDescriptor.$$$reportNull$$$0(1);
            }
            return this.myUsages;
        }

        public String getProcessedElementsHeader() {
            return AspectJBundle.message("action.push.in.preview.sources", this.myElements.length);
        }

        public String getCodeReferencesText(int usagesCount, int filesCount) {
            return AspectJBundle.message("action.push.in.preview.usages", usagesCount, filesCount);
        }

        public String getCommentReferencesText(int usagesCount, int filesCount) {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/aspectj/refactoring/pushIn/PushInProcessor$MyUsageViewDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsages";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

