/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.util;

import com.intellij.lang.aspectj.build.config.AjPathEntries;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryUtil {
    private static final String RT_SIGNATURE_CLASS = "org.aspectj.lang.JoinPoint";
    private static final Collection<String> LIB_LEVELS = ContainerUtil.newTroveSet((Object[])new String[]{"application", "project"});

    private LibraryUtil() {
    }

    public static boolean hasAjRunTime(@Nullable Module module) {
        if (module == null) {
            return false;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        return facade.findClass(RT_SIGNATURE_CLASS, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) != null;
    }

    @NotNull
    public static Map<AjPathEntries.Entry, Object> mapEntries(@NotNull List<AjPathEntries.Entry> entries, @NotNull Project project) {
        if (entries == null) {
            LibraryUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            LibraryUtil.$$$reportNull$$$0(1);
        }
        if (entries.isEmpty()) {
            Map<AjPathEntries.Entry, Object> map = Collections.emptyMap();
            if (map == null) {
                LibraryUtil.$$$reportNull$$$0(2);
            }
            return map;
        }
        HashMap map = ContainerUtil.newHashMap();
        for (AjPathEntries.Entry entry : entries) {
            ModuleManager manager;
            Module module;
            if (entry instanceof AjPathEntries.LibraryEntry) {
                LibraryTablesRegistrar registrar = LibraryTablesRegistrar.getInstance();
                LibraryTable table = entry instanceof AjPathEntries.AppLibraryEntry ? registrar.getLibraryTable() : registrar.getLibraryTable(project);
                Library library = table.getLibraryByName(entry.getName());
                if (!LibraryUtil.isJavaLibrary(library)) continue;
                map.put(entry, library);
                continue;
            }
            if (!(entry instanceof AjPathEntries.ModuleEntry) || !LibraryUtil.isJavaModule(module = (manager = ModuleManager.getInstance((Project)project)).findModuleByName(entry.getName()))) continue;
            map.put(entry, module);
        }
        HashMap hashMap = map;
        if (hashMap == null) {
            LibraryUtil.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    @NotNull
    public static List<Object> getAspectPathCandidates(@NotNull Module module, @NotNull Collection<Object> existing) {
        if (module == null) {
            LibraryUtil.$$$reportNull$$$0(4);
        }
        if (existing == null) {
            LibraryUtil.$$$reportNull$$$0(5);
        }
        ArrayList candidates = ContainerUtil.newArrayList();
        HashSet visited = ContainerUtil.newHashSet();
        LibraryUtil.collectCandidates(module, existing, candidates, false, visited);
        candidates.remove(module);
        ArrayList arrayList = candidates;
        if (arrayList == null) {
            LibraryUtil.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static void collectCandidates(Module module, Collection<Object> filter, List<Object> candidates, boolean exportedOnly, Set<Module> visited) {
        if (!visited.add(module)) {
            return;
        }
        ModuleRootManager.getInstance((Module)module).orderEntries().withoutSdk().compileOnly().forEach(entry -> {
            if (!exportedOnly || entry instanceof ExportableOrderEntry && ((ExportableOrderEntry)entry).isExported()) {
                Module dependency;
                Module candidate = null;
                if (entry instanceof LibraryOrderEntry && LIB_LEVELS.contains(((LibraryOrderEntry)entry).getLibraryLevel())) {
                    Library dependency2 = ((LibraryOrderEntry)entry).getLibrary();
                    if (LibraryUtil.isJavaLibrary(dependency2)) {
                        candidate = dependency2;
                    }
                } else if (entry instanceof ModuleOrderEntry && LibraryUtil.isJavaModule(dependency = ((ModuleOrderEntry)entry).getModule())) {
                    candidate = dependency;
                    LibraryUtil.collectCandidates(dependency, filter, candidates, true, visited);
                }
                if (candidate != null && !filter.contains(candidate)) {
                    candidates.add(candidate);
                }
            }
            return true;
        });
    }

    private static boolean isJavaLibrary(@Nullable Library library) {
        return library != null && library.getUrls(OrderRootType.CLASSES).length > 0;
    }

    private static boolean isJavaModule(@Nullable Module module) {
        return module != null && ModuleType.get((Module)module) instanceof JavaModuleType;
    }

    @NotNull
    public static AjPathEntries.Entry create(@NotNull Library library) {
        AjPathEntries.AppLibraryEntry entry;
        String level;
        if (library == null) {
            LibraryUtil.$$$reportNull$$$0(7);
        }
        if ("application".equals(level = library.getTable().getTableLevel())) {
            entry = new AjPathEntries.AppLibraryEntry();
        } else if ("project".equals(level)) {
            entry = new AjPathEntries.ProjectLibraryEntry();
        } else {
            throw new IllegalArgumentException("Unknown level: " + level + " (" + library + ")");
        }
        entry.setName(library.getName());
        AjPathEntries.AppLibraryEntry appLibraryEntry = entry;
        if (appLibraryEntry == null) {
            LibraryUtil.$$$reportNull$$$0(8);
        }
        return appLibraryEntry;
    }

    @NotNull
    public static AjPathEntries.Entry create(@NotNull Module module) {
        if (module == null) {
            LibraryUtil.$$$reportNull$$$0(9);
        }
        AjPathEntries.ModuleEntry entry = new AjPathEntries.ModuleEntry();
        entry.setName(module.getName());
        AjPathEntries.ModuleEntry moduleEntry = entry;
        if (moduleEntry == null) {
            LibraryUtil.$$$reportNull$$$0(10);
        }
        return moduleEntry;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/aspectj/util/LibraryUtil";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existing";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/aspectj/util/LibraryUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "mapEntries";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAspectPathCandidates";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mapEntries";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAspectPathCandidates";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

