/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat;

import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.tomcat.TomcatServerXmlWrapper;
import org.jetbrains.idea.tomcat.server.TomcatPersistentData;

public class TomcatPersistentDataWrapper {
    private final TomcatPersistentData myTomcatData;

    public TomcatPersistentDataWrapper(@NotNull ApplicationServer applicationServer) {
        if (applicationServer == null) {
            TomcatPersistentDataWrapper.$$$reportNull$$$0(0);
        }
        this.myTomcatData = (TomcatPersistentData)applicationServer.getPersistentData();
    }

    public String getHomeDirectory() {
        return StringUtil.trimEnd((String)FileUtil.toSystemDependentName((String)this.myTomcatData.HOME), (String)File.separator);
    }

    public String getSourceBaseDirectoryPath() {
        String baseDir = this.myTomcatData.BASE;
        if (StringUtil.isNotEmpty((String)baseDir)) {
            return FileUtil.toSystemDependentName((String)baseDir);
        }
        return this.getHomeDirectory();
    }

    public int getSourceLocalPort() {
        return new TomcatServerXmlWrapper(this.getSourceBaseDirectoryPath()).getHttpPort();
    }

    public boolean hasSourceLocalPort() {
        return new TomcatServerXmlWrapper(this.getSourceBaseDirectoryPath()).hasSourceLocalPort();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationServer", "org/jetbrains/idea/tomcat/TomcatPersistentDataWrapper", "<init>"));
    }
}

