/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat;

import com.intellij.execution.ExecutionException;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.oss.descriptor.JavaeeDescriptor;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileMetaData;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.tomcat.TomcatBundle;
import org.jetbrains.idea.tomcat.TomcatContexts;
import org.jetbrains.idea.tomcat.TomcatDeploymentModelBase;
import org.jetbrains.idea.tomcat.model.TomcatContextRoot;
import org.jetbrains.idea.tomcat.server.TomcatIntegration;
import org.jetbrains.idea.tomcat.server.TomcatLocalModel;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class TomcatUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.tomcat.TomcatUtil");
    @NonNls
    private static final String CATALINA_NAME = "Catalina";
    @NonNls
    private static final String LOCALHOST_DIR = "localhost";
    @NonNls
    private static final String SERVLET_ELEMENT_NAME = "servlet";
    @NonNls
    private static final String KEEPGEN_PARAMETER_NAME = "keepgenerated";
    @NonNls
    private static final String MAPPEDFILE_PARAMETER_NAME = "mappedfile";
    @NonNls
    private static final String SCRDIR_PARAMETER_NAME = "scratchdir";
    @NonNls
    private static final String CLS_DI_PARAMETER_NAME = "classdebuginfo";
    @NonNls
    private static final String SERVLET_NAME_ELEM_NAME = "servlet-name";
    @NonNls
    private static final String JSP_VALUE = "jsp";
    @NonNls
    private static final String INIT_PARAM_ELEM_NAME = "init-param";
    @NonNls
    private static final String SERVLET_CLASS_ELEM_NAME = "servlet-class";
    @NonNls
    private static final String PARAM_NAME_ELEM_NAME = "param-name";
    @NonNls
    private static final String PARAM_VALUE_ELEM_NAME = "param-value";
    @NonNls
    private static final String TOMCAT_HOME_ENV_PROPERTY = "TOMCAT_HOME";
    @NonNls
    private static final String CATALINA_HOME_ENV_PROPERTY = "CATALINA_HOME";

    private TomcatUtil() {
    }

    public static File getSetEnvFile(String parentPath) {
        return new File(new File(parentPath, "bin"), "setenv." + (SystemInfo.isWindows ? "bat" : "sh"));
    }

    public static String getDefaultLocation() {
        String result = EnvironmentUtil.getValue((String)TOMCAT_HOME_ENV_PROPERTY);
        if (result == null) {
            result = EnvironmentUtil.getValue((String)CATALINA_HOME_ENV_PROPERTY);
        }
        return result != null ? result.replace(File.separatorChar, '/') : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Element findContextInContextXml(TomcatDeploymentModelBase tomcatModel) {
        String deploymentPath = tomcatModel.getDeploymentSource().getFilePath();
        if (deploymentPath == null) {
            return null;
        }
        File deploymentRoot = new File(deploymentPath);
        JavaeeDescriptor contextDescriptor = TomcatIntegration.getInstance().getDescriptorsManager().getItem(TomcatContextRoot.class);
        ConfigFileMetaData metaData = contextDescriptor.getMetaData();
        String contextXmlPath = metaData.getDirectoryPath() + "/" + metaData.getFileName();
        try {
            if (deploymentRoot.isDirectory()) {
                return TomcatUtil.loadXMLFile(new File(deploymentRoot, FileUtil.toSystemDependentName((String)contextXmlPath)));
            }
            if (!deploymentRoot.isFile()) return TomcatUtil.findContextInContextXmlByFacet(tomcatModel);
            try (JarFile jarFile = new JarFile(deploymentRoot);){
                ZipEntry entry = jarFile.getEntry(contextXmlPath);
                if (entry == null) return null;
                Element element = JdomKt.loadElement((InputStream)jarFile.getInputStream(entry));
                return element;
            }
        }
        catch (ExecutionException | IOException e) {
            LOG.info(e);
        }
        return null;
    }

    @Nullable
    public static Element findContextInContextXmlByFacet(TomcatDeploymentModelBase tomcatModel) {
        Artifact artifact = tomcatModel.getArtifact();
        if (artifact != null) {
            JavaeeDescriptor contextDescriptor = TomcatIntegration.getInstance().getDescriptorsManager().getItem(TomcatContextRoot.class);
            ConfigFileMetaData metaData = contextDescriptor.getMetaData();
            for (JavaeeFacet facet : JavaeeArtifactUtil.getInstance().getFacetsIncludedInArtifact(tomcatModel.getCommonModel().getProject(), artifact, WebFacet.ID)) {
                ConfigFile configFile = facet.getDescriptorsContainer().getConfigFile(metaData);
                try {
                    VirtualFile contextXmlFile;
                    if (configFile == null || (contextXmlFile = configFile.getVirtualFile()) == null) continue;
                    return TomcatUtil.loadXMLFile(VfsUtilCore.virtualToIoFile((VirtualFile)contextXmlFile));
                }
                catch (ExecutionException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
        return null;
    }

    public static String getContextName(String contextPath) {
        String contextName = StringUtil.isEmpty((String)contextPath) ? "ROOT" : contextPath.substring(1);
        return contextName.replace('/', '#').replace('\\', '#');
    }

    public static String getContextXML(String baseDirectoryPath, String contextPath) {
        return TomcatUtil.hostDir(baseDirectoryPath) + File.separator + TomcatUtil.getContextName(contextPath) + ".xml";
    }

    public static String hostDir(String baseDirectoryPath) {
        return TomcatUtil.baseConfigDir(baseDirectoryPath) + File.separator + CATALINA_NAME + File.separator + LOCALHOST_DIR;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Element loadXMLFile(final File xmlFile) throws ExecutionException {
        String path = xmlFile.getAbsolutePath();
        SAXBuilder builder = new SAXBuilder();
        builder.setEntityResolver((EntityResolver)new EntityResolver2(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (!StringUtil.isEmpty((String)systemId)) {
                    File externalEntity;
                    File file = externalEntity = FileUtil.isAbsolutePlatformIndependent((String)systemId) ? new File(systemId) : new File(FileUtil.getParentFile((File)xmlFile), systemId);
                    if (externalEntity.exists()) {
                        return new InputSource(new FileInputStream(externalEntity));
                    }
                }
                return new InputSource(new CharArrayReader(ArrayUtil.EMPTY_CHAR_ARRAY));
            }

            @Override
            public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
                return this.resolveEntity(publicId, systemId);
            }

            @Override
            public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
                return null;
            }
        });
        try (FileInputStream is = new FileInputStream(xmlFile);){
            String xmlText = CharsetToolkit.bytesToString((byte[])FileUtil.loadBytes((InputStream)is), (Charset)CharsetToolkit.UTF8_CHARSET);
            Element element = JDOMUtil.load((Reader)new StringReader(xmlText));
            return element;
        }
        catch (IOException | JDOMException e) {
            throw new ExecutionException(TomcatBundle.message("exception.text.cannot.load.file", path, e.getMessage()), e);
        }
    }

    @NonNls
    public static String getLogsDirPath(String baseDirectoryPath) {
        return baseDirectoryPath + File.separator + "logs";
    }

    private static String getBackupPath(String path) {
        int i = 0;
        while (new File(path + "." + i).exists()) {
            ++i;
        }
        return path + "." + i;
    }

    public static void saveXMLFile(Element xmlDocument, File xmlFile, boolean backupOriginalIfExists) throws ExecutionException {
        String xmlPath = xmlFile.getAbsolutePath();
        if (backupOriginalIfExists && xmlFile.exists()) {
            String backupPath = TomcatUtil.getBackupPath(xmlPath);
            try {
                FileUtil.copy((File)xmlFile, (File)new File(backupPath));
            }
            catch (IOException e) {
                throw new ExecutionException(TomcatBundle.message("exception.text.cannot.copy.0.to.1.because.of.2", xmlPath, backupPath, e.getMessage()));
            }
        }
        try {
            JDOMUtil.writeDocument((Document)new Document(xmlDocument.clone()), (String)xmlPath, (String)"\n");
        }
        catch (IOException e) {
            throw new ExecutionException(TomcatBundle.message("exception.text.cannot.write.0.because.of.1", xmlPath, e.getMessage()));
        }
    }

    public static void configureWebXml(TomcatLocalModel tomcatConfiguration) throws ExecutionException {
        Namespace namespace;
        File webXml = new File(tomcatConfiguration.getBaseDirectoryPath() + File.separator + "conf" + File.separator + "web.xml");
        Element rootElement = TomcatUtil.loadXMLFile(webXml);
        List servlets = rootElement.getChildren(SERVLET_ELEMENT_NAME, namespace = rootElement.getNamespace());
        Element jspServlet = TomcatUtil.findJspServlet(servlets, namespace);
        if (jspServlet == null) {
            String message = TomcatBundle.message("exception.text.cannot.find.configuration", webXml.getAbsolutePath());
            throw new ExecutionException(message);
        }
        if (!tomcatConfiguration.isVersion5OrHigher()) {
            TomcatUtil.setParameter(jspServlet, KEEPGEN_PARAMETER_NAME, Boolean.TRUE.toString(), namespace);
            TomcatUtil.setParameter(jspServlet, MAPPEDFILE_PARAMETER_NAME, Boolean.TRUE.toString(), namespace);
            String scratchdir = TomcatUtil.getGeneratedFilesPath(tomcatConfiguration).replace('/', File.separatorChar);
            new File(scratchdir).mkdirs();
            TomcatUtil.setParameter(jspServlet, SCRDIR_PARAMETER_NAME, scratchdir, namespace);
        }
        TomcatUtil.setParameter(jspServlet, CLS_DI_PARAMETER_NAME, Boolean.TRUE.toString(), namespace);
        TomcatUtil.saveXMLFile(rootElement, webXml, true);
    }

    @Nullable
    private static Element findJspServlet(List<Element> servlets, Namespace namespace) {
        Element jspServlet = null;
        for (Element servlet : servlets) {
            Element nameParam = servlet.getChild(SERVLET_NAME_ELEM_NAME, namespace);
            if (nameParam == null || !JSP_VALUE.equalsIgnoreCase(nameParam.getText())) continue;
            jspServlet = servlet;
            break;
        }
        return jspServlet;
    }

    private static void setParameter(Element servletNode, String parameterName, String parameterValue, Namespace namespace) {
        Element value;
        Element parameter = TomcatUtil.findParameter(servletNode, parameterName, namespace);
        if (parameter == null) {
            parameter = new Element(INIT_PARAM_ELEM_NAME, namespace);
            Element anchor = servletNode.getChild(SERVLET_CLASS_ELEM_NAME, namespace);
            TomcatUtil.insertChildAfter(servletNode, (Content)parameter, (Content)anchor);
            Element name = new Element(PARAM_NAME_ELEM_NAME, namespace);
            parameter.addContent(name);
            name.setText(parameterName);
        }
        if ((value = parameter.getChild(PARAM_VALUE_ELEM_NAME, namespace)) == null) {
            value = new Element(PARAM_VALUE_ELEM_NAME, namespace);
            parameter.addContent(value);
        }
        value.setText(parameterValue);
    }

    @Nullable
    private static Element findParameter(Element servletNode, String parameterName, Namespace namespace) {
        List parameters = servletNode.getChildren(INIT_PARAM_ELEM_NAME, namespace);
        for (Element param : parameters) {
            Element name = param.getChild(PARAM_NAME_ELEM_NAME, namespace);
            if (name == null || !parameterName.equalsIgnoreCase(name.getText())) continue;
            return param;
        }
        return null;
    }

    private static void insertChildAfter(Element parent, Content child, Content anchor) {
        List content = parent.getContent();
        ArrayList<Content> newContent = new ArrayList<Content>(content.size());
        for (Content contentElement : content) {
            newContent.add(contentElement.clone());
            if (!anchor.equals((Object)contentElement)) continue;
            newContent.add(child);
        }
        parent.setContent(newContent);
    }

    @Nullable
    public static Element findElementByAttr(Element parentElement, @NonNls String tagName, @NonNls String attrName, @NonNls String attrValue) {
        String path;
        if (tagName.equalsIgnoreCase(parentElement.getName()) && (path = parentElement.getAttributeValue(attrName)) != null && path.equalsIgnoreCase(attrValue)) {
            return parentElement;
        }
        List children = parentElement.getChildren();
        for (Element child : children) {
            Element elem = TomcatUtil.findElementByAttr(child, tagName, attrName, attrValue);
            if (elem == null) continue;
            return elem;
        }
        return null;
    }

    public static String getGeneratedFilesPath(TomcatLocalModel tomcatConfiguration) {
        String baseDirectoryPath = tomcatConfiguration.getBaseDirectoryPath();
        return FileUtil.toSystemIndependentName((String)baseDirectoryPath) + "/" + "work" + "/" + "_scratchdir";
    }

    public static String baseConfigDir(String baseDirectoryPath) {
        return baseDirectoryPath + File.separator + "conf";
    }

    @Nullable
    public static Element findContextElement(String baseDirectoryPath, TomcatDeploymentModelBase deploymentModel) throws ExecutionException {
        TomcatLocalModel serverModel = (TomcatLocalModel)deploymentModel.getServerModel();
        boolean isVersion5OrHigher = serverModel.isVersion5OrHigher();
        Element contextElement = null;
        if (isVersion5OrHigher) {
            contextElement = TomcatUtil.findContextInContextXml(deploymentModel);
        }
        if (contextElement == null) {
            String contextPath = deploymentModel.getContextPath();
            if (contextPath == null) {
                throw new ExecutionException(TomcatBundle.message("exception.text.context.path.not.configured", new Object[0]));
            }
            contextElement = new TomcatContexts(serverModel, baseDirectoryPath).findContextByPath(contextPath);
        }
        return contextElement;
    }
}

