/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat.server;

import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.deployment.JspDeploymentManager;
import com.intellij.javaee.oss.server.JavaeeConfigurationType;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.run.configuration.ServerModel;
import com.intellij.javaee.run.localRun.ExecutableObjectStartupPolicy;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.tomcat.TomcatPersistentDataWrapper;
import org.jetbrains.idea.tomcat.TomcatStartupPolicy;
import org.jetbrains.idea.tomcat.server.TomcatIntegration;
import org.jetbrains.idea.tomcat.server.TomcatLocalModel;
import org.jetbrains.idea.tomcat.server.TomcatRemoteModel;

public abstract class TomcatConfigurationBase
extends JavaeeConfigurationType {
    public TomcatConfigurationBase(TomcatIntegration integration) {
        super((JavaeeIntegration)integration);
    }

    @NotNull
    protected ServerModel createLocalModel() {
        TomcatLocalModel tomcatLocalModel = new TomcatLocalModel();
        if (tomcatLocalModel == null) {
            TomcatConfigurationBase.$$$reportNull$$$0(0);
        }
        return tomcatLocalModel;
    }

    @NotNull
    protected ServerModel createRemoteModel() {
        TomcatRemoteModel tomcatRemoteModel = new TomcatRemoteModel();
        if (tomcatRemoteModel == null) {
            TomcatConfigurationBase.$$$reportNull$$$0(1);
        }
        return tomcatRemoteModel;
    }

    @NotNull
    protected ExecutableObjectStartupPolicy createStartupPolicy() {
        TomcatStartupPolicy tomcatStartupPolicy = new TomcatStartupPolicy();
        if (tomcatStartupPolicy == null) {
            TomcatConfigurationBase.$$$reportNull$$$0(2);
        }
        return tomcatStartupPolicy;
    }

    public String getUrlToOpenInBrowser(@NotNull ApplicationServer server, @NotNull PsiFile psiFile) {
        WebFacet webFacet;
        if (server == null) {
            TomcatConfigurationBase.$$$reportNull$$$0(3);
        }
        if (psiFile == null) {
            TomcatConfigurationBase.$$$reportNull$$$0(4);
        }
        if ((webFacet = WebUtil.getWebFacet((PsiElement)psiFile)) == null) {
            return null;
        }
        int port = new TomcatPersistentDataWrapper(server).getSourceLocalPort();
        String root = "http://localhost:" + port;
        String relativePath = JspDeploymentManager.getInstance().computeRelativeTargetPath(psiFile, webFacet);
        if (relativePath == null) {
            return null;
        }
        return DeploymentUtil.concatPaths((String[])new String[]{root, relativePath});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/tomcat/server/TomcatConfigurationBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocalModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoteModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createStartupPolicy";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/tomcat/server/TomcatConfigurationBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUrlToOpenInBrowser";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

