/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.server;

import com.intellij.javaee.oss.descriptor.JavaeeResources;
import com.intellij.javaee.oss.util.FileWrapper;
import com.intellij.openapi.util.io.FileUtil;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class GlassfishResources
extends JavaeeResources {
    private static final Pattern DOCTYPE_PATTERN = Pattern.compile("<!DOCTYPE ([^>]*)>");
    private static final String QUOTE = "\"";
    private static final String NO_QUOTE = "[^\"]*";
    private static final Pattern DOCTYPE_CONTENT_PATTERN = Pattern.compile("[^\"]*\"[^\"]*\" \"([^\"]*)\"");

    @NotNull
    protected String getResourceUri(FileWrapper file) throws Exception {
        Matcher doctypeContentMatcher;
        String content = FileUtil.loadTextAndClose((Reader)new InputStreamReader(file.getStream()));
        Matcher doctypeMatcher = DOCTYPE_PATTERN.matcher(content);
        if (doctypeMatcher.find() && (doctypeContentMatcher = DOCTYPE_CONTENT_PATTERN.matcher(doctypeMatcher.group(1))).matches()) {
            String string = doctypeContentMatcher.group(1);
            if (string == null) {
                GlassfishResources.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = "http://www.sun.com/software/dtd/appserver/" + file.getName();
        if (string == null) {
            GlassfishResources.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/glassfish/server/GlassfishResources", "getResourceUri"));
    }
}

