/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.google.common.base.Splitter;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class AndroidApplicationInfo {
    public static final AndroidApplicationInfo UNKNOWN = new AndroidApplicationInfo("unknown", "unknown");
    @NotNull
    public final String packageId;
    @NotNull
    public final String versionName;

    private AndroidApplicationInfo(@NotNull String packageId, @NotNull String versionName) {
        if (packageId == null) {
            AndroidApplicationInfo.$$$reportNull$$$0(0);
        }
        if (versionName == null) {
            AndroidApplicationInfo.$$$reportNull$$$0(1);
        }
        this.packageId = packageId;
        this.versionName = versionName;
    }

    public static AndroidApplicationInfo fromXmlTree(@NotNull ProcessOutput xmlTree) {
        if (xmlTree == null) {
            AndroidApplicationInfo.$$$reportNull$$$0(2);
        }
        if (xmlTree.getExitCode() != 0) {
            return UNKNOWN;
        }
        return AndroidApplicationInfo.parse(xmlTree.getStdout());
    }

    @NotNull
    static AndroidApplicationInfo parse(@NotNull String output) {
        if (output == null) {
            AndroidApplicationInfo.$$$reportNull$$$0(3);
        }
        String packageId = null;
        String versionName = null;
        for (String line : Splitter.on((char)'\n').trimResults().split((CharSequence)output)) {
            int endQuote;
            int eqIndex;
            if (line.startsWith("A: android:versionName")) {
                eqIndex = line.indexOf("=");
                if (eqIndex > 0 && (endQuote = line.indexOf("\"", eqIndex + 2)) > 0) {
                    versionName = line.substring(eqIndex + 2, endQuote);
                }
            } else if (line.startsWith("A: package=") && (eqIndex = line.indexOf("=")) > 0 && (endQuote = line.indexOf("\"", eqIndex + 2)) > 0) {
                packageId = line.substring(eqIndex + 2, endQuote);
            }
            if (packageId == null || versionName == null) continue;
            break;
        }
        AndroidApplicationInfo androidApplicationInfo = new AndroidApplicationInfo(StringUtil.notNullize(packageId, (String)"unknown"), StringUtil.notNullize(versionName, (String)"?"));
        if (androidApplicationInfo == null) {
            AndroidApplicationInfo.$$$reportNull$$$0(4);
        }
        return androidApplicationInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlTree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/viewer/AndroidApplicationInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/viewer/AndroidApplicationInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromXmlTree";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

