/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.crash;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.HashMap;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CrashReport {
    public static final String PRODUCT_ANDROID_STUDIO = "AndroidStudio";
    private static final ImmutableSet<Class<? extends Throwable>> THROWABLE_CLASSES_TO_TRACK_MESSAGES = ImmutableSet.of(ArrayIndexOutOfBoundsException.class, ClassCastException.class, ClassNotFoundException.class, IndexOutOfBoundsException.class);
    @NotNull
    public final String productId;
    @Nullable
    public final String version;
    @Nullable
    public final Map<String, String> productData;
    @NotNull
    private final Type myType;

    private CrashReport(@NotNull String productId, @Nullable String version, @Nullable Map<String, String> productData, @NotNull Type type) {
        if (productId == null) {
            CrashReport.$$$reportNull$$$0(0);
        }
        if (type == null) {
            CrashReport.$$$reportNull$$$0(1);
        }
        this.productId = productId;
        this.version = version;
        this.productData = productData;
        this.myType = type;
    }

    public void serialize(@NotNull MultipartEntityBuilder builder) {
        if (builder == null) {
            CrashReport.$$$reportNull$$$0(2);
        }
        builder.addTextBody("type", this.myType.toString());
        if (this.productData != null) {
            this.productData.forEach((arg_0, arg_1) -> ((MultipartEntityBuilder)builder).addTextBody(arg_0, arg_1));
        }
        this.serializeTo(builder);
    }

    protected abstract void serializeTo(@NotNull MultipartEntityBuilder var1);

    @NotNull
    public static Throwable getRootCause(@NotNull Throwable t) {
        if (t == null) {
            CrashReport.$$$reportNull$$$0(3);
        }
        int depth = 0;
        while (depth++ < 20) {
            if (t.getCause() == null) {
                Throwable throwable = t;
                if (throwable == null) {
                    CrashReport.$$$reportNull$$$0(4);
                }
                return throwable;
            }
            t = t.getCause();
        }
        Throwable throwable = t;
        if (throwable == null) {
            CrashReport.$$$reportNull$$$0(5);
        }
        return throwable;
    }

    @NotNull
    public static String getDescription(@NotNull Throwable t) {
        if (t == null) {
            CrashReport.$$$reportNull$$$0(6);
        }
        if (THROWABLE_CLASSES_TO_TRACK_MESSAGES.contains(t.getClass())) {
            String string = ExceptionUtil.getThrowableText((Throwable)t);
            if (string == null) {
                CrashReport.$$$reportNull$$$0(7);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append(t.getClass().getName());
        sb.append(": <elided>\n");
        for (StackTraceElement el : t.getStackTrace()) {
            sb.append("\tat ");
            sb.append(el);
            sb.append('\n');
        }
        String string = sb.toString();
        if (string == null) {
            CrashReport.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "productId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/diagnostics/crash/CrashReport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/diagnostics/crash/CrashReport";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootCause";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRootCause";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        private String myProductId = "AndroidStudio";
        private String myVersion;
        private Type myType = Type.Exception;
        private String myExceptionInfo = "<unknown>";
        private List<String> myCrashDescriptions;
        private String myThreadDump;
        private String myFileName;
        private Map<String, String> myProductData;

        private Builder() {
        }

        @NotNull
        public Builder setProduct(@NotNull String productId) {
            if (productId == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myProductId = productId;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder setVersion(@NotNull String version) {
            if (version == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myVersion = version;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder addProductData(@NotNull Map<String, String> kv) {
            if (kv == null) {
                Builder.$$$reportNull$$$0(4);
            }
            if (this.myProductData == null) {
                this.myProductData = new HashMap();
            }
            this.myProductData.putAll(kv);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder;
        }

        @NotNull
        private Builder setType(@NotNull Type type) {
            if (type == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myType = type;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder;
        }

        @NotNull
        private Builder setThrowable(@NotNull Throwable t) {
            if (t == null) {
                Builder.$$$reportNull$$$0(8);
            }
            this.myExceptionInfo = CrashReport.getDescription(CrashReport.getRootCause(t));
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder;
        }

        @NotNull
        private Builder setDescriptions(@NotNull List<String> descriptions) {
            if (descriptions == null) {
                Builder.$$$reportNull$$$0(10);
            }
            this.myCrashDescriptions = descriptions;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(11);
            }
            return builder;
        }

        @NotNull
        private Builder setThreadDump(@NotNull String fileName, @NotNull String threadDump) {
            if (fileName == null) {
                Builder.$$$reportNull$$$0(12);
            }
            if (threadDump == null) {
                Builder.$$$reportNull$$$0(13);
            }
            this.myFileName = fileName;
            this.myThreadDump = threadDump;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(14);
            }
            return builder;
        }

        @NotNull
        public CrashReport build() {
            switch (this.myType) {
                case Crash: {
                    StudioCrashReport studioCrashReport = new StudioCrashReport(this.myProductId, this.myVersion, this.myCrashDescriptions, this.myProductData);
                    if (studioCrashReport == null) {
                        Builder.$$$reportNull$$$0(15);
                    }
                    return studioCrashReport;
                }
                case Performance: {
                    StudioPerformanceWatcherReport studioPerformanceWatcherReport = new StudioPerformanceWatcherReport(this.myProductId, this.myVersion, this.myFileName, this.myThreadDump, this.myProductData);
                    if (studioPerformanceWatcherReport == null) {
                        Builder.$$$reportNull$$$0(16);
                    }
                    return studioPerformanceWatcherReport;
                }
            }
            ExceptionReport exceptionReport = new ExceptionReport(this.myProductId, this.myVersion, this.myExceptionInfo, this.myProductData);
            if (exceptionReport == null) {
                Builder.$$$reportNull$$$0(17);
            }
            return exceptionReport;
        }

        @NotNull
        public static Builder createForException(@NotNull Throwable t) {
            if (t == null) {
                Builder.$$$reportNull$$$0(18);
            }
            Builder builder = new Builder().setType(Type.Exception).setThrowable(t);
            if (builder == null) {
                Builder.$$$reportNull$$$0(19);
            }
            return builder;
        }

        @NotNull
        public static Builder createForCrashes(@NotNull List<String> descriptions) {
            if (descriptions == null) {
                Builder.$$$reportNull$$$0(20);
            }
            Builder builder = new Builder().setType(Type.Crash).setDescriptions(descriptions);
            if (builder == null) {
                Builder.$$$reportNull$$$0(21);
            }
            return builder;
        }

        @NotNull
        public static Builder createForPerfReport(@NotNull String fileName, @NotNull String threadDump) {
            if (fileName == null) {
                Builder.$$$reportNull$$$0(22);
            }
            if (threadDump == null) {
                Builder.$$$reportNull$$$0(23);
            }
            Builder builder = new Builder().setType(Type.Performance).setThreadDump(fileName, threadDump);
            if (builder == null) {
                Builder.$$$reportNull$$$0(24);
            }
            return builder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 21: 
                case 24: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 21: 
                case 24: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "productId";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 21: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/diagnostics/crash/CrashReport$Builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kv";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 8: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "t";
                    break;
                }
                case 10: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptions";
                    break;
                }
                case 12: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
                case 13: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "threadDump";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/diagnostics/crash/CrashReport$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setProduct";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setVersion";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addProductData";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setType";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setThrowable";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setDescriptions";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setThreadDump";
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createForException";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createForCrashes";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createForPerfReport";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setProduct";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 21: 
                case 24: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setVersion";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addProductData";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setType";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setThrowable";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "setDescriptions";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "setThreadDump";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "createForException";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "createForCrashes";
                    break;
                }
                case 22: 
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "createForPerfReport";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 21: 
                case 24: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class StudioPerformanceWatcherReport
    extends CrashReport {
        private final String myFileName;
        private final String myThreadDump;

        private StudioPerformanceWatcherReport(@NotNull String productId, @Nullable String version, @NotNull String fileName, @NotNull String threadDump, @Nullable Map<String, String> productData) {
            if (productId == null) {
                StudioPerformanceWatcherReport.$$$reportNull$$$0(0);
            }
            if (fileName == null) {
                StudioPerformanceWatcherReport.$$$reportNull$$$0(1);
            }
            if (threadDump == null) {
                StudioPerformanceWatcherReport.$$$reportNull$$$0(2);
            }
            super(productId, version, productData, Type.Performance);
            this.myFileName = fileName;
            this.myThreadDump = threadDump;
        }

        @Override
        protected void serializeTo(@NotNull MultipartEntityBuilder builder) {
            if (builder == null) {
                StudioPerformanceWatcherReport.$$$reportNull$$$0(3);
            }
            builder.addTextBody(this.myFileName, this.myThreadDump, ContentType.create((String)"text/plain", (Charset)Charsets.UTF_8));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "productId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "threadDump";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/diagnostics/crash/CrashReport$StudioPerformanceWatcherReport";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "serializeTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StudioCrashReport
    extends CrashReport {
        private final List<String> myDescriptions;

        private StudioCrashReport(@NotNull String productId, @Nullable String version, @NotNull List<String> descriptions, @Nullable Map<String, String> productData) {
            if (productId == null) {
                StudioCrashReport.$$$reportNull$$$0(0);
            }
            if (descriptions == null) {
                StudioCrashReport.$$$reportNull$$$0(1);
            }
            super(productId, version, productData, Type.Crash);
            this.myDescriptions = descriptions;
        }

        @Override
        protected void serializeTo(@NotNull MultipartEntityBuilder builder) {
            if (builder == null) {
                StudioCrashReport.$$$reportNull$$$0(2);
            }
            builder.addTextBody("numCrashes", Integer.toString(this.myDescriptions.size()));
            builder.addTextBody("crashDesc", Joiner.on((String)"\n\n").join(this.myDescriptions));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "productId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/diagnostics/crash/CrashReport$StudioCrashReport";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "serializeTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ExceptionReport
    extends CrashReport {
        @NotNull
        private final String myExceptionInfo;

        private ExceptionReport(@NotNull String productId, @Nullable String version, @NotNull String exceptionInfo, @Nullable Map<String, String> productData) {
            if (productId == null) {
                ExceptionReport.$$$reportNull$$$0(0);
            }
            if (exceptionInfo == null) {
                ExceptionReport.$$$reportNull$$$0(1);
            }
            super(productId, version, productData, Type.Exception);
            this.myExceptionInfo = exceptionInfo;
        }

        @Override
        protected void serializeTo(@NotNull MultipartEntityBuilder builder) {
            if (builder == null) {
                ExceptionReport.$$$reportNull$$$0(2);
            }
            builder.addTextBody("exception_info", this.myExceptionInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "productId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptionInfo";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/diagnostics/crash/CrashReport$ExceptionReport";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "serializeTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum Type {
        Crash,
        Exception,
        Performance;

    }
}

