/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.ui;

import com.android.tools.idea.editors.theme.ThemeEditorConstants;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.ui.VariantsComboBox;
import com.android.tools.swing.ui.SwatchComponent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceComponent
extends JPanel {
    public static final String NAME_LABEL = "Name Label";
    private final SwatchComponent mySwatchComponent;
    private final JLabel myNameLabel;
    protected final JLabel myWarningLabel;
    private final VariantsComboBox myVariantCombo;

    public ResourceComponent(@NotNull Project project, boolean isEditor) {
        if (project == null) {
            ResourceComponent.$$$reportNull$$$0(0);
        }
        super(new BorderLayout(0, ThemeEditorConstants.ATTRIBUTE_ROW_GAP));
        this.myNameLabel = new JLabel();
        this.myWarningLabel = new JLabel();
        this.myVariantCombo = new VariantsComboBox();
        this.setBorder(BorderFactory.createEmptyBorder(ThemeEditorConstants.ATTRIBUTE_MARGIN / 2, 0, ThemeEditorConstants.ATTRIBUTE_MARGIN / 2, 0));
        this.myWarningLabel.setIcon(AllIcons.General.BalloonWarning);
        this.myWarningLabel.setVisible(false);
        this.myNameLabel.setName(NAME_LABEL);
        this.myNameLabel.setForeground((Color)ThemeEditorConstants.RESOURCE_ITEM_COLOR);
        Box topRowPanel = new Box(2);
        topRowPanel.add(this.myNameLabel);
        topRowPanel.add(this.myWarningLabel);
        this.myVariantCombo.setVisible(false);
        topRowPanel.add(Box.createHorizontalGlue());
        topRowPanel.add(this.myVariantCombo);
        this.add((Component)topRowPanel, "Center");
        this.mySwatchComponent = new SwatchComponent(project, isEditor);
        this.add((Component)this.mySwatchComponent, "South");
        ThemeEditorUtils.setInheritsPopupMenuRecursive(this);
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            int firstRowHeight = Math.max(this.getFontMetrics(this.getFont()).getHeight(), this.myVariantCombo.getPreferredSize().height);
            int secondRowHeight = this.mySwatchComponent.getPreferredSize().height;
            return new Dimension(0, ThemeEditorConstants.ATTRIBUTE_MARGIN + ThemeEditorConstants.ATTRIBUTE_ROW_GAP + firstRowHeight + secondRowHeight);
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.isMaximumSizeSet()) {
            return super.getMaximumSize();
        }
        return new Dimension(super.getMaximumSize().width, this.getPreferredSize().height);
    }

    public void setSwatchIcon(@NotNull SwatchComponent.SwatchIcon icon) {
        if (icon == null) {
            ResourceComponent.$$$reportNull$$$0(1);
        }
        this.mySwatchComponent.setSwatchIcon(icon);
    }

    public void setNameText(@NotNull String name) {
        if (name == null) {
            ResourceComponent.$$$reportNull$$$0(2);
        }
        this.myNameLabel.setText(name);
    }

    public void setWarning(@Nullable String warning) {
        if (!StringUtil.isEmpty((String)warning)) {
            this.myWarningLabel.setToolTipText(warning);
            this.myWarningLabel.setVisible(true);
        } else {
            this.myWarningLabel.setVisible(false);
        }
    }

    public void setVariantsModel(@NotNull ComboBoxModel comboBoxModel) {
        if (comboBoxModel == null) {
            ResourceComponent.$$$reportNull$$$0(3);
        }
        this.myVariantCombo.setModel(comboBoxModel);
        this.myVariantCombo.setVisible(comboBoxModel.getSize() > 0);
    }

    public void addVariantItemListener(@NotNull ItemListener itemListener) {
        if (itemListener == null) {
            ResourceComponent.$$$reportNull$$$0(4);
        }
        this.myVariantCombo.addItemListener(itemListener);
    }

    public void addVariantPopupClosingListener(@NotNull VariantsComboBox.PopupClosingListener listener) {
        if (listener == null) {
            ResourceComponent.$$$reportNull$$$0(5);
        }
        this.myVariantCombo.addPopupClosingListener(listener);
    }

    public void setValueText(@NotNull String value) {
        if (value == null) {
            ResourceComponent.$$$reportNull$$$0(6);
        }
        this.mySwatchComponent.setText(value);
    }

    @NotNull
    public String getValueText() {
        String string = this.mySwatchComponent.getText();
        if (string == null) {
            ResourceComponent.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.mySwatchComponent != null) {
            this.mySwatchComponent.setFont(font);
        }
        if (this.myNameLabel != null) {
            this.myNameLabel.setFont(font);
        }
    }

    public void addSwatchListener(@NotNull ActionListener listener) {
        if (listener == null) {
            ResourceComponent.$$$reportNull$$$0(8);
        }
        this.mySwatchComponent.addSwatchListener(listener);
    }

    public void addTextListener(@NotNull ActionListener listener) {
        if (listener == null) {
            ResourceComponent.$$$reportNull$$$0(9);
        }
        this.mySwatchComponent.addTextListener(listener);
    }

    public void addTextDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            ResourceComponent.$$$reportNull$$$0(10);
        }
        this.mySwatchComponent.addTextDocumentListener(listener);
    }

    public void addTextFocusListener(@NotNull FocusListener listener) {
        if (listener == null) {
            ResourceComponent.$$$reportNull$$$0(11);
        }
        this.mySwatchComponent.addTextFocusListener(listener);
    }

    public void setCompletionStrings(@NotNull List<String> completions) {
        if (completions == null) {
            ResourceComponent.$$$reportNull$$$0(12);
        }
        this.mySwatchComponent.setCompletionStrings(completions);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.myWarningLabel.isVisible()) {
            this.validate();
            if (SwingUtilities.getLocalBounds(this.myWarningLabel).contains(SwingUtilities.convertMouseEvent(this, event, this.myWarningLabel).getPoint())) {
                return this.myWarningLabel.getToolTipText();
            }
        }
        return super.getToolTipText(event);
    }

    public Dimension getSwatchIconSize() {
        return new Dimension(this.mySwatchComponent.getHeight(), this.mySwatchComponent.getHeight());
    }

    @Nullable
    public ValidationInfo doValidate(int minApi, @NotNull AndroidTargetData androidTargetData) {
        if (androidTargetData == null) {
            ResourceComponent.$$$reportNull$$$0(13);
        }
        return this.mySwatchComponent.doValidate(minApi, androidTargetData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBoxModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemListener";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/ui/ResourceComponent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completions";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidTargetData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/ui/ResourceComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSwatchIcon";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setNameText";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setVariantsModel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addVariantItemListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addVariantPopupClosingListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setValueText";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addSwatchListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addTextListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addTextDocumentListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addTextFocusListener";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setCompletionStrings";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doValidate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

