/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.google.common.base.Splitter;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GenericErrorHandler
extends SyncErrorHandler {
    @Override
    public boolean handleError(@NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        List<NotificationHyperlink> hyperlinks;
        String text;
        if (error == null) {
            GenericErrorHandler.$$$reportNull$$$0(0);
        }
        if (notification == null) {
            GenericErrorHandler.$$$reportNull$$$0(1);
        }
        if (project == null) {
            GenericErrorHandler.$$$reportNull$$$0(2);
        }
        if ((text = this.getRootCause((Throwable)error).getMessage()) != null && !(hyperlinks = this.getQuickFixHyperlinks(notification, text)).isEmpty()) {
            GenericErrorHandler.updateUsageTracker();
            SyncMessages.getInstance(project).updateNotification(notification, text, hyperlinks);
            return true;
        }
        return false;
    }

    @NotNull
    private List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull NotificationData notification, @NotNull String text) {
        Pair<String, Integer> errorLocation;
        if (notification == null) {
            GenericErrorHandler.$$$reportNull$$$0(3);
        }
        if (text == null) {
            GenericErrorHandler.$$$reportNull$$$0(4);
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        List message = Splitter.on((char)'\n').omitEmptyStrings().trimResults().splitToList((CharSequence)text);
        String lastLine = (String)message.get(message.size() - 1);
        if (lastLine != null && (errorLocation = this.getErrorLocation(lastLine)) != null) {
            String filePath = (String)errorLocation.getFirst();
            int line = (Integer)errorLocation.getSecond();
            hyperlinks.add(new OpenFileHyperlink(filePath, line - 1));
            ArrayList<NotificationHyperlink> arrayList = hyperlinks;
            if (arrayList == null) {
                GenericErrorHandler.$$$reportNull$$$0(5);
            }
            return arrayList;
        }
        String filePath = notification.getFilePath();
        if (StringUtil.isNotEmpty((String)filePath)) {
            int lineIndex = notification.getLine() - 1;
            int column = notification.getColumn();
            hyperlinks.add(new OpenFileHyperlink(filePath, "Open File", lineIndex, column));
        }
        ArrayList<NotificationHyperlink> arrayList = hyperlinks;
        if (arrayList == null) {
            GenericErrorHandler.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/errors/GenericErrorHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/errors/GenericErrorHandler";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixHyperlinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleError";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixHyperlinks";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

