/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.sdk;

import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.base.Strings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class GradleAndroidSdkEventListener
implements IdeSdks.AndroidSdkEventListener {
    private static Logger LOG = Logger.getInstance(GradleAndroidSdkEventListener.class);

    @Override
    public void afterSdkPathChange(@NotNull File sdkPath, @NotNull Project project) {
        LocalProperties localProperties;
        if (sdkPath == null) {
            GradleAndroidSdkEventListener.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GradleAndroidSdkEventListener.$$$reportNull$$$0(1);
        }
        if (!Projects.isBuildWithGradle(project)) {
            return;
        }
        try {
            localProperties = new LocalProperties(project);
        }
        catch (IOException e) {
            GradleAndroidSdkEventListener.logAndShowErrorWhenUpdatingLocalProperties(project, e, "read", sdkPath);
            return;
        }
        if (!FileUtil.filesEqual((File)sdkPath, (File)localProperties.getAndroidSdkPath())) {
            try {
                localProperties.setAndroidSdkPath(sdkPath);
                localProperties.save();
            }
            catch (IOException e) {
                GradleAndroidSdkEventListener.logAndShowErrorWhenUpdatingLocalProperties(project, e, "update", sdkPath);
                return;
            }
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, null);
        }
    }

    private static void logAndShowErrorWhenUpdatingLocalProperties(@NotNull Project project, @NotNull Exception error, @NotNull String action, @NotNull File sdkHomePath) {
        if (project == null) {
            GradleAndroidSdkEventListener.$$$reportNull$$$0(2);
        }
        if (error == null) {
            GradleAndroidSdkEventListener.$$$reportNull$$$0(3);
        }
        if (action == null) {
            GradleAndroidSdkEventListener.$$$reportNull$$$0(4);
        }
        if (sdkHomePath == null) {
            GradleAndroidSdkEventListener.$$$reportNull$$$0(5);
        }
        LOG.info((Throwable)error);
        String msg = String.format("Unable to %1$s local.properties file in project '%2$s'.\n\nCause: %3$s\n\nPlease manually update the file's '%4$s' property value to \n'%5$s'\nand sync the project with Gradle files.", action, project.getName(), GradleAndroidSdkEventListener.getMessage(error), "sdk.dir", sdkHomePath.getPath());
        Messages.showErrorDialog((Project)project, (String)msg, (String)"Project SDK Update");
    }

    @NotNull
    private static String getMessage(@NotNull Exception e) {
        String cause;
        if (e == null) {
            GradleAndroidSdkEventListener.$$$reportNull$$$0(6);
        }
        String string = Strings.isNullOrEmpty((String)(cause = e.getMessage())) ? "[Unknown]" : cause;
        if (string == null) {
            GradleAndroidSdkEventListener.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHomePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/sdk/GradleAndroidSdkEventListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/sdk/GradleAndroidSdkEventListener";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "afterSdkPathChange";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "logAndShowErrorWhenUpdatingLocalProperties";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

