/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.ui.ModulesComboBoxAction;
import com.android.tools.idea.gradle.structure.configurables.ui.PsUISettings;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMainPanel
extends JPanel
implements Disposable,
Place.Navigator {
    @NotNull
    private final PsProject myProject;
    @NotNull
    private final PsContext myContext;
    private boolean myShowModulesDropDown;
    private JComponent myModulesToolbar;
    private History myHistory;

    protected AbstractMainPanel(@NotNull PsContext context) {
        if (context == null) {
            AbstractMainPanel.$$$reportNull$$$0(0);
        }
        this(context, Collections.emptyList());
    }

    protected AbstractMainPanel(@NotNull PsContext context, @NotNull List<PsModule> extraTopModules) {
        if (context == null) {
            AbstractMainPanel.$$$reportNull$$$0(1);
        }
        if (extraTopModules == null) {
            AbstractMainPanel.$$$reportNull$$$0(2);
        }
        super(new BorderLayout());
        this.myProject = context.getProject();
        this.myContext = context;
        this.myShowModulesDropDown = PsUISettings.getInstance().MODULES_LIST_MINIMIZE;
        if (this.myShowModulesDropDown) {
            this.createAndAddModulesAction(extraTopModules);
        }
        PsUISettings.getInstance().addListener(settings -> {
            if (extraTopModules == null) {
                AbstractMainPanel.$$$reportNull$$$0(6);
            }
            if (settings.MODULES_LIST_MINIMIZE != this.myShowModulesDropDown) {
                this.myShowModulesDropDown = settings.MODULES_LIST_MINIMIZE;
                if (this.myShowModulesDropDown) {
                    this.createAndAddModulesAction(extraTopModules);
                } else {
                    this.removeModulesAction();
                }
            }
        }, this);
    }

    private void createAndAddModulesAction(@NotNull List<PsModule> extraTopModules) {
        if (extraTopModules == null) {
            AbstractMainPanel.$$$reportNull$$$0(3);
        }
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)new ModulesComboBoxAction(this.myContext, extraTopModules));
        DumbAwareAction restoreModuleListAction = new DumbAwareAction("Restore 'Modules' List", "", AllIcons.Actions.MoveTo2){

            public void actionPerformed(AnActionEvent e) {
                PsUISettings settings = PsUISettings.getInstance();
                settings.MODULES_LIST_MINIMIZE = AbstractMainPanel.this.myShowModulesDropDown = false;
                settings.fireUISettingsChanged();
                AbstractMainPanel.this.removeModulesAction();
            }
        };
        actions.add((AnAction)restoreModuleListAction);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("TOP", (ActionGroup)actions, true);
        this.myModulesToolbar = toolbar.getComponent();
        this.myModulesToolbar.setBorder(IdeBorderFactory.createBorder((int)8));
        this.add((Component)this.myModulesToolbar, "North");
    }

    private void removeModulesAction() {
        if (this.myModulesToolbar != null) {
            this.remove(this.myModulesToolbar);
            this.myModulesToolbar = null;
            UiUtil.revalidateAndRepaint(this);
        }
    }

    @NotNull
    protected PsProject getProject() {
        PsProject psProject = this.myProject;
        if (psProject == null) {
            AbstractMainPanel.$$$reportNull$$$0(4);
        }
        return psProject;
    }

    @NotNull
    protected PsContext getContext() {
        PsContext psContext = this.myContext;
        if (psContext == null) {
            AbstractMainPanel.$$$reportNull$$$0(5);
        }
        return psContext;
    }

    public void setHistory(History history) {
        this.myHistory = history;
    }

    @Nullable
    protected History getHistory() {
        return this.myHistory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraTopModules";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/ui/AbstractMainPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/ui/AbstractMainPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAndAddModulesAction";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

