/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.tools.idea.gradle.util.ui.Header;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.ChildFocusWatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolWindowHeader
extends Header
implements Disposable {
    @NotNull
    private final Icon myIcon;
    @Nullable
    private final ToolWindowAnchor myAnchor;
    private JComponent myPreferredFocusedComponent;
    private AnAction myMinimizeAction;
    private ChildFocusWatcher myFocusWatcher;
    private final EventDispatcher<MinimizeListener> myEventDispatcher;

    @NotNull
    public static ToolWindowHeader createAndAdd(@NotNull String title, @NotNull Icon icon, final @NotNull JComponent parent, @Nullable ToolWindowAnchor anchor) {
        if (title == null) {
            ToolWindowHeader.$$$reportNull$$$0(0);
        }
        if (icon == null) {
            ToolWindowHeader.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            ToolWindowHeader.$$$reportNull$$$0(2);
        }
        LayoutManager layout = parent.getLayout();
        assert (layout instanceof BorderLayout);
        final ToolWindowHeader header = new ToolWindowHeader(title, icon, anchor){

            @Override
            public boolean isActive() {
                KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                Component focusOwner = focusManager.getFocusOwner();
                return focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, parent);
            }
        };
        parent.add((Component)header, "North");
        MyFocusWatcher focusWatcher = new MyFocusWatcher(parent){

            @Override
            void onFocusChange(FocusEvent event) {
                header.repaint();
            }
        };
        super.setFocusWatcher(focusWatcher);
        ToolWindowHeader toolWindowHeader = header;
        if (toolWindowHeader == null) {
            ToolWindowHeader.$$$reportNull$$$0(3);
        }
        return toolWindowHeader;
    }

    private ToolWindowHeader(@NotNull String title, @NotNull Icon icon, @Nullable ToolWindowAnchor anchor) {
        if (title == null) {
            ToolWindowHeader.$$$reportNull$$$0(4);
        }
        if (icon == null) {
            ToolWindowHeader.$$$reportNull$$$0(5);
        }
        super(title);
        this.myEventDispatcher = EventDispatcher.create(MinimizeListener.class);
        this.myIcon = icon;
        this.myAnchor = anchor;
        if (this.myAnchor != null) {
            Icon minimizeIcon = this.myAnchor == ToolWindowAnchor.LEFT ? AllIcons.General.HideLeft : AllIcons.General.HideRight;
            this.myMinimizeAction = new DumbAwareAction("Hide", "", minimizeIcon){

                public void actionPerformed(AnActionEvent e) {
                    ((MinimizeListener)ToolWindowHeader.this.myEventDispatcher.getMulticaster()).minimized();
                }
            };
            this.setAdditionalActions(Lists.newArrayList((Object[])new AnAction[]{this.myMinimizeAction}));
        }
        this.addActivationListener(() -> {
            if (this.myPreferredFocusedComponent != null) {
                this.myPreferredFocusedComponent.requestFocusInWindow();
            }
        }, this);
    }

    @Override
    public void setAdditionalActions(@NotNull List<AnAction> actions) {
        if (actions == null) {
            ToolWindowHeader.$$$reportNull$$$0(6);
        }
        ArrayList allActions = actions;
        if (this.myMinimizeAction != null && !actions.contains(this.myMinimizeAction)) {
            allActions = Lists.newArrayList(actions);
            allActions.add(this.myMinimizeAction);
        }
        super.setAdditionalActions(allActions);
    }

    private void setFocusWatcher(@NotNull ChildFocusWatcher focusWatcher) {
        if (focusWatcher == null) {
            ToolWindowHeader.$$$reportNull$$$0(7);
        }
        this.myFocusWatcher = focusWatcher;
    }

    public void setPreferredFocusedComponent(@Nullable JComponent preferredFocusedComponent) {
        this.myPreferredFocusedComponent = preferredFocusedComponent;
    }

    public void dispose() {
        if (this.myFocusWatcher != null) {
            Disposer.dispose((Disposable)this.myFocusWatcher);
        }
    }

    @NotNull
    Icon getIcon() {
        Icon icon = this.myIcon;
        if (icon == null) {
            ToolWindowHeader.$$$reportNull$$$0(8);
        }
        return icon;
    }

    @Nullable
    public ToolWindowAnchor getAnchor() {
        return this.myAnchor;
    }

    public void addMinimizeListener(@NotNull MinimizeListener listener) {
        if (listener == null) {
            ToolWindowHeader.$$$reportNull$$$0(9);
        }
        this.myEventDispatcher.addListener((EventListener)listener, (Disposable)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowHeader";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusWatcher";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowHeader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAdd";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAndAdd";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalActions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setFocusWatcher";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addMinimizeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface MinimizeListener
    extends EventListener {
        public void minimized();
    }

    private static abstract class MyFocusWatcher
    extends ChildFocusWatcher {
        MyFocusWatcher(@NotNull JComponent parent) {
            if (parent == null) {
                MyFocusWatcher.$$$reportNull$$$0(0);
            }
            super(parent);
        }

        protected void onFocusGained(FocusEvent event) {
            this.onFocusChange(event);
        }

        protected void onFocusLost(FocusEvent event) {
            this.onFocusChange(event);
        }

        abstract void onFocusChange(FocusEvent var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowHeader$MyFocusWatcher", "<init>"));
        }
    }
}

