/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.daemon.AvailableLibraryUpdateStorage;
import com.android.tools.idea.gradle.structure.daemon.PsDaemon;
import com.android.tools.idea.gradle.structure.daemon.PsLibraryUpdateCheckerDaemon;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsAndroidModuleAnalyzer;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsJavaModuleAnalyzer;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsModelAnalyzer;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueCollection;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.android.tools.idea.gradle.structure.model.PsModulePath;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.java.PsJavaModule;
import com.android.tools.idea.gradle.structure.navigation.PsLibraryDependencyNavigationPath;
import com.android.tools.idea.gradle.structure.quickfix.PsLibraryDependencyVersionQuickFixPath;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Ref;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.EventListener;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class PsAnalyzerDaemon
extends PsDaemon {
    private static final Logger LOG = Logger.getInstance(PsAnalyzerDaemon.class);
    @NotNull
    private final MergingUpdateQueue myMainQueue;
    @NotNull
    private final MergingUpdateQueue myResultsUpdaterQueue;
    @NotNull
    private final PsIssueCollection myIssues;
    @NotNull
    private final Map<Class<?>, PsModelAnalyzer<?>> myModelAnalyzers;
    @NotNull
    private final AtomicBoolean myRunning;
    @NotNull
    private final EventDispatcher<IssuesUpdatedListener> myIssuesUpdatedEventDispatcher;

    public PsAnalyzerDaemon(@NotNull PsContext context, @NotNull PsLibraryUpdateCheckerDaemon libraryUpdateCheckerDaemon) {
        if (context == null) {
            PsAnalyzerDaemon.$$$reportNull$$$0(0);
        }
        if (libraryUpdateCheckerDaemon == null) {
            PsAnalyzerDaemon.$$$reportNull$$$0(1);
        }
        super(context);
        this.myModelAnalyzers = Maps.newHashMap();
        this.myRunning = new AtomicBoolean(true);
        this.myIssuesUpdatedEventDispatcher = EventDispatcher.create(IssuesUpdatedListener.class);
        this.myMainQueue = this.createQueue("Project Structure Daemon Analyzer", null);
        this.myResultsUpdaterQueue = this.createQueue("Project Structure Analysis Results Updater", MergingUpdateQueue.ANY_COMPONENT);
        this.myIssues = new PsIssueCollection(this.getContext());
        libraryUpdateCheckerDaemon.add(this::addApplicableUpdatesAsIssues, this);
        this.createModelAnalyzers();
    }

    public void recreateUpdateIssues() {
        this.removeIssues(PsIssueType.LIBRARY_UPDATES_AVAILABLE);
        this.addApplicableUpdatesAsIssues();
    }

    private void addApplicableUpdatesAsIssues() {
        PsContext context = this.getContext();
        context.getProject().forEachModule(module -> {
            Ref updatesFound = new Ref((Object)false);
            if (module instanceof PsAndroidModule) {
                PsAndroidModule androidModule = (PsAndroidModule)module;
                androidModule.forEachDeclaredDependency(dependency -> {
                    boolean found;
                    if (dependency instanceof PsLibraryDependency && (found = this.checkForUpdates((PsLibraryDependency)((Object)dependency)))) {
                        updatesFound.set((Object)true);
                    }
                });
            } else if (module instanceof PsJavaModule) {
                PsJavaModule javaModule = (PsJavaModule)module;
                javaModule.forEachDeclaredDependency(dependency -> {
                    boolean found;
                    if (dependency instanceof PsLibraryDependency && (found = this.checkForUpdates((PsLibraryDependency)((Object)dependency)))) {
                        updatesFound.set((Object)true);
                    }
                });
            }
            if (((Boolean)updatesFound.get()).booleanValue()) {
                this.myResultsUpdaterQueue.queue((Update)new IssuesComputed((PsModel)module));
            }
        });
    }

    private boolean checkForUpdates(@NotNull PsLibraryDependency dependency) {
        AvailableLibraryUpdateStorage.AvailableLibraryUpdate update;
        if (dependency == null) {
            PsAnalyzerDaemon.$$$reportNull$$$0(2);
        }
        PsContext context = this.getContext();
        AvailableLibraryUpdateStorage.AvailableLibraryUpdates results = context.getLibraryUpdateCheckerDaemon().getAvailableUpdates();
        PsArtifactDependencySpec spec = dependency.getDeclaredSpec();
        if (spec != null && (update = results.findUpdateFor(spec)) != null) {
            String text = String.format("Newer version available: <b>%1$s</b> (%2$s)", update.version, update.repository);
            PsLibraryDependencyNavigationPath mainPath = new PsLibraryDependencyNavigationPath(context, dependency);
            PsIssue issue = new PsIssue(text, mainPath, PsIssueType.LIBRARY_UPDATES_AVAILABLE, PsIssue.Severity.UPDATE);
            issue.setExtraPath(new PsModulePath(dependency.getParent()));
            PsLibraryDependencyVersionQuickFixPath quickFix = new PsLibraryDependencyVersionQuickFixPath(dependency, update.version);
            quickFix.setHrefText("[Update]");
            issue.setQuickFixPath(quickFix);
            this.myIssues.add(issue);
            return true;
        }
        return false;
    }

    private void createModelAnalyzers() {
        this.add(new PsAndroidModuleAnalyzer(this.getContext()));
        this.add(new PsJavaModuleAnalyzer(this.getContext()));
    }

    private void add(@NotNull PsModelAnalyzer<? extends PsModel> analyzer) {
        if (analyzer == null) {
            PsAnalyzerDaemon.$$$reportNull$$$0(3);
        }
        this.myModelAnalyzers.put(analyzer.getSupportedModelType(), analyzer);
    }

    public void add(@NotNull IssuesUpdatedListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            PsAnalyzerDaemon.$$$reportNull$$$0(4);
        }
        if (parentDisposable == null) {
            PsAnalyzerDaemon.$$$reportNull$$$0(5);
        }
        this.myIssuesUpdatedEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    @Override
    public boolean isRunning() {
        return this.myRunning.get();
    }

    public void queueCheck(@NotNull PsModel model) {
        if (model == null) {
            PsAnalyzerDaemon.$$$reportNull$$$0(6);
        }
        this.myMainQueue.queue((Update)new AnalyzeStructure(model));
    }

    private void doCheck(final @NotNull PsModel model) {
        if (model == null) {
            PsAnalyzerDaemon.$$$reportNull$$$0(7);
        }
        this.myRunning.set(true);
        final PsModelAnalyzer<?> analyzer = this.myModelAnalyzers.get(model.getClass());
        if (analyzer == null) {
            LOG.info("Failed to find analyzer for model of type " + model.getClass().getName());
            return;
        }
        RunResult result = new ReadAction<ActionCallback>(){

            protected void run(@NotNull Result<ActionCallback> result) throws Throwable {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PsAnalyzerDaemon.this.isStopped()) {
                    return;
                }
                analyzer.analyze(model, PsAnalyzerDaemon.this.myIssues);
                result.setResult((Object)ActionCallback.DONE);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon$1", "run"));
            }
        }.execute();
        ((ActionCallback)result.getResultObject()).doWhenDone(() -> {
            if (model == null) {
                PsAnalyzerDaemon.$$$reportNull$$$0(12);
            }
            this.myResultsUpdaterQueue.queue((Update)new IssuesComputed(model));
        });
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getMainQueue() {
        MergingUpdateQueue mergingUpdateQueue = this.myMainQueue;
        if (mergingUpdateQueue == null) {
            PsAnalyzerDaemon.$$$reportNull$$$0(8);
        }
        return mergingUpdateQueue;
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getResultsUpdaterQueue() {
        MergingUpdateQueue mergingUpdateQueue = this.myResultsUpdaterQueue;
        if (mergingUpdateQueue == null) {
            PsAnalyzerDaemon.$$$reportNull$$$0(9);
        }
        return mergingUpdateQueue;
    }

    @NotNull
    public PsIssueCollection getIssues() {
        PsIssueCollection psIssueCollection = this.myIssues;
        if (psIssueCollection == null) {
            PsAnalyzerDaemon.$$$reportNull$$$0(10);
        }
        return psIssueCollection;
    }

    public void removeIssues(@NotNull PsIssueType type) {
        if (type == null) {
            PsAnalyzerDaemon.$$$reportNull$$$0(11);
        }
        this.myIssues.remove(type);
        this.myResultsUpdaterQueue.queue((Update)new IssuesComputed(this.getContext().getProject()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryUpdateCheckerDaemon";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analyzer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainQueue";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultsUpdaterQueue";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkForUpdates";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "queueCheck";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doCheck";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeIssues";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doCheck$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface IssuesUpdatedListener
    extends EventListener {
        public void issuesUpdated(@NotNull PsModel var1);
    }

    private class IssuesComputed
    extends Update {
        @NotNull
        private final PsModel myModel;

        public IssuesComputed(PsModel model) {
            if (model == null) {
                IssuesComputed.$$$reportNull$$$0(0);
            }
            super((Object)model);
            this.myModel = model;
        }

        public void run() {
            if (PsAnalyzerDaemon.this.isStopped()) {
                PsAnalyzerDaemon.this.myRunning.set(false);
                return;
            }
            ((IssuesUpdatedListener)PsAnalyzerDaemon.this.myIssuesUpdatedEventDispatcher.getMulticaster()).issuesUpdated(this.myModel);
            PsAnalyzerDaemon.this.myRunning.set(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon$IssuesComputed", "<init>"));
        }
    }

    private class AnalyzeStructure
    extends Update {
        @NotNull
        private final PsModel myModel;

        AnalyzeStructure(PsModel model) {
            if (model == null) {
                AnalyzeStructure.$$$reportNull$$$0(0);
            }
            super((Object)model);
            this.myModel = model;
        }

        public void run() {
            try {
                PsAnalyzerDaemon.this.doCheck(this.myModel);
            }
            catch (Throwable e) {
                LOG.error("Failed to analyze " + this.myModel, e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon$AnalyzeStructure", "<init>"));
        }
    }
}

