/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsDaemon
implements Disposable {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final AtomicBoolean myStopped;

    protected PsDaemon(@NotNull PsContext context) {
        if (context == null) {
            PsDaemon.$$$reportNull$$$0(0);
        }
        this.myStopped = new AtomicBoolean(false);
        this.myContext = context;
        Disposer.register((Disposable)context, (Disposable)this);
    }

    @NotNull
    protected final MergingUpdateQueue createQueue(@NotNull String name, @Nullable JComponent modalityStateComponent) {
        if (name == null) {
            PsDaemon.$$$reportNull$$$0(1);
        }
        MergingUpdateQueue mergingUpdateQueue = new MergingUpdateQueue(name, 300, false, modalityStateComponent, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        if (mergingUpdateQueue == null) {
            PsDaemon.$$$reportNull$$$0(2);
        }
        return mergingUpdateQueue;
    }

    public void reset() {
        MergingUpdateQueue mainQueue = this.getMainQueue();
        PsDaemon.reset(mainQueue, this.getResultsUpdaterQueue());
        mainQueue.queue(new Update("reset"){

            public void run() {
                PsDaemon.this.myStopped.set(false);
            }
        });
    }

    private static void reset(MergingUpdateQueue ... queues) {
        if (queues == null) {
            PsDaemon.$$$reportNull$$$0(3);
        }
        for (MergingUpdateQueue queue : queues) {
            queue.activate();
        }
    }

    public void stop() {
        this.myStopped.set(true);
        PsDaemon.stop(this.getMainQueue(), this.getResultsUpdaterQueue());
    }

    private static void stop(MergingUpdateQueue ... queues) {
        if (queues == null) {
            PsDaemon.$$$reportNull$$$0(4);
        }
        for (MergingUpdateQueue queue : queues) {
            queue.cancelAllUpdates();
            queue.deactivate();
        }
    }

    @NotNull
    protected abstract MergingUpdateQueue getMainQueue();

    @NotNull
    protected abstract MergingUpdateQueue getResultsUpdaterQueue();

    protected boolean isStopped() {
        return this.myStopped.get();
    }

    @NotNull
    protected PsContext getContext() {
        PsContext psContext = this.myContext;
        if (psContext == null) {
            PsDaemon.$$$reportNull$$$0(5);
        }
        return psContext;
    }

    public abstract boolean isRunning();

    public void dispose() {
        this.stop();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/daemon/PsDaemon";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/daemon/PsDaemon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createQueue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createQueue";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "stop";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

