/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.memory.model;

import com.android.tools.datastore.DataAdapter;
import com.android.tools.idea.monitor.ui.memory.model.AllocationTrackingSample;
import com.android.tools.idea.monitor.ui.memory.view.MemoryProfilerUiManager;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.google.protobuf3jarjar.ByteString;
import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class MemoryDataCache {
    static final int UNFINISHED_TIMESTAMP = -1;
    private List<MemoryProfiler.MemoryData.MemorySample> myMemorySamples;
    private List<MemoryProfiler.MemoryData.VmStatsSample> myVmStatsSamples;
    private List<MemoryProfiler.HeapDumpInfo> myHeapDumpInfos;
    private Map<MemoryProfiler.HeapDumpInfo, ByteString> myHeapDumps;
    private List<AllocationTrackingSample> myAllocationTrackingSamples;
    private EventDispatcher<MemoryProfilerUiManager.MemoryEventListener> myMemoryEventDispatcher;

    public MemoryDataCache(@NotNull EventDispatcher<MemoryProfilerUiManager.MemoryEventListener> dispatcher) {
        if (dispatcher == null) {
            MemoryDataCache.$$$reportNull$$$0(0);
        }
        this.myMemorySamples = Collections.synchronizedList(new ArrayList());
        this.myVmStatsSamples = Collections.synchronizedList(new ArrayList());
        this.myHeapDumpInfos = Collections.synchronizedList(new ArrayList());
        this.myHeapDumps = new HashMap<MemoryProfiler.HeapDumpInfo, ByteString>();
        this.myAllocationTrackingSamples = Collections.synchronizedList(new ArrayList());
        this.myMemoryEventDispatcher = dispatcher;
    }

    public void appendMemorySamples(@NotNull List<MemoryProfiler.MemoryData.MemorySample> memorySamples) {
        if (memorySamples == null) {
            MemoryDataCache.$$$reportNull$$$0(1);
        }
        this.myMemorySamples.addAll(memorySamples);
    }

    public void appendVmStatsSamples(@NotNull List<MemoryProfiler.MemoryData.VmStatsSample> vmStatsSamples) {
        if (vmStatsSamples == null) {
            MemoryDataCache.$$$reportNull$$$0(2);
        }
        this.myVmStatsSamples.addAll(vmStatsSamples);
    }

    public void appendHeapDumpInfo(@NotNull MemoryProfiler.HeapDumpInfo heapDumpInfo) {
        if (heapDumpInfo == null) {
            MemoryDataCache.$$$reportNull$$$0(3);
        }
        this.myHeapDumpInfos.add(heapDumpInfo);
    }

    public void addPulledHeapDumpData(@NotNull MemoryProfiler.HeapDumpInfo heapDumpInfo, @NotNull ByteString heapDumpFile) {
        if (heapDumpInfo == null) {
            MemoryDataCache.$$$reportNull$$$0(4);
        }
        if (heapDumpFile == null) {
            MemoryDataCache.$$$reportNull$$$0(5);
        }
        this.myHeapDumps.put(heapDumpInfo, heapDumpFile);
        ((MemoryProfilerUiManager.MemoryEventListener)this.myMemoryEventDispatcher.getMulticaster()).newHeapDumpInfosRetrieved(heapDumpInfo);
    }

    public void executeOnHeapDumpData(@NotNull BiConsumer<MemoryProfiler.HeapDumpInfo, ByteString> biConsumer) {
        if (biConsumer == null) {
            MemoryDataCache.$$$reportNull$$$0(6);
        }
        this.myHeapDumps.forEach(biConsumer);
    }

    public void addAllocationTrackingData(@NotNull AllocationTrackingSample allocationTrackingSample) {
        if (allocationTrackingSample == null) {
            MemoryDataCache.$$$reportNull$$$0(7);
        }
        this.myAllocationTrackingSamples.add(allocationTrackingSample);
        ((MemoryProfilerUiManager.MemoryEventListener)this.myMemoryEventDispatcher.getMulticaster()).newAllocationTrackingInfosRetrieved(allocationTrackingSample);
    }

    public void executeOnAllocationTrackingSamples(@NotNull Consumer<AllocationTrackingSample> consumer) {
        if (consumer == null) {
            MemoryDataCache.$$$reportNull$$$0(8);
        }
        this.myAllocationTrackingSamples.forEach(consumer);
    }

    @NotNull
    public MemoryProfiler.MemoryData.MemorySample getMemorySample(int index) {
        MemoryProfiler.MemoryData.MemorySample memorySample = this.myMemorySamples.get(index);
        if (memorySample == null) {
            MemoryDataCache.$$$reportNull$$$0(9);
        }
        return memorySample;
    }

    @NotNull
    public MemoryProfiler.MemoryData.VmStatsSample getVmStatsSample(int index) {
        MemoryProfiler.MemoryData.VmStatsSample vmStatsSample = this.myVmStatsSamples.get(index);
        if (vmStatsSample == null) {
            MemoryDataCache.$$$reportNull$$$0(10);
        }
        return vmStatsSample;
    }

    @NotNull
    public MemoryProfiler.HeapDumpInfo getHeapDumpInfo(int index) {
        MemoryProfiler.HeapDumpInfo heapDumpInfo = this.myHeapDumpInfos.get(index);
        if (heapDumpInfo == null) {
            MemoryDataCache.$$$reportNull$$$0(11);
        }
        return heapDumpInfo;
    }

    @NotNull
    public AllocationTrackingSample getAllocationTrackingSample(int index) {
        AllocationTrackingSample allocationTrackingSample = this.myAllocationTrackingSamples.get(index);
        if (allocationTrackingSample == null) {
            MemoryDataCache.$$$reportNull$$$0(12);
        }
        return allocationTrackingSample;
    }

    @NotNull
    public ByteString getHeapDumpData(@NotNull MemoryProfiler.HeapDumpInfo info) {
        if (info == null) {
            MemoryDataCache.$$$reportNull$$$0(13);
        }
        assert (this.myHeapDumps.containsKey(info));
        ByteString byteString = this.myHeapDumps.get(info);
        if (byteString == null) {
            MemoryDataCache.$$$reportNull$$$0(14);
        }
        return byteString;
    }

    public MemoryProfiler.HeapDumpInfo swapLastHeapDumpInfo(@NotNull MemoryProfiler.HeapDumpInfo info) {
        if (info == null) {
            MemoryDataCache.$$$reportNull$$$0(15);
        }
        int lastIndex = this.getLastHeapDumpIndex();
        MemoryProfiler.HeapDumpInfo result = this.myHeapDumpInfos.get(lastIndex);
        this.myHeapDumpInfos.set(lastIndex, info);
        return result;
    }

    public int getLastHeapDumpIndex() {
        return this.myHeapDumpInfos.size() - 1;
    }

    public int getLatestPriorMemorySampleIndex(long time, boolean leftClosest) {
        int index = Collections.binarySearch(this.myMemorySamples, MemoryProfiler.MemoryData.MemorySample.newBuilder().setTimestamp(time).build(), (left, right) -> {
            long diff = left.getTimestamp() - right.getTimestamp();
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        });
        return DataAdapter.convertBinarySearchIndex((int)index, (int)this.myMemorySamples.size(), (boolean)leftClosest);
    }

    public int getLatestPriorVmStatsSampleIndex(long time, boolean leftClosest) {
        int index = Collections.binarySearch(this.myVmStatsSamples, MemoryProfiler.MemoryData.VmStatsSample.newBuilder().setTimestamp(time).build(), (left, right) -> {
            long diff = left.getTimestamp() - right.getTimestamp();
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        });
        return DataAdapter.convertBinarySearchIndex((int)index, (int)this.myVmStatsSamples.size(), (boolean)leftClosest);
    }

    public int getLatestPriorHeapDumpInfoIndex(long time, boolean leftClosest) {
        int index = Collections.binarySearch(this.myHeapDumpInfos, MemoryProfiler.HeapDumpInfo.newBuilder().setStartTime(time).build(), (left, right) -> {
            long diff = left.getStartTime() - right.getStartTime();
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        });
        return DataAdapter.convertBinarySearchIndex((int)index, (int)this.myHeapDumpInfos.size(), (boolean)leftClosest);
    }

    public int getLatestPriorAllocationTrackingSampleIndex(long time, boolean leftClosest) {
        int index = Collections.binarySearch(this.myAllocationTrackingSamples, new AllocationTrackingSample(time, time, new byte[0]), (left, right) -> {
            long diff = left.getStartTime() - right.getStartTime();
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        });
        return DataAdapter.convertBinarySearchIndex((int)index, (int)this.myAllocationTrackingSamples.size(), (boolean)leftClosest);
    }

    public void reset() {
        this.myMemorySamples.clear();
        this.myVmStatsSamples.clear();
        this.myHeapDumpInfos.clear();
        this.myHeapDumps.clear();
        this.myAllocationTrackingSamples.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dispatcher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memorySamples";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmStatsSamples";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heapDumpInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heapDumpFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "biConsumer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allocationTrackingSample";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/monitor/ui/memory/model/MemoryDataCache";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/monitor/ui/memory/model/MemoryDataCache";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemorySample";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getVmStatsSample";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeapDumpInfo";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationTrackingSample";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeapDumpData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "appendMemorySamples";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendVmStatsSamples";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendHeapDumpInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPulledHeapDumpData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "executeOnHeapDumpData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAllocationTrackingData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeOnAllocationTrackingSamples";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getHeapDumpData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "swapLastHeapDumpInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

