/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalBuildFileNode
extends PsiFileNode {
    @NotNull
    private final String myModuleName;

    public ExternalBuildFileNode(@NotNull Project project, @NotNull PsiFile value, @NotNull ViewSettings viewSettings, @NotNull String moduleName) {
        if (project == null) {
            ExternalBuildFileNode.$$$reportNull$$$0(0);
        }
        if (value == null) {
            ExternalBuildFileNode.$$$reportNull$$$0(1);
        }
        if (viewSettings == null) {
            ExternalBuildFileNode.$$$reportNull$$$0(2);
        }
        if (moduleName == null) {
            ExternalBuildFileNode.$$$reportNull$$$0(3);
        }
        super(project, value, viewSettings);
        this.myModuleName = moduleName;
    }

    public void update(PresentationData data) {
        super.update(data);
        String fileName = this.getPsiFileName();
        data.addText(fileName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        data.setPresentableText(fileName);
        data.addText(" (" + this.myModuleName + ", " + this.getPsiFilePath() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    @Nullable
    public Comparable getSortKey() {
        return this.myModuleName + "-" + this.getPsiFileName() + "-" + this.getPsiFilePath();
    }

    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.getPsiFileName() + " (" + this.myModuleName + ", " + this.getPsiFilePath() + ")";
    }

    @NotNull
    private PsiFile getPsiFile() {
        PsiFile value = (PsiFile)this.getValue();
        assert (value != null);
        PsiFile psiFile = value;
        if (psiFile == null) {
            ExternalBuildFileNode.$$$reportNull$$$0(4);
        }
        return psiFile;
    }

    private String getPsiFileName() {
        return this.getPsiFile().getName();
    }

    private String getPsiFilePath() {
        return FileUtil.getLocationRelativeToUserHome((String)this.getPsiFile().getVirtualFile().getPresentableUrl());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/ExternalBuildFileNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/ExternalBuildFileNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

