/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.icon;

import com.android.assetstudiolib.GraphicGenerator;
import com.android.assetstudiolib.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.AssetStudioGraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.icon.CategoryIconMap;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.android.tools.idea.ui.properties.core.OptionalProperty;
import com.android.tools.idea.ui.properties.core.OptionalValueProperty;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;

public abstract class AndroidIconGenerator {
    private final OptionalProperty<BaseAsset> mySourceAsset = new OptionalValueProperty<BaseAsset>();
    private final StringProperty myName = new StringValueProperty();

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(AndroidIconGenerator.class);
        if (logger == null) {
            AndroidIconGenerator.$$$reportNull$$$0(0);
        }
        return logger;
    }

    @NotNull
    private static Map<String, Map<String, BufferedImage>> newAssetMap() {
        HashMap hashMap = Maps.newHashMap();
        if (hashMap == null) {
            AndroidIconGenerator.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    @NotNull
    public final OptionalProperty<BaseAsset> sourceAsset() {
        OptionalProperty<BaseAsset> optionalProperty = this.mySourceAsset;
        if (optionalProperty == null) {
            AndroidIconGenerator.$$$reportNull$$$0(2);
        }
        return optionalProperty;
    }

    @NotNull
    public final StringProperty name() {
        StringProperty stringProperty = this.myName;
        if (stringProperty == null) {
            AndroidIconGenerator.$$$reportNull$$$0(3);
        }
        return stringProperty;
    }

    @NotNull
    public final CategoryIconMap generateIntoMemory() {
        if (!((Optional)this.mySourceAsset.get()).isPresent()) {
            throw new IllegalStateException("Can't generate icons without a source asset set first");
        }
        Map<String, Map<String, BufferedImage>> categoryMap = AndroidIconGenerator.newAssetMap();
        AssetStudioGraphicGeneratorContext context = new AssetStudioGraphicGeneratorContext();
        GraphicGenerator graphicGenerator = this.createGenerator();
        GraphicGenerator.Options options = this.createOptions(this.mySourceAsset.getValue());
        graphicGenerator.generate(null, categoryMap, (GraphicGeneratorContext)context, options, (String)this.myName.get());
        CategoryIconMap categoryIconMap = new CategoryIconMap(categoryMap);
        if (categoryIconMap == null) {
            AndroidIconGenerator.$$$reportNull$$$0(4);
        }
        return categoryIconMap;
    }

    @NotNull
    public final Map<File, BufferedImage> generateIntoFileMap(@NotNull AndroidProjectPaths paths) {
        if (paths == null) {
            AndroidIconGenerator.$$$reportNull$$$0(5);
        }
        if (((String)this.myName.get()).isEmpty()) {
            throw new IllegalStateException("Can't save icons to disk if a filename isn't set first");
        }
        File resDirectory = paths.getResDirectory();
        if (resDirectory == null || resDirectory.getParentFile() == null) {
            throw new IllegalArgumentException("Invalid paths used when trying to generate an icon");
        }
        CategoryIconMap categoryIconMap = this.generateIntoMemory();
        Map<File, BufferedImage> map = categoryIconMap.toFileMap(resDirectory.getParentFile());
        if (map == null) {
            AndroidIconGenerator.$$$reportNull$$$0(6);
        }
        return map;
    }

    public final void generateImageIconsIntoPath(@NotNull AndroidProjectPaths paths) {
        if (paths == null) {
            AndroidIconGenerator.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Map<File, BufferedImage> pathIconMap = this.generateIntoFileMap(paths);
        for (Map.Entry<File, BufferedImage> fileImageEntry : pathIconMap.entrySet()) {
            File file = fileImageEntry.getKey();
            BufferedImage image = fileImageEntry.getValue();
            if (FileUtilRt.extensionEquals((String)file.getName(), (String)"png")) {
                this.writePngToDisk(file, image);
                continue;
            }
            AndroidIconGenerator.getLog().error("Please report this error. Unable to create icon for invalid file: " + file.getAbsolutePath());
        }
    }

    @NotNull
    protected abstract GraphicGenerator createGenerator();

    @NotNull
    protected abstract GraphicGenerator.Options createOptions(@NotNull Class<? extends BaseAsset> var1);

    @NotNull
    private GraphicGenerator.Options createOptions(@NotNull BaseAsset baseAsset) {
        if (baseAsset == null) {
            AndroidIconGenerator.$$$reportNull$$$0(8);
        }
        GraphicGenerator.Options options = this.createOptions(baseAsset.getClass());
        options.sourceImage = baseAsset.toImage();
        GraphicGenerator.Options options2 = options;
        if (options2 == null) {
            AndroidIconGenerator.$$$reportNull$$$0(9);
        }
        return options2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePngToDisk(@NotNull File file, @NotNull BufferedImage image) {
        if (file == null) {
            AndroidIconGenerator.$$$reportNull$$$0(10);
        }
        if (image == null) {
            AndroidIconGenerator.$$$reportNull$$$0(11);
        }
        try {
            VirtualFile directory = VfsUtil.createDirectories((String)file.getParentFile().getAbsolutePath());
            VirtualFile imageFile = directory.findChild(file.getName());
            if (imageFile == null || !imageFile.exists()) {
                imageFile = directory.createChildData((Object)this, file.getName());
            }
            try (OutputStream outputStream = imageFile.getOutputStream((Object)this);){
                ImageIO.write((RenderedImage)image, "PNG", outputStream);
            }
        }
        catch (IOException e) {
            AndroidIconGenerator.getLog().error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/icon/AndroidIconGenerator";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseAsset";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "newAssetMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "sourceAsset";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIntoMemory";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/icon/AndroidIconGenerator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIntoFileMap";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generateIntoFileMap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateImageIconsIntoPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createOptions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writePngToDisk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

