/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.platform;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.targets.AndroidTargetManager;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidVersionsInfo {
    private static final ProgressIndicator REPO_LOG = new StudioLoggerProgressIndicator(AndroidVersionsInfo.class);
    private static final IdDisplay NO_MATCH = IdDisplay.create((String)"no_match", (String)"No Match");
    private final List<VersionItem> myTargetVersions = Lists.newArrayList();
    private final Set<AndroidVersion> myInstalledVersions = Sets.newHashSet();
    private IAndroidTarget myHighestInstalledApiTarget;

    public void load() {
        this.loadTargetVersions();
        this.loadInstalledVersions();
    }

    public void loadInstalledVersions() {
        this.myInstalledVersions.clear();
        IAndroidTarget highestInstalledTarget = null;
        for (IAndroidTarget target : AndroidVersionsInfo.getCompilationTargets()) {
            if (target.isPlatform() && target.getVersion().getFeatureLevel() >= 22 && (highestInstalledTarget == null || target.getVersion().getFeatureLevel() > highestInstalledTarget.getVersion().getFeatureLevel() && !target.getVersion().isPreview())) {
                highestInstalledTarget = target;
            }
            if (!target.getVersion().isPreview() && target.getAdditionalLibraries().isEmpty()) continue;
            this.myInstalledVersions.add(target.getVersion());
        }
        this.myHighestInstalledApiTarget = highestInstalledTarget;
    }

    @Nullable(value="If we don't know (yet) the highest installed version")
    AndroidVersion getHighestInstalledVersion() {
        return this.myHighestInstalledApiTarget == null ? null : this.myHighestInstalledApiTarget.getVersion();
    }

    @NotNull
    public Collection<String> getInstallRequestPaths(VersionItem ... versionItems) {
        if (versionItems == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(0);
        }
        HashSet res = Sets.newHashSet();
        for (VersionItem versionItem : versionItems) {
            AndroidVersion androidVersion = versionItem.myAndroidVersion;
            String platformPath = DetailsTypes.getPlatformPath((AndroidVersion)androidVersion);
            if (versionItem.myAddon != null) {
                res.add(versionItem.myAddon.getPath());
                AndroidTargetManager targetManager = AndroidSdks.getInstance().tryToChooseSdkHandler().getAndroidTargetManager(REPO_LOG);
                if (targetManager.getTargetFromHashString(AndroidTargetHash.getPlatformHashString((AndroidVersion)androidVersion), REPO_LOG) != null) continue;
                res.add(platformPath);
                continue;
            }
            if (this.myHighestInstalledApiTarget != null && (androidVersion.getApiLevel() <= this.myHighestInstalledApiTarget.getVersion().getApiLevel() || this.myInstalledVersions.contains(androidVersion))) continue;
            res.add(DetailsTypes.getPlatformPath((AndroidVersion)new AndroidVersion(25, null)));
        }
        HashSet hashSet = res;
        if (hashSet == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    public void loadTargetVersions(@NotNull FormFactor formFactor, int minSdkLevel, ItemsLoaded itemsLoadedCallback) {
        if (formFactor == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(2);
        }
        ArrayList<VersionItem> versionItemList = new ArrayList<VersionItem>();
        for (VersionItem target : this.myTargetVersions) {
            if (!AndroidVersionsInfo.isFormFactorAvailable(formFactor, minSdkLevel, target.getApiLevel()) && (target.getAndroidTarget() == null || !target.getAndroidTarget().getVersion().isPreview())) continue;
            versionItemList.add(target);
        }
        this.loadRemoteTargets(formFactor, minSdkLevel, versionItemList, itemsLoadedCallback);
    }

    private void loadTargetVersions() {
        this.myTargetVersions.clear();
        if (AndroidSdkUtils.isAndroidSdkAvailable()) {
            String[] knownVersions = TemplateUtils.getKnownVersions();
            for (int i = 0; i < knownVersions.length; ++i) {
                this.myTargetVersions.add(new VersionItem(this, knownVersions[i], i + 1));
            }
        }
        for (IAndroidTarget target : AndroidVersionsInfo.getCompilationTargets()) {
            if (!target.getVersion().isPreview() && target.getAdditionalLibraries().isEmpty()) continue;
            this.myTargetVersions.add(new VersionItem(this, target));
        }
    }

    @NotNull
    private static IAndroidTarget[] getCompilationTargets() {
        AndroidTargetManager targetManager = AndroidSdks.getInstance().tryToChooseSdkHandler().getAndroidTargetManager(REPO_LOG);
        ArrayList result = Lists.newArrayList();
        for (IAndroidTarget target : targetManager.getTargets(REPO_LOG)) {
            if (!target.isPlatform()) continue;
            result.add(target);
        }
        IAndroidTarget[] iAndroidTargetArray = result.toArray(new IAndroidTarget[result.size()]);
        if (iAndroidTargetArray == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(3);
        }
        return iAndroidTargetArray;
    }

    private void loadRemoteTargets(@NotNull FormFactor myFormFactor, int minSdkLevel, @NotNull List<VersionItem> versionItemList, ItemsLoaded completedCallback) {
        if (myFormFactor == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(4);
        }
        if (versionItemList == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(5);
        }
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        Runnable runCallbacks = () -> {
            if (versionItemList == null) {
                AndroidVersionsInfo.$$$reportNull$$$0(29);
            }
            if (completedCallback != null) {
                completedCallback.onDataLoadedFinished(versionItemList);
            }
        };
        RepoManager.RepoLoadedCallback onComplete = packages -> {
            if (myFormFactor == null) {
                AndroidVersionsInfo.$$$reportNull$$$0(27);
            }
            if (versionItemList == null) {
                AndroidVersionsInfo.$$$reportNull$$$0(28);
            }
            this.addPackages(myFormFactor, versionItemList, packages.getNewPkgs(), minSdkLevel);
            this.addOfflineLevels(myFormFactor, versionItemList);
            runCallbacks.run();
        };
        RepoManager.RepoLoadedCallback onLocalComplete = packages -> {
            if (myFormFactor == null) {
                AndroidVersionsInfo.$$$reportNull$$$0(25);
            }
            if (versionItemList == null) {
                AndroidVersionsInfo.$$$reportNull$$$0(26);
            }
            this.addPackages(myFormFactor, versionItemList, packages.getLocalPackages().values(), minSdkLevel);
        };
        Runnable onError = () -> {
            if (myFormFactor == null) {
                AndroidVersionsInfo.$$$reportNull$$$0(21);
            }
            if (versionItemList == null) {
                AndroidVersionsInfo.$$$reportNull$$$0(22);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (myFormFactor == null) {
                    AndroidVersionsInfo.$$$reportNull$$$0(23);
                }
                if (versionItemList == null) {
                    AndroidVersionsInfo.$$$reportNull$$$0(24);
                }
                this.addOfflineLevels(myFormFactor, versionItemList);
                runCallbacks.run();
            }, ModalityState.any());
        };
        StudioProgressRunner runner = new StudioProgressRunner(false, false, "Refreshing Targets", true, null);
        sdkHandler.getSdkManager(REPO_LOG).load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (List)ImmutableList.of((Object)onLocalComplete), (List)ImmutableList.of((Object)onComplete), (List)ImmutableList.of((Object)onError), (ProgressRunner)runner, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), false);
    }

    private static boolean filterPkgDesc(@NotNull RepoPackage p, @NotNull FormFactor formFactor, int minSdkLevel) {
        if (p == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(6);
        }
        if (formFactor == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(7);
        }
        return AndroidVersionsInfo.isApiType(p) && AndroidVersionsInfo.doFilter(formFactor, minSdkLevel, AndroidVersionsInfo.getTag(p), AndroidVersionsInfo.getFeatureLevel(p));
    }

    private static boolean doFilter(@NotNull FormFactor formFactor, int minSdkLevel, @Nullable IdDisplay tag, int targetSdkLevel) {
        if (formFactor == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(8);
        }
        return formFactor.isSupported(tag, targetSdkLevel) && targetSdkLevel >= minSdkLevel;
    }

    private static boolean isApiType(@NotNull RepoPackage repoPackage) {
        if (repoPackage == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(9);
        }
        return repoPackage.getTypeDetails() instanceof DetailsTypes.ApiDetailsType;
    }

    private static int getFeatureLevel(@NotNull RepoPackage repoPackage) {
        if (repoPackage == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(10);
        }
        return AndroidVersionsInfo.getAndroidVersion(repoPackage).getFeatureLevel();
    }

    private static boolean isFormFactorAvailable(@NotNull FormFactor formFactor, int minSdkLevel, int targetSdkLevel) {
        if (formFactor == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(11);
        }
        return AndroidVersionsInfo.doFilter(formFactor, minSdkLevel, SystemImage.DEFAULT_TAG, targetSdkLevel);
    }

    @NotNull
    private static AndroidVersion getAndroidVersion(@NotNull RepoPackage repoPackage) {
        TypeDetails details;
        if (repoPackage == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(12);
        }
        if ((details = repoPackage.getTypeDetails()) instanceof DetailsTypes.ApiDetailsType) {
            AndroidVersion androidVersion = ((DetailsTypes.ApiDetailsType)details).getAndroidVersion();
            if (androidVersion == null) {
                AndroidVersionsInfo.$$$reportNull$$$0(13);
            }
            return androidVersion;
        }
        throw new RuntimeException("Could not determine version");
    }

    @Nullable
    private static IdDisplay getTag(@NotNull RepoPackage repoPackage) {
        DetailsTypes.SysImgDetailsType imgDetailsType;
        if (repoPackage == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(14);
        }
        TypeDetails details = repoPackage.getTypeDetails();
        IdDisplay tag = NO_MATCH;
        if (details instanceof DetailsTypes.AddonDetailsType) {
            tag = ((DetailsTypes.AddonDetailsType)details).getTag();
        }
        if (details instanceof DetailsTypes.SysImgDetailsType && (imgDetailsType = (DetailsTypes.SysImgDetailsType)details).getAbi().equals("x86")) {
            tag = imgDetailsType.getTag();
        }
        return tag;
    }

    private void addPackages(@NotNull FormFactor myFormFactor, @NotNull List<VersionItem> versionItemList, @NotNull Collection<? extends RepoPackage> packages, int minSdkLevel) {
        if (myFormFactor == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(15);
        }
        if (versionItemList == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(16);
        }
        if (packages == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(17);
        }
        List sorted = packages.stream().filter(repoPackage -> {
            if (myFormFactor == null) {
                AndroidVersionsInfo.$$$reportNull$$$0(20);
            }
            return repoPackage != null && AndroidVersionsInfo.filterPkgDesc(repoPackage, myFormFactor, minSdkLevel);
        }).collect(Collectors.toList());
        Collections.sort(sorted, (repoPackage, other) -> AndroidVersionsInfo.getAndroidVersion(repoPackage).compareTo(AndroidVersionsInfo.getAndroidVersion(other)));
        int existingApiLevel = -1;
        int prevInsertedApiLevel = -1;
        int index = -1;
        for (RepoPackage info : sorted) {
            int apiLevel = AndroidVersionsInfo.getFeatureLevel(info);
            while (apiLevel > existingApiLevel) {
                existingApiLevel = ++index < versionItemList.size() ? versionItemList.get(index).myApiLevel : Integer.MAX_VALUE;
            }
            if (apiLevel == existingApiLevel || apiLevel == prevInsertedApiLevel) continue;
            versionItemList.add(index++, new VersionItem(this, info));
            prevInsertedApiLevel = apiLevel;
        }
    }

    private void addOfflineLevels(@NotNull FormFactor myFormFactor, @NotNull List<VersionItem> versionItemList) {
        if (myFormFactor == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(18);
        }
        if (versionItemList == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(19);
        }
        int existingApiLevel = -1;
        int prevInsertedApiLevel = -1;
        int index = -1;
        for (int apiLevel = myFormFactor.getMinOfflineApiLevel(); apiLevel <= myFormFactor.getMaxOfflineApiLevel(); ++apiLevel) {
            if (myFormFactor.isSupported(null, apiLevel) || apiLevel <= 0) continue;
            while (apiLevel > existingApiLevel) {
                existingApiLevel = ++index < versionItemList.size() ? versionItemList.get(index).myApiLevel : Integer.MAX_VALUE;
            }
            if (apiLevel == existingApiLevel || apiLevel == prevInsertedApiLevel) continue;
            versionItemList.add(index++, new VersionItem(this, apiLevel));
            prevInsertedApiLevel = apiLevel;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionItems";
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/platform/AndroidVersionsInfo";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formFactor";
                break;
            }
            case 4: 
            case 15: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myFormFactor";
                break;
            }
            case 5: 
            case 16: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionItemList";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoPackage";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/platform/AndroidVersionsInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallRequestPaths";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilationTargets";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstallRequestPaths";
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadTargetVersions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadRemoteTargets";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filterPkgDesc";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doFilter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isApiType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFeatureLevel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isFormFactorAvailable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidVersion";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTag";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addPackages";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addOfflineLevels";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addPackages$5";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadRemoteTargets$4";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadRemoteTargets$2";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadRemoteTargets$1";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadRemoteTargets$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class VersionItem {
        private final AndroidVersion myAndroidVersion;
        private final String myLabel;
        private final int myApiLevel;
        private final String myApiLevelStr;
        private IAndroidTarget myAndroidTarget;
        private RemotePackage myAddon;
        final /* synthetic */ AndroidVersionsInfo this$0;

        VersionItem(@NotNull AndroidVersionsInfo this$0, @NotNull AndroidVersion androidVersion, IdDisplay tag) {
            if (androidVersion == null) {
                VersionItem.$$$reportNull$$$0(0);
            }
            if (tag == null) {
                VersionItem.$$$reportNull$$$0(1);
            }
            this.this$0 = this$0;
            this.myAndroidVersion = androidVersion;
            this.myLabel = this.getLabel(androidVersion, tag);
            this.myApiLevel = androidVersion.getFeatureLevel();
            this.myApiLevelStr = androidVersion.getApiString();
        }

        VersionItem(@NotNull AndroidVersionsInfo this$0, String label, int apiLevel) {
            if (label == null) {
                VersionItem.$$$reportNull$$$0(2);
            }
            this.this$0 = this$0;
            this.myAndroidVersion = new AndroidVersion(apiLevel, null);
            this.myLabel = label;
            this.myApiLevel = apiLevel;
            this.myApiLevelStr = Integer.toString(apiLevel);
        }

        VersionItem(AndroidVersionsInfo this$0, int apiLevel) {
            this(this$0, new AndroidVersion(apiLevel, null), SystemImage.DEFAULT_TAG);
        }

        VersionItem(@NotNull AndroidVersionsInfo this$0, IAndroidTarget target) {
            if (target == null) {
                VersionItem.$$$reportNull$$$0(3);
            }
            this(this$0, target.getVersion(), SystemImage.DEFAULT_TAG);
            this.myAndroidTarget = target;
        }

        VersionItem(@NotNull AndroidVersionsInfo this$0, RepoPackage info) {
            if (info == null) {
                VersionItem.$$$reportNull$$$0(4);
            }
            this(this$0, AndroidVersionsInfo.getAndroidVersion(info), AndroidVersionsInfo.getTag(info));
            if (info instanceof RemotePackage && SystemImage.GLASS_TAG.equals((Object)AndroidVersionsInfo.getTag(info))) {
                this.myAddon = (RemotePackage)info;
            }
        }

        @Nullable(value="null except for preview releases")
        public IAndroidTarget getAndroidTarget() {
            return this.myAndroidTarget;
        }

        @Nullable(value="null except when an addon needs to be installed (eg Google Glass)")
        public RemotePackage getAddon() {
            return this.myAddon;
        }

        public int getApiLevel() {
            return this.myApiLevel;
        }

        @NotNull
        public String getApiLevelStr() {
            String string = this.myApiLevelStr;
            if (string == null) {
                VersionItem.$$$reportNull$$$0(5);
            }
            return string;
        }

        public int getBuildApiLevel() {
            int apiLevel = this.myAddon != null ? this.myApiLevel : (this.myAndroidTarget == null ? 25 : (this.myAndroidTarget.getVersion().isPreview() || !this.myAndroidTarget.isPlatform() ? this.myApiLevel : (this.this$0.getHighestInstalledVersion() == null ? 0 : this.this$0.getHighestInstalledVersion().getFeatureLevel())));
            return apiLevel;
        }

        @NotNull
        public String getBuildApiLevelStr() {
            if (this.myAndroidTarget == null) {
                String string = Integer.toString(this.getBuildApiLevel());
                if (string == null) {
                    VersionItem.$$$reportNull$$$0(6);
                }
                return string;
            }
            if (this.myAndroidTarget.isPlatform()) {
                String string = TemplateMetadata.getBuildApiString(this.myAndroidTarget.getVersion());
                if (string == null) {
                    VersionItem.$$$reportNull$$$0(7);
                }
                return string;
            }
            String string = AndroidTargetHash.getTargetHashString((IAndroidTarget)this.myAndroidTarget);
            if (string == null) {
                VersionItem.$$$reportNull$$$0(8);
            }
            return string;
        }

        public int getTargetApiLevel() {
            int buildApiLevel = this.getBuildApiLevel();
            if (buildApiLevel >= 25 || this.myAndroidTarget != null && this.myAndroidTarget.getVersion().isPreview()) {
                return buildApiLevel;
            }
            return this.this$0.getHighestInstalledVersion() == null ? 0 : this.this$0.getHighestInstalledVersion().getApiLevel();
        }

        @NotNull
        public String getTargetApiLevelStr() {
            int buildApiLevel = this.getBuildApiLevel();
            if (buildApiLevel >= 25 || this.myAndroidTarget != null && this.myAndroidTarget.getVersion().isPreview()) {
                String string = this.myAndroidTarget == null ? Integer.toString(buildApiLevel) : this.myAndroidTarget.getVersion().getApiString();
                if (string == null) {
                    VersionItem.$$$reportNull$$$0(9);
                }
                return string;
            }
            String string = this.this$0.getHighestInstalledVersion() == null ? "" : this.this$0.getHighestInstalledVersion().getApiString();
            if (string == null) {
                VersionItem.$$$reportNull$$$0(10);
            }
            return string;
        }

        @NotNull
        public String getLabel() {
            String string = this.myLabel;
            if (string == null) {
                VersionItem.$$$reportNull$$$0(11);
            }
            return string;
        }

        @NotNull
        private String getLabel(@NotNull AndroidVersion version, @Nullable IdDisplay tag) {
            if (version == null) {
                VersionItem.$$$reportNull$$$0(12);
            }
            int featureLevel = version.getFeatureLevel();
            if (SystemImage.GLASS_TAG.equals((Object)tag)) {
                String string = String.format("Glass Development Kit Preview (API %1$d)", featureLevel);
                if (string == null) {
                    VersionItem.$$$reportNull$$$0(13);
                }
                return string;
            }
            if (featureLevel <= 25) {
                if (version.isPreview()) {
                    String string = String.format("API %1$s: Android %2$s (%3$s preview)", SdkVersionInfo.getCodeName((int)featureLevel), SdkVersionInfo.getVersionString((int)featureLevel), SdkVersionInfo.getCodeName((int)featureLevel));
                    if (string == null) {
                        VersionItem.$$$reportNull$$$0(14);
                    }
                    return string;
                }
                String string = SdkVersionInfo.getAndroidName((int)featureLevel);
                if (string == null) {
                    VersionItem.$$$reportNull$$$0(15);
                }
                return string;
            }
            if (version.isPreview()) {
                String string = String.format("API %1$d: Android (%2$s)", featureLevel, version.getCodename());
                if (string == null) {
                    VersionItem.$$$reportNull$$$0(16);
                }
                return string;
            }
            String string = String.format("API %1$d: Android", featureLevel);
            if (string == null) {
                VersionItem.$$$reportNull$$$0(17);
            }
            return string;
        }

        public String toString() {
            return this.myLabel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "androidVersion";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/platform/AndroidVersionsInfo$VersionItem";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/platform/AndroidVersionsInfo$VersionItem";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getApiLevelStr";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBuildApiLevelStr";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetApiLevelStr";
                    break;
                }
                case 11: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLabel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getLabel";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ItemsLoaded {
        public void onDataLoadedFinished(List<VersionItem> var1);
    }
}

