/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.android.tools.idea.wizard.model.WizardModel;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Locale;
import java.util.regex.Pattern;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class NewProjectModel
extends WizardModel {
    private static final String PROPERTIES_DOMAIN_KEY = "SAVED_COMPANY_DOMAIN";
    private static final String EXAMPLE_DOMAIN = "example.com";
    private static final Pattern DISALLOWED_IN_DOMAIN = Pattern.compile("[^a-zA-Z0-9_]");
    private final StringProperty myApplicationName = new StringValueProperty("My Application");
    private final StringProperty myCompanyDomain = new StringValueProperty(NewProjectModel.getInitialDomain(true));
    private final StringProperty myPackageName = new StringValueProperty();
    private final StringProperty myProjectLocation = new StringValueProperty();
    private final BoolProperty myEnableCppSupport = new BoolValueProperty(false);

    public NewProjectModel() {
        this.myCompanyDomain.addListener(sender -> {
            String domain = (String)this.myCompanyDomain.get();
            if (AndroidUtils.isValidAndroidPackageName(domain)) {
                PropertiesComponent.getInstance().setValue(PROPERTIES_DOMAIN_KEY, domain);
            }
        });
    }

    public StringProperty packageName() {
        return this.myPackageName;
    }

    public StringProperty applicationName() {
        return this.myApplicationName;
    }

    public StringProperty companyDomain() {
        return this.myCompanyDomain;
    }

    public StringProperty projectLocation() {
        return this.myProjectLocation;
    }

    public BoolProperty enableCppSupport() {
        return this.myEnableCppSupport;
    }

    @NotNull
    public static String getInitialDomain(boolean includeUserName) {
        String domain = PropertiesComponent.getInstance().getValue(PROPERTIES_DOMAIN_KEY);
        if (domain != null) {
            String string = domain;
            if (string == null) {
                NewProjectModel.$$$reportNull$$$0(0);
            }
            return string;
        }
        String userName = includeUserName ? System.getProperty("user.name") : null;
        String string = userName == null ? EXAMPLE_DOMAIN : NewProjectModel.toPackagePart(userName) + '.' + EXAMPLE_DOMAIN;
        if (string == null) {
            NewProjectModel.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String toPackagePart(@NotNull String s) {
        String name;
        if (s == null) {
            NewProjectModel.$$$reportNull$$$0(2);
        }
        if (!(name = DISALLOWED_IN_DOMAIN.matcher(s = s.replace('-', '_')).replaceAll("").toLowerCase(Locale.US)).isEmpty() && AndroidUtils.isReservedKeyword(name) != null) {
            name = StringUtil.fixVariableNameDerivedFromPropertyName((String)name).toLowerCase(Locale.US);
        }
        String string = name;
        if (string == null) {
            NewProjectModel.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String sanitizeApplicationName(@NotNull String s) {
        if (s == null) {
            NewProjectModel.$$$reportNull$$$0(4);
        }
        String string = DISALLOWED_IN_DOMAIN.matcher(s).replaceAll("");
        if (string == null) {
            NewProjectModel.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    protected void handleFinished() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/project/NewProjectModel";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialDomain";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/project/NewProjectModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toPackagePart";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeApplicationName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toPackagePart";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeApplicationName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

