/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.res.ResourceClassRegistry;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.uipreview.ModuleClassLoader;
import org.jetbrains.android.util.AndroidBundle;

public class RefreshRenderAction
extends AnAction {
    private final EditorDesignSurface mySurface;

    public RefreshRenderAction(EditorDesignSurface surface) {
        super(AndroidBundle.message("android.layout.preview.refresh.action.text", new Object[0]), null, AllIcons.Actions.Refresh);
        this.mySurface = surface;
    }

    public void actionPerformed(AnActionEvent e) {
        RefreshRenderAction.clearCache(this.mySurface);
    }

    public static void clearCache(EditorDesignSurface surface) {
        ModuleClassLoader.clearCache();
        Configuration configuration = surface.getConfiguration();
        if (configuration != null) {
            AndroidFacet facet;
            IAndroidTarget target = configuration.getTarget();
            Module module = configuration.getModule();
            if (module != null) {
                AndroidTargetData targetData;
                ResourceClassRegistry.get(module.getProject()).clearCache();
                if (target != null && (targetData = AndroidTargetData.getTargetData(target, module)) != null) {
                    targetData.clearLayoutBitmapCache(module);
                }
            }
            if ((facet = AndroidFacet.getInstance(configuration.getModule())) != null) {
                facet.refreshResources();
            }
            configuration.updated(254);
        }
        surface.requestRender();
    }
}

