/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.rendering.RenderParamsFlags;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.ide.common.rendering.api.DrawableParams;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.IImageFactory;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.resources.LayoutDirection;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.diagnostics.crash.CrashReport;
import com.android.tools.idea.diagnostics.crash.CrashReporter;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.rendering.ActionBarHandler;
import com.android.tools.idea.rendering.ImagePool;
import com.android.tools.idea.rendering.IncludeReference;
import com.android.tools.idea.rendering.LayoutFilePullParser;
import com.android.tools.idea.rendering.LayoutPsiPullParser;
import com.android.tools.idea.rendering.LayoutPullParserFactory;
import com.android.tools.idea.rendering.LayoutlibCallbackImpl;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.rendering.RenderSecurityManagerFactory;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.rendering.multi.RenderPreviewMode;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.AssetRepositoryImpl;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.swing.layoutlib.FakeImageFactory;
import com.google.common.collect.Maps;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.reference.SoftReference;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParserException;

public class RenderTask
implements IImageFactory {
    private static final Logger LOG = Logger.getInstance(RenderTask.class);
    private final ImagePool myImagePool;
    @NotNull
    private final RenderService myRenderService;
    @Nullable
    private XmlFile myPsiFile;
    @NotNull
    private final RenderLogger myLogger;
    @NotNull
    private final LayoutlibCallbackImpl myLayoutlibCallback;
    private final AndroidVersion myMinSdkVersion;
    private final AndroidVersion myTargetSdkVersion;
    @NotNull
    private final LayoutLibrary myLayoutLib;
    @NotNull
    private final HardwareConfigHelper myHardwareConfigHelper;
    @Nullable
    private IncludeReference myIncludedWithin;
    @NotNull
    private SessionParams.RenderingMode myRenderingMode;
    @Nullable
    private Integer myOverrideBgColor;
    private boolean myShowDecorations;
    @NotNull
    private final Configuration myConfiguration;
    @NotNull
    private final AssetRepositoryImpl myAssetRepository;
    private long myTimeout;
    @Nullable
    private Set<XmlTag> myExpandNodes;
    @Nullable
    private EditorDesignSurface mySurface;
    @NotNull
    private final Locale myLocale;
    private final Object myCredential;
    private ResourceFolderType myFolderType;
    private boolean myProvideCookiesForIncludedViews;
    private final FakeImageFactory myFakeImageFactory;
    private RenderSession myRenderSession;
    private IImageFactory myImageFactoryDelegate;
    private SoftReference<BufferedImage> myCachedImageReference;
    private boolean isSecurityManagerEnabled;
    private CrashReporter myCrashReporter;

    RenderTask(@NotNull RenderService renderService, @NotNull Configuration configuration, @NotNull RenderLogger logger, @NotNull LayoutLibrary layoutLib, @NotNull Device device, @NotNull Object credential, @NotNull CrashReporter crashReporter) {
        if (renderService == null) {
            RenderTask.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            RenderTask.$$$reportNull$$$0(1);
        }
        if (logger == null) {
            RenderTask.$$$reportNull$$$0(2);
        }
        if (layoutLib == null) {
            RenderTask.$$$reportNull$$$0(3);
        }
        if (device == null) {
            RenderTask.$$$reportNull$$$0(4);
        }
        if (credential == null) {
            RenderTask.$$$reportNull$$$0(5);
        }
        if (crashReporter == null) {
            RenderTask.$$$reportNull$$$0(6);
        }
        this.myImagePool = new ImagePool();
        this.myRenderingMode = SessionParams.RenderingMode.NORMAL;
        this.myShowDecorations = true;
        this.myProvideCookiesForIncludedViews = false;
        this.myFakeImageFactory = new FakeImageFactory();
        this.isSecurityManagerEnabled = true;
        this.myRenderService = renderService;
        this.myLogger = logger;
        this.myCredential = credential;
        this.myConfiguration = configuration;
        this.myCrashReporter = crashReporter;
        AndroidFacet facet = renderService.getFacet();
        Module module = facet.getModule();
        this.myAssetRepository = new AssetRepositoryImpl(facet);
        this.myHardwareConfigHelper = new HardwareConfigHelper(device);
        this.myHardwareConfigHelper.setOrientation(configuration.getFullConfig().getScreenOrientationQualifier().getValue());
        this.myLayoutLib = layoutLib;
        AppResourceRepository appResources = AppResourceRepository.getAppResources(facet, true);
        ActionBarHandler actionBarHandler = new ActionBarHandler(this, this.myCredential);
        this.myLayoutlibCallback = new LayoutlibCallbackImpl(this, this.myLayoutLib, appResources, module, facet, this.myLogger, this.myCredential, actionBarHandler);
        this.myLayoutlibCallback.loadAndParseRClass();
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(facet);
        this.myMinSdkVersion = moduleInfo.getMinSdkVersion();
        this.myTargetSdkVersion = moduleInfo.getTargetSdkVersion();
        this.myLocale = configuration.getLocale();
    }

    public void setPsiFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            RenderTask.$$$reportNull$$$0(7);
        }
        if (!(psiFile instanceof XmlFile)) {
            throw new IllegalArgumentException("Can only render XML files: " + psiFile.getClass().getName());
        }
        this.myPsiFile = (XmlFile)psiFile;
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                RenderTask.this.myFolderType = ResourceHelper.getFolderType((PsiFile)RenderTask.this.myPsiFile);
            }
        });
    }

    @Nullable
    public AndroidPlatform getPlatform() {
        return this.myRenderService.getPlatform();
    }

    @Nullable
    public ResourceResolver getResourceResolver() {
        return this.myConfiguration.getResourceResolver();
    }

    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            RenderTask.$$$reportNull$$$0(8);
        }
        return configuration;
    }

    @Nullable
    public ResourceFolderType getFolderType() {
        return this.myFolderType;
    }

    public void setFolderType(@NotNull ResourceFolderType folderType) {
        if (folderType == null) {
            RenderTask.$$$reportNull$$$0(9);
        }
        this.myFolderType = folderType;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myRenderService.getModule();
        if (module == null) {
            RenderTask.$$$reportNull$$$0(10);
        }
        return module;
    }

    @NotNull
    public RenderLogger getLogger() {
        RenderLogger renderLogger = this.myLogger;
        if (renderLogger == null) {
            RenderTask.$$$reportNull$$$0(11);
        }
        return renderLogger;
    }

    @Nullable
    public Set<XmlTag> getExpandNodes() {
        return this.myExpandNodes;
    }

    @NotNull
    public HardwareConfigHelper getHardwareConfigHelper() {
        HardwareConfigHelper hardwareConfigHelper = this.myHardwareConfigHelper;
        if (hardwareConfigHelper == null) {
            RenderTask.$$$reportNull$$$0(12);
        }
        return hardwareConfigHelper;
    }

    public boolean getShowDecorations() {
        return this.myShowDecorations;
    }

    public void dispose() {
        this.myImagePool.dispose();
        this.myLayoutlibCallback.setLogger(null);
        this.myLayoutlibCallback.setResourceResolver(null);
        if (this.myRenderSession != null) {
            assert (ApplicationManager.getApplication().isDispatchThread() || !ApplicationManager.getApplication().isReadAccessAllowed()) : "Do not hold read lock during dispose!";
            try {
                RenderService.runRenderAction(() -> ((RenderSession)this.myRenderSession).dispose());
                this.myRenderSession = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.myImageFactoryDelegate = null;
    }

    public RenderTask setOverrideRenderSize(int overrideRenderWidth, int overrideRenderHeight) {
        this.myHardwareConfigHelper.setOverrideRenderSize(overrideRenderWidth, overrideRenderHeight);
        return this;
    }

    public RenderTask setMaxRenderSize(int maxRenderWidth, int maxRenderHeight) {
        this.myHardwareConfigHelper.setMaxRenderSize(maxRenderWidth, maxRenderHeight);
        return this;
    }

    public RenderTask setRenderingMode(@NotNull SessionParams.RenderingMode renderingMode) {
        if (renderingMode == null) {
            RenderTask.$$$reportNull$$$0(13);
        }
        this.myRenderingMode = renderingMode;
        return this;
    }

    @NotNull
    public SessionParams.RenderingMode getRenderingMode() {
        SessionParams.RenderingMode renderingMode = this.myRenderingMode;
        if (renderingMode == null) {
            RenderTask.$$$reportNull$$$0(14);
        }
        return renderingMode;
    }

    public RenderTask setTimeout(long timeout) {
        this.myTimeout = timeout;
        return this;
    }

    @NotNull
    public RenderTask setOverrideBgColor(@Nullable Integer overrideBgColor) {
        this.myOverrideBgColor = overrideBgColor;
        RenderTask renderTask = this;
        if (renderTask == null) {
            RenderTask.$$$reportNull$$$0(15);
        }
        return renderTask;
    }

    public RenderTask setDecorations(boolean showDecorations) {
        this.myShowDecorations = showDecorations;
        return this;
    }

    @Nullable
    public EditorDesignSurface getDesignSurface() {
        return this.mySurface;
    }

    @Nullable
    public RenderTask setDesignSurface(@Nullable EditorDesignSurface surface) {
        this.mySurface = surface;
        return this;
    }

    @NotNull
    public RenderTask setNodesToExpand(@Nullable Set<XmlTag> nodesToExpand) {
        this.myExpandNodes = nodesToExpand;
        RenderTask renderTask = this;
        if (renderTask == null) {
            RenderTask.$$$reportNull$$$0(16);
        }
        return renderTask;
    }

    @NotNull
    public RenderTask setIncludedWithin(@Nullable IncludeReference includedWithin) {
        this.myIncludedWithin = includedWithin;
        RenderTask renderTask = this;
        if (renderTask == null) {
            RenderTask.$$$reportNull$$$0(17);
        }
        return renderTask;
    }

    @NotNull
    public IncludeReference getIncludedWithin() {
        IncludeReference includeReference = this.myIncludedWithin != null ? this.myIncludedWithin : IncludeReference.NONE;
        if (includeReference == null) {
            RenderTask.$$$reportNull$$$0(18);
        }
        return includeReference;
    }

    public boolean getProvideCookiesForIncludedViews() {
        return this.myProvideCookiesForIncludedViews;
    }

    public void setProvideCookiesForIncludedViews(boolean provideCookiesForIncludedViews) {
        this.myProvideCookiesForIncludedViews = provideCookiesForIncludedViews;
    }

    @Nullable
    private RenderResult createRenderSession(@NotNull IImageFactory factory) {
        IAndroidTarget target;
        if (factory == null) {
            RenderTask.$$$reportNull$$$0(19);
        }
        if (this.myPsiFile == null) {
            throw new IllegalStateException("createRenderSession shouldn't be called on RenderTask without PsiFile");
        }
        ResourceResolver resolver = ResourceResolver.copy((ResourceResolver)this.getResourceResolver());
        if (resolver == null) {
            return null;
        }
        ILayoutPullParser modelParser = LayoutPullParserFactory.create(this);
        if (modelParser == null) {
            return null;
        }
        if (modelParser instanceof LayoutPsiPullParser) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(this.myRenderService.getFacet());
            boolean useSrcCompat = androidModel != null && GradleUtil.dependsOn(androidModel, "com.android.support:appcompat-v7");
            ((LayoutPsiPullParser)modelParser).setUseSrcCompat(useSrcCompat);
        }
        this.myLayoutlibCallback.reset();
        ILayoutPullParser includingParser = this.getIncludingLayoutParser(resolver, modelParser);
        if (includingParser != null) {
            modelParser = includingParser;
        }
        int simulatedPlatform = (target = this.myConfiguration.getTarget()) instanceof CompatibilityRenderTarget ? target.getVersion().getApiLevel() : 0;
        Module module = this.myRenderService.getModule();
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        final SessionParams params = new SessionParams(modelParser, this.myRenderingMode, (Object)module, hardwareConfig, (RenderResources)resolver, (LayoutlibCallback)this.myLayoutlibCallback, this.myMinSdkVersion.getApiLevel(), this.myTargetSdkVersion.getApiLevel(), (LayoutLog)this.myLogger, simulatedPlatform);
        params.setAssetRepository((AssetRepository)this.myAssetRepository);
        params.setFlag(RenderParamsFlags.FLAG_KEY_ROOT_TAG, (Object)AndroidPsiUtils.getRootTagName((PsiFile)this.myPsiFile));
        params.setFlag(RenderParamsFlags.FLAG_KEY_RECYCLER_VIEW_SUPPORT, (Object)true);
        params.setFlag(RenderParamsFlags.FLAG_KEY_DISABLE_BITMAP_CACHING, (Object)true);
        params.setFlag(RenderParamsFlags.FLAG_DO_NOT_RENDER_ON_CREATE, (Object)true);
        params.setExtendedViewInfoMode(true);
        MergedManifest manifestInfo = MergedManifest.get(module);
        LayoutDirectionQualifier qualifier = this.myConfiguration.getFullConfig().getLayoutDirectionQualifier();
        if (qualifier != null && qualifier.getValue() == LayoutDirection.RTL && !this.getLayoutLib().isRtl(this.myLocale.toLocaleId())) {
            params.setLocale("ur");
        } else {
            params.setLocale(this.myLocale.toLocaleId());
        }
        try {
            params.setRtlSupport(manifestInfo.isRtlSupported());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Device device = this.myConfiguration.getDevice();
        if (!this.myShowDecorations || HardwareConfigHelper.isWear((Device)device)) {
            params.setForceNoDecor();
        } else {
            try {
                params.setAppLabel(manifestInfo.getApplicationLabel());
                params.setAppIcon(manifestInfo.getApplicationIcon());
                String activity = this.myConfiguration.getActivity();
                if (activity != null) {
                    params.setActivityName(activity);
                    MergedManifest.ActivityAttributes attributes = manifestInfo.getActivityAttributes(activity);
                    if (attributes != null) {
                        if (attributes.getLabel() != null) {
                            params.setAppLabel(attributes.getLabel());
                        }
                        if (attributes.getIcon() != null) {
                            params.setAppIcon(attributes.getIcon());
                        }
                    }
                }
            }
            catch (Exception activity) {
                // empty catch block
            }
        }
        if (this.myOverrideBgColor != null) {
            params.setOverrideBgColor(this.myOverrideBgColor.intValue());
        } else if (this.requiresTransparency()) {
            params.setOverrideBgColor(0);
        }
        params.setImageFactory(factory);
        if (this.myTimeout > 0L) {
            params.setTimeout(this.myTimeout);
        }
        try {
            this.myLayoutlibCallback.setLogger(this.myLogger);
            this.myLayoutlibCallback.setResourceResolver(resolver);
            RenderResult result = (RenderResult)ApplicationManager.getApplication().runReadAction((Computable)new Computable<RenderResult>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @NotNull
                public RenderResult compute() {
                    Object result;
                    RenderSecurityManager securityManager;
                    Module module = RenderTask.this.myRenderService.getModule();
                    RenderSecurityManager renderSecurityManager = securityManager = RenderTask.this.isSecurityManagerEnabled ? RenderSecurityManagerFactory.create(module, RenderTask.this.getPlatform()) : null;
                    if (securityManager != null) {
                        securityManager.setActive(true, RenderTask.this.myCredential);
                    }
                    int retries = 0;
                    RenderSession session = null;
                    while (retries < 10) {
                        if (session != null) {
                            session.dispose();
                        }
                        if ((result = (session = RenderTask.this.myLayoutLib.createSession(params)).getResult()).getStatus() != Result.Status.ERROR_TIMEOUT) {
                            if (result.isSuccess() || !"The main Looper has already been prepared.".equals(result.getErrorMessage())) break;
                            ++retries;
                            continue;
                        }
                        ++retries;
                    }
                    if (session.getResult().isSuccess()) {
                        long now = System.nanoTime();
                        session.setSystemBootTimeNanos(now);
                        session.setSystemTimeNanos(now);
                        session.setElapsedFrameTimeNanos(TimeUnit.MILLISECONDS.toNanos(500L));
                    }
                    result = RenderResult.create(RenderTask.this, session, (PsiFile)RenderTask.this.myPsiFile, RenderTask.this.myLogger, RenderTask.this.myImagePool.copyOf(session.getImage()));
                    RenderTask.this.myRenderSession = session;
                    Object object = result;
                    Object object2 = object;
                    if (object2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return object2;
                    finally {
                        if (securityManager != null) {
                            securityManager.dispose(RenderTask.this.myCredential);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderTask$2", "compute"));
                }
            });
            this.addDiagnostics(result.getRenderResult());
            return result;
        }
        catch (RuntimeException t) {
            this.myLogger.error(null, t.getLocalizedMessage(), t, null);
            throw t;
        }
    }

    @Nullable
    private ILayoutPullParser getIncludingLayoutParser(ResourceResolver resolver, ILayoutPullParser modelParser) {
        if (this.myPsiFile == null) {
            throw new IllegalStateException("getIncludingLayoutParser shouldn't be called on RenderTask without PsiFile");
        }
        if (this.myIncludedWithin == null) {
            String layout = IncludeReference.getIncludingLayout(this.myPsiFile);
            Module module = this.myRenderService.getModule();
            IncludeReference includeReference = this.myIncludedWithin = layout != null ? IncludeReference.get(module, this.myPsiFile, (RenderResources)resolver) : IncludeReference.NONE;
        }
        if (this.myIncludedWithin != IncludeReference.NONE) {
            assert (Comparing.equal((Object)this.myIncludedWithin.getToFile(), (Object)this.myPsiFile.getVirtualFile()));
            VirtualFile layoutVirtualFile = this.myIncludedWithin.getFromFile();
            try {
                String queryLayoutName = ResourceHelper.getResourceName((PsiFile)this.myPsiFile);
                this.myLayoutlibCallback.setLayoutParser(queryLayoutName, modelParser);
                ILayoutPullParser topParser = null;
                PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(this.myRenderService.getProject(), layoutVirtualFile);
                if (psiFile instanceof XmlFile) {
                    LayoutPsiPullParser parser = LayoutPsiPullParser.create((XmlFile)psiFile, this.myLogger);
                    parser.setProvideViewCookies(this.myProvideCookiesForIncludedViews);
                    topParser = parser;
                }
                if (topParser == null) {
                    topParser = LayoutFilePullParser.create(this.myLayoutlibCallback, this.myIncludedWithin.getFromPath());
                }
                return topParser;
            }
            catch (IOException e) {
                this.myLogger.error(null, String.format("Could not read layout file %1$s", this.myIncludedWithin.getFromPath()), e);
            }
            catch (XmlPullParserException e) {
                this.myLogger.error(null, String.format("XML parsing error: %1$s", e.getMessage()), e.getDetail() != null ? e.getDetail() : e);
            }
        }
        return null;
    }

    @Nullable
    public RenderResult inflate() {
        if (this.myPsiFile == null) {
            throw new IllegalStateException("inflate shouldn't be called on RenderTask without PsiFile");
        }
        try {
            return RenderService.runRenderAction(() -> this.createRenderSession((width, height) -> {
                if (this.myImageFactoryDelegate != null) {
                    return this.myImageFactoryDelegate.getImage(width, height);
                }
                return new BufferedImage(width, height, 2);
            }));
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            this.myLogger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message, this.myRenderService.getProject(), this.myLogger.getLinkManager(), e));
            return RenderResult.createSessionInitializationError(this, (PsiFile)this.myPsiFile, this.myLogger);
        }
    }

    @Nullable
    public RenderResult layout() {
        if (this.myRenderSession == null) {
            return null;
        }
        try {
            return RenderService.runRenderAction(() -> {
                this.myRenderSession.measure();
                return RenderResult.create(this, this.myRenderSession, (PsiFile)this.myPsiFile, this.myLogger, ImagePool.NULL_POOLED_IMAGE);
            });
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void reportException(@NotNull Throwable e) {
        if (e == null) {
            RenderTask.$$$reportNull$$$0(20);
        }
        this.myCrashReporter.submit(CrashReport.Builder.createForException(e).build());
    }

    private RenderResult renderInner() {
        if (this.myRenderSession == null) {
            Result result;
            RenderResult renderResult = this.inflate();
            Result result2 = result = renderResult != null ? renderResult.getRenderResult() : null;
            if (result == null || !result.isSuccess()) {
                if (result != null) {
                    if (result.getException() != null) {
                        this.reportException(result.getException());
                    }
                    this.myLogger.error(null, result.getErrorMessage(), result.getException(), null);
                }
                return renderResult;
            }
        }
        assert (this.myPsiFile != null);
        try {
            return RenderService.runRenderAction(() -> {
                this.myRenderSession.render();
                RenderResult result = RenderResult.create(this, this.myRenderSession, (PsiFile)this.myPsiFile, this.myLogger, this.myImagePool.copyOf(this.myRenderSession.getImage()));
                if (result.getRenderResult().getException() != null) {
                    this.reportException(result.getRenderResult().getException());
                }
                return result;
            });
        }
        catch (Exception e) {
            this.reportException(e);
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            this.myLogger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message, this.myRenderService.getProject(), this.myLogger.getLinkManager(), e));
            return RenderResult.createSessionInitializationError(this, (PsiFile)this.myPsiFile, this.myLogger);
        }
    }

    @Deprecated
    @Nullable
    public RenderResult render(@NotNull IImageFactory factory) {
        if (factory == null) {
            RenderTask.$$$reportNull$$$0(21);
        }
        this.myImageFactoryDelegate = factory;
        return this.renderInner();
    }

    @Nullable
    public RenderResult render() {
        return this.render(this);
    }

    @Nullable
    public RenderResult render(@NotNull Graphics2D g) {
        if (g == null) {
            RenderTask.$$$reportNull$$$0(22);
        }
        this.myFakeImageFactory.setGraphics(g);
        this.myImageFactoryDelegate = this.myFakeImageFactory;
        return this.renderInner();
    }

    private void addDiagnostics(@NotNull Result result) {
        ILayoutPullParser layoutEmbeddedParser;
        if (result == null) {
            RenderTask.$$$reportNull$$$0(23);
        }
        if (!this.myLogger.hasProblems() && !result.isSuccess()) {
            if (result.getException() != null || result.getErrorMessage() != null) {
                this.myLogger.error(null, result.getErrorMessage(), result.getException(), null);
            } else if (result.getStatus() == Result.Status.ERROR_TIMEOUT) {
                this.myLogger.error(null, "Rendering timed out.", null);
            } else {
                this.myLogger.error(null, "Unknown render problem: " + result.getStatus(), null);
            }
        } else if (this.myIncludedWithin != null && this.myIncludedWithin != IncludeReference.NONE && (layoutEmbeddedParser = this.myLayoutlibCallback.getLayoutEmbeddedParser()) != null) {
            this.myLogger.error(null, String.format("The surrounding layout (%1$s) did not actually include this layout. Remove tools:showIn=... from the root tag.", this.myIncludedWithin.getFromResourceUrl()), null);
        }
    }

    @Nullable
    public BufferedImage renderDrawable(ResourceValue drawableResourceValue) {
        if (drawableResourceValue == null) {
            return null;
        }
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        Module module = this.myRenderService.getModule();
        final DrawableParams params = new DrawableParams(drawableResourceValue, (Object)module, hardwareConfig, (RenderResources)this.getResourceResolver(), (LayoutlibCallback)this.myLayoutlibCallback, this.myMinSdkVersion.getApiLevel(), this.myTargetSdkVersion.getApiLevel(), (LayoutLog)this.myLogger);
        params.setForceNoDecor();
        params.setAssetRepository((AssetRepository)this.myAssetRepository);
        try {
            Object data;
            Result result = RenderService.runRenderAction(new Callable<Result>(){

                @Override
                public Result call() throws Exception {
                    return RenderTask.this.myLayoutLib.renderDrawable(params);
                }
            });
            if (result != null && result.isSuccess() && (data = result.getData()) instanceof BufferedImage) {
                return (BufferedImage)data;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public List<BufferedImage> renderDrawableAllStates(ResourceValue drawableResourceValue) {
        block9: {
            List<BufferedImage> list;
            Object data;
            boolean supportsMultipleStates;
            block10: {
                if (drawableResourceValue == null) {
                    List<BufferedImage> list2 = Collections.emptyList();
                    if (list2 == null) {
                        RenderTask.$$$reportNull$$$0(24);
                    }
                    return list2;
                }
                HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
                Module module = this.myRenderService.getModule();
                final DrawableParams params = new DrawableParams(drawableResourceValue, (Object)module, hardwareConfig, (RenderResources)this.getResourceResolver(), (LayoutlibCallback)this.myLayoutlibCallback, this.myMinSdkVersion.getApiLevel(), this.myTargetSdkVersion.getApiLevel(), (LayoutLog)this.myLogger);
                params.setForceNoDecor();
                params.setAssetRepository((AssetRepository)this.myAssetRepository);
                supportsMultipleStates = this.myLayoutLib.supports(15);
                if (supportsMultipleStates) {
                    params.setFlag(RenderParamsFlags.FLAG_KEY_RENDER_ALL_DRAWABLE_STATES, (Object)Boolean.TRUE);
                }
                Result result = RenderService.runRenderAction(new Callable<Result>(){

                    @Override
                    public Result call() throws Exception {
                        return RenderTask.this.myLayoutLib.renderDrawable(params);
                    }
                });
                if (result == null || !result.isSuccess()) break block9;
                data = result.getData();
                if (!supportsMultipleStates || !(data instanceof List)) break block10;
                List list3 = (List)data;
                if (list3 == null) {
                    RenderTask.$$$reportNull$$$0(25);
                }
                return list3;
            }
            try {
                if (supportsMultipleStates || !(data instanceof BufferedImage)) break block9;
                list = Collections.singletonList((BufferedImage)data);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (list == null) {
                RenderTask.$$$reportNull$$$0(26);
            }
            return list;
        }
        List<BufferedImage> list = Collections.emptyList();
        if (list == null) {
            RenderTask.$$$reportNull$$$0(27);
        }
        return list;
    }

    @NotNull
    public LayoutLibrary getLayoutLib() {
        LayoutLibrary layoutLibrary = this.myLayoutLib;
        if (layoutLibrary == null) {
            RenderTask.$$$reportNull$$$0(28);
        }
        return layoutLibrary;
    }

    @NotNull
    public LayoutlibCallbackImpl getLayoutlibCallback() {
        LayoutlibCallbackImpl layoutlibCallbackImpl = this.myLayoutlibCallback;
        if (layoutlibCallbackImpl == null) {
            RenderTask.$$$reportNull$$$0(29);
        }
        return layoutlibCallbackImpl;
    }

    @Nullable
    public XmlFile getPsiFile() {
        return this.myPsiFile;
    }

    public boolean supportsCapability(int capability) {
        return this.myLayoutLib.supports(capability);
    }

    public boolean isNonRectangular() {
        return this.getFolderType() == ResourceFolderType.DRAWABLE;
    }

    public boolean requiresTransparency() {
        return this.isNonRectangular();
    }

    public BufferedImage getImage(int width, int height) {
        BufferedImage cached;
        BufferedImage bufferedImage = cached = this.myCachedImageReference != null ? (BufferedImage)this.myCachedImageReference.get() : null;
        if (cached == null || cached.getWidth() != width || cached.getHeight() != height) {
            cached = new BufferedImage(width, height, 2);
            this.myCachedImageReference = new SoftReference((Object)cached);
        }
        return cached;
    }

    public void useDesignMode(final @Nullable PsiFile file) {
        if (file == null) {
            return;
        }
        String tagName = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            @Nullable
            public String compute() {
                XmlTag root;
                if (file instanceof XmlFile && (root = ((XmlFile)file).getRootTag()) != null && (root = LayoutPsiPullParser.getRootTag(root)) != null) {
                    return root.getName();
                }
                return null;
            }
        });
        if (tagName != null) {
            RenderPreviewMode currentMode = RenderPreviewMode.getCurrent();
            if (currentMode != RenderPreviewMode.NONE) {
                return;
            }
            if ("HorizontalScrollView".equals(tagName)) {
                this.setRenderingMode(SessionParams.RenderingMode.H_SCROLL);
                this.setDecorations(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Map<XmlTag, ViewInfo> measureChildren(XmlTag parent, AttributeFilter filter) {
        LayoutPsiPullParser modelParser = LayoutPsiPullParser.create(filter, parent, this.myLogger);
        HashMap map = Maps.newHashMap();
        RenderSession session = null;
        try {
            session = RenderService.runRenderAction(() -> this.measure(modelParser));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (session != null) {
            try {
                Result result = session.getResult();
                if (result != null && result.isSuccess()) {
                    assert (session.getRootViews().size() == 1);
                    ViewInfo root = (ViewInfo)session.getRootViews().get(0);
                    List children = root.getChildren();
                    for (ViewInfo info : children) {
                        XmlTag tag = RenderService.getXmlTag(info);
                        if (tag == null) continue;
                        map.put(tag, info);
                    }
                }
                HashMap hashMap = map;
                return hashMap;
            }
            finally {
                try {
                    RenderService.runRenderAction(() -> ((RenderSession)session).dispose());
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    @Nullable
    public ViewInfo measureChild(XmlTag tag, AttributeFilter filter) {
        Map<XmlTag, ViewInfo> map;
        XmlTag parent = tag.getParentTag();
        if (parent != null && (map = this.measureChildren(parent, filter)) != null) {
            for (Map.Entry<XmlTag, ViewInfo> entry : map.entrySet()) {
                if (entry.getKey() != tag) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    @Nullable
    private RenderSession measure(ILayoutPullParser parser) {
        ResourceResolver resolver = this.getResourceResolver();
        if (resolver == null) {
            return null;
        }
        this.myLayoutlibCallback.reset();
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        Module module = this.myRenderService.getModule();
        final SessionParams params = new SessionParams(parser, SessionParams.RenderingMode.NORMAL, (Object)module, hardwareConfig, (RenderResources)resolver, (LayoutlibCallback)this.myLayoutlibCallback, this.myMinSdkVersion.getApiLevel(), this.myTargetSdkVersion.getApiLevel(), (LayoutLog)this.myLogger);
        params.setLayoutOnly();
        params.setForceNoDecor();
        params.setExtendedViewInfoMode(true);
        params.setLocale(this.myLocale.toLocaleId());
        params.setAssetRepository((AssetRepository)this.myAssetRepository);
        params.setFlag(RenderParamsFlags.FLAG_KEY_RECYCLER_VIEW_SUPPORT, (Object)true);
        MergedManifest manifestInfo = MergedManifest.get(module);
        try {
            params.setRtlSupport(manifestInfo.isRtlSupported());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.myLayoutlibCallback.setLogger(this.myLogger);
            this.myLayoutlibCallback.setResourceResolver(resolver);
            return (RenderSession)ApplicationManager.getApplication().runReadAction((Computable)new Computable<RenderSession>(){

                @Nullable
                public RenderSession compute() {
                    int retries = 0;
                    while (retries < 10) {
                        RenderSession session = RenderTask.this.myLayoutLib.createSession(params);
                        Result result = session.getResult();
                        if (result.getStatus() != Result.Status.ERROR_TIMEOUT) {
                            if (!result.isSuccess() && "The main Looper has already been prepared.".equals(result.getErrorMessage())) {
                                ++retries;
                                session.dispose();
                                continue;
                            }
                            return session;
                        }
                        ++retries;
                    }
                    return null;
                }
            });
        }
        catch (RuntimeException t) {
            this.myLogger.error(null, t.getLocalizedMessage(), t, null);
            throw t;
        }
    }

    void setCrashReporter(@NotNull CrashReporter crashReporter) {
        if (crashReporter == null) {
            RenderTask.$$$reportNull$$$0(30);
        }
        this.myCrashReporter = crashReporter;
    }

    public void disableSecurityManager() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IllegalStateException("This method can only be called in unit test mode");
        }
        LOG.warn("Security manager was disabled");
        this.isSecurityManagerEnabled = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutLib";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credential";
                break;
            }
            case 6: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "crashReporter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/RenderTask";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderingMode";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/RenderTask";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getHardwareConfigHelper";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderingMode";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "setOverrideBgColor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "setNodesToExpand";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "setIncludedWithin";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedWithin";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "renderDrawableAllStates";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutLib";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutlibCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setPsiFile";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setFolderType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setRenderingMode";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createRenderSession";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "reportException";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addDiagnostics";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setCrashReporter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface AttributeFilter {
        @Nullable
        public String getAttribute(@NotNull XmlTag var1, @Nullable String var2, @NotNull String var3);
    }
}

