/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.repository.Revision;
import com.android.tools.idea.stats.Distribution;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ResourceUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DistributionService {
    private static final Logger LOG = Logger.getInstance(DistributionService.class);
    private static final long REFRESH_INTERVAL = TimeUnit.DAYS.toMillis(1L);
    private static final long RETRY_INTERVAL = TimeUnit.HOURS.toMillis(1L);
    private static final String STATS_URL = "https://dl.google.com/android/studio/metadata/distributions.json";
    private static final String STATS_FILENAME = "distributions.json";
    private static final String DOWNLOAD_FILENAME = "distributions_temp.json";
    private static final URL FALLBACK_URL = ResourceUtil.getResource(DistributionService.class, (String)"wizardData", (String)"distributions.json");
    private static final File CACHE_PATH = new File(PathManager.getSystemPath(), "stats");
    private static final String FILE_PATTERN = FileUtil.getNameWithoutExtension((String)"distributions.json") + "(_[0-9]+)?\\." + FileUtilRt.getExtension((String)"distributions.json");
    private final Object myLock;
    private List<Distribution> myDistributions;
    private final List<Runnable> mySuccesses;
    private final List<Runnable> myFailures;
    private volatile boolean myRunning;
    private long myAttemptTime;
    private long myRefreshTime;
    @NotNull
    private final FileDownloader myDownloader;
    @NotNull
    private final File myCachePath;
    @NotNull
    private final URL myFallback;
    private static DistributionService ourInstance;

    public static DistributionService getInstance() {
        if (ourInstance == null) {
            DownloadableFileDescription description = DownloadableFileService.getInstance().createFileDescription(STATS_URL, DOWNLOAD_FILENAME);
            FileDownloader downloader = DownloadableFileService.getInstance().createDownloader((List)ImmutableList.of((Object)description), "Distribution Stats");
            ourInstance = new DistributionService(downloader, CACHE_PATH, FALLBACK_URL);
        }
        return ourInstance;
    }

    @Nullable
    public List<Distribution> getDistributions() {
        return this.myDistributions;
    }

    public double getSupportedDistributionForApiLevel(int apiLevel) {
        if (apiLevel <= 0) {
            return 0.0;
        }
        this.refreshSynchronously();
        List<Distribution> distributions = this.getDistributions();
        if (distributions == null) {
            return -1.0;
        }
        double unsupportedSum = 0.0;
        for (Distribution d : distributions) {
            if (d.getApiLevel() >= apiLevel) break;
            unsupportedSum += d.getDistributionPercentage();
        }
        return 1.0 - unsupportedSum;
    }

    @Nullable
    public Distribution getDistributionForApiLevel(int apiLevel) {
        this.refreshSynchronously();
        List<Distribution> distributions = this.getDistributions();
        if (distributions == null) {
            return null;
        }
        for (Distribution d : distributions) {
            if (d.getApiLevel() != apiLevel) continue;
            return d;
        }
        return null;
    }

    public void refreshSynchronously() {
        final Semaphore completed = new Semaphore();
        completed.down();
        Runnable complete = new Runnable(){

            @Override
            public void run() {
                completed.up();
            }
        };
        this.refresh(complete, complete);
        completed.waitFor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(@Nullable Runnable success, @Nullable Runnable failure) {
        final long time = System.currentTimeMillis();
        Object object = this.myLock;
        synchronized (object) {
            if (success != null) {
                this.mySuccesses.add(success);
            }
            if (failure != null) {
                this.myFailures.add(failure);
            }
            if (this.myRunning && time < this.myAttemptTime + RETRY_INTERVAL) {
                return;
            }
            if (time < this.myRefreshTime + REFRESH_INTERVAL) {
                DistributionService.runContinuations(this.mySuccesses);
                return;
            }
            if (time < this.myAttemptTime + RETRY_INTERVAL) {
                DistributionService.runContinuations(this.myFailures);
                return;
            }
            this.myAttemptTime = time;
            this.myRunning = true;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, "Downloading Stats", false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                DistributionService.this.loadStatsSynchronously(time);
            }

            public boolean isHeadless() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/stats/DistributionService$2", "run"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStatsSynchronously(long time) {
        try {
            File downloaded = null;
            try {
                List result = this.myDownloader.download(this.myCachePath);
                if (!result.isEmpty()) {
                    downloaded = this.fixupFile((File)((Pair)result.get(0)).getFirst());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (downloaded == null) {
                downloaded = this.findLatestDownload();
            }
            if (downloaded != null) {
                try {
                    this.loadFromFile(downloaded.toURI().toURL());
                    this.myRefreshTime = time;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        finally {
            ArrayList<Runnable> continuations;
            Object object = this.myLock;
            synchronized (object) {
                if (this.myDistributions == null) {
                    this.loadFromFile(this.myFallback);
                    continuations = new ArrayList<Runnable>(this.myFailures);
                } else {
                    continuations = new ArrayList<Runnable>(this.mySuccesses);
                }
                this.mySuccesses.clear();
                this.myFailures.clear();
                this.myRunning = false;
            }
            DistributionService.runContinuations(continuations);
        }
    }

    private File findLatestDownload() {
        long latestModTime = 0L;
        File latestFile = null;
        File[] files = this.myCachePath.listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.getName().matches(FILE_PATTERN) || f.lastModified() <= latestModTime) continue;
                latestFile = f;
                latestModTime = f.lastModified();
            }
        }
        return latestFile;
    }

    private File fixupFile(File downloaded) {
        File target = new File(this.myCachePath, STATS_FILENAME).getAbsoluteFile();
        if (!FileUtil.filesEqual((File)downloaded.getAbsoluteFile(), (File)target)) {
            try {
                if (target.delete() && downloaded.renameTo(target)) {
                    downloaded = target;
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return downloaded;
    }

    private static void runContinuations(List<Runnable> continuations) {
        for (Runnable r : continuations) {
            r.run();
        }
    }

    DistributionService(@NotNull FileDownloader downloader, @NotNull File cachePath, @NotNull URL fallback) {
        if (downloader == null) {
            DistributionService.$$$reportNull$$$0(0);
        }
        if (cachePath == null) {
            DistributionService.$$$reportNull$$$0(1);
        }
        if (fallback == null) {
            DistributionService.$$$reportNull$$$0(2);
        }
        this.myLock = new Object();
        this.mySuccesses = Lists.newLinkedList();
        this.myFailures = Lists.newArrayList();
        this.myRunning = false;
        this.myDownloader = downloader;
        this.myCachePath = cachePath;
        this.myFallback = fallback;
    }

    private void loadFromFile(@NotNull URL url) {
        if (url == null) {
            DistributionService.$$$reportNull$$$0(3);
        }
        try {
            String jsonString = ResourceUtil.loadText((URL)url);
            List<Distribution> distributions = DistributionService.loadDistributionsFromJson(jsonString);
            this.myDistributions = distributions != null ? ImmutableList.copyOf(distributions) : null;
        }
        catch (IOException e) {
            LOG.error("Error while trying to load distributions file", (Throwable)e);
        }
    }

    @Nullable
    private static List<Distribution> loadDistributionsFromJson(String jsonString) {
        Type fullRevisionType = new TypeToken<Revision>(){}.getType();
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(fullRevisionType, (Object)new JsonDeserializer<Revision>(){

            public Revision deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return Revision.parseRevision((String)json.getAsString());
            }
        });
        Gson gson = gsonBuilder.create();
        Type listType = new TypeToken<ArrayList<Distribution>>(){}.getType();
        try {
            return (List)gson.fromJson(jsonString, listType);
        }
        catch (JsonParseException e) {
            LOG.error("Parse exception while reading distributions.json", (Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/stats/DistributionService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "loadFromFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

