/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlMarginPropertyAccumulator;
import com.android.tools.idea.uibuilder.property.NlPropertyAccumulator;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.ptable.PTableItem;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPropertiesGrouper {
    private static List<String> MOST_IMPORTANT_ATTRIBUTES = ImmutableList.of((Object)"id", (Object)"layout_width", (Object)"layout_height");

    public List<PTableItem> group(@NotNull List<NlPropertyItem> properties, @NotNull List<NlComponent> components) {
        if (properties == null) {
            NlPropertiesGrouper.$$$reportNull$$$0(0);
        }
        if (components == null) {
            NlPropertiesGrouper.$$$reportNull$$$0(1);
        }
        String className = NlPropertiesGrouper.getCommonTagName(components);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)properties.size());
        NlPropertyAccumulator themePropertiesAccumulator = new NlPropertyAccumulator("Theme", p -> p != null && (p.getParentStylables().contains("Theme") || p.getName().equalsIgnoreCase("theme")));
        NlMarginPropertyAccumulator paddingPropertiesAccumulator = new NlMarginPropertyAccumulator("Padding", "padding", "paddingLeft", "paddingRight", "paddingStart", "paddingEnd", "paddingTop", "paddingBottom");
        NlMarginPropertyAccumulator layoutViewPropertiesAccumulator = new NlMarginPropertyAccumulator("Layout_Margin", "layout_margin", "layout_marginLeft", "layout_marginRight", "layout_marginStart", "layout_marginEnd", "layout_marginTop", "layout_marginBottom");
        NlPropertyAccumulator.PropertyNamePrefixAccumulator constraintPropertiesAccumulator = new NlPropertyAccumulator.PropertyNamePrefixAccumulator("Constraints", "layout_constraint");
        ArrayList accumulators = Lists.newArrayList((Object[])new NlPropertyAccumulator[]{themePropertiesAccumulator, paddingPropertiesAccumulator, layoutViewPropertiesAccumulator, constraintPropertiesAccumulator});
        for (NlPropertyItem p2 : properties) {
            NlPropertyAccumulator accumulator;
            boolean added = false;
            Iterator iterator = accumulators.iterator();
            while (iterator.hasNext() && !(added = (accumulator = (NlPropertyAccumulator)iterator.next()).process(p2))) {
            }
            if (added) continue;
            result.add(p2);
        }
        int insertionPoint = NlPropertiesGrouper.findInsertionPoint(result);
        for (NlPropertyAccumulator accumulator : accumulators) {
            if (!accumulator.hasItems()) continue;
            result.add(insertionPoint, accumulator.getGroupNode());
        }
        return result;
    }

    @Nullable
    public static String getCommonTagName(@NotNull List<NlComponent> components) {
        if (components == null) {
            NlPropertiesGrouper.$$$reportNull$$$0(2);
        }
        String commonTagName = null;
        for (NlComponent component : components) {
            String tagName = component.getTagName();
            if (commonTagName == null) {
                commonTagName = tagName;
                continue;
            }
            if (tagName.equals(commonTagName)) continue;
            return null;
        }
        return commonTagName;
    }

    private static int findInsertionPoint(@NotNull List<PTableItem> properties) {
        if (properties == null) {
            NlPropertiesGrouper.$$$reportNull$$$0(3);
        }
        for (int index = 0; index < MOST_IMPORTANT_ATTRIBUTES.size(); ++index) {
            if (properties.size() >= index + 1 && properties.get(index).getName().equals(MOST_IMPORTANT_ATTRIBUTES.get(index))) continue;
            return index;
        }
        return MOST_IMPORTANT_ATTRIBUTES.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/property/NlPropertiesGrouper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "group";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommonTagName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findInsertionPoint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

