/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.draw;

import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scene.draw.DrawRegion;
import com.android.tools.sherpa.drawing.ColorSet;
import icons.AndroidIcons;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class DrawAction
extends DrawRegion {
    public static final int CLEAR = 0;
    public static final int BASELINE = 1;
    public static final int CHAIN = 2;
    private boolean myIsOver;
    int myMode;
    protected Font mFont = new Font("Helvetica", 0, 14);

    @Override
    public int getLevel() {
        return 1010;
    }

    public DrawAction(String s) {
        String[] sp = s.split(",");
        int c = 0;
        c = super.parse(sp, c);
        this.myMode = Integer.parseInt(sp[c++]);
    }

    public DrawAction(int x, int y, int width, int height, int mode, boolean isOver) {
        super(x, y, width, height);
        this.myMode = mode;
        this.myIsOver = isOver;
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        Icon icon;
        int r = (int)((double)this.width * 0.3);
        ColorSet colorSet = sceneContext.getColorSet();
        g.setColor(colorSet.getComponentObligatoryBackground());
        g.fillRoundRect(this.x - 2, this.y - 2, this.width + 4, this.height + 4, r, r);
        if (this.myIsOver) {
            g.setColor(colorSet.getSelectedBackground());
            g.fillRoundRect(this.x, this.y, this.width, this.height, r, r);
            g.setColor(colorSet.getFrames());
            g.drawRoundRect(this.x, this.y, this.width, this.height, r, r);
        } else {
            g.setColor(colorSet.getFrames());
            g.fillRoundRect(this.x, this.y, this.width, this.height, r, r);
        }
        Color color = colorSet.getText();
        g.setColor(color);
        Icon icon2 = icon = colorSet.getStyle() == 0 ? AndroidIcons.SherpaIcons.DeleteConstraintB : AndroidIcons.SherpaIcons.DeleteConstraint;
        if (this.myMode == 1) {
            icon = colorSet.getStyle() == 0 ? AndroidIcons.SherpaIcons.BaselineBlue : AndroidIcons.SherpaIcons.BaselineColor;
        } else if (this.myMode == 2) {
            icon = colorSet.getStyle() == 0 ? AndroidIcons.SherpaIcons.ChainBlue : AndroidIcons.SherpaIcons.Chain;
        }
        g.setFont(this.mFont);
        FontMetrics fontMetrics = g.getFontMetrics();
        int iw = icon.getIconWidth();
        int ih = icon.getIconHeight();
        if (iw > this.width || ih > this.height) {
            double scale = Math.min((double)this.width / (double)iw, (double)this.height / (double)ih);
            Graphics2D g2 = (Graphics2D)g.create();
            double tx = (double)this.x + ((double)this.width - (double)iw * scale) / 2.0;
            double ty = (double)this.y + ((double)this.height - (double)ih * scale) / 2.0;
            g2.translate(tx, ty);
            g2.scale(scale, scale);
            icon.paintIcon(null, g2, 0, 0);
        } else {
            int tx = this.x + (this.width - iw) / 2;
            int ty = this.y + (this.height - ih) / 2;
            icon.paintIcon(null, g, tx, ty);
        }
    }

    @Override
    public String serialize() {
        return super.serialize() + "," + this.myMode;
    }

    public static void add(DisplayList list, SceneContext transform, float left, float top, float right, float bottom, int mode, boolean isOver) {
        int l = transform.getSwingX(left);
        int t = transform.getSwingY(top);
        int w = transform.getSwingDimension(right - left);
        int h = transform.getSwingDimension(bottom - top);
        list.add(new DrawAction(l, t, w, h, mode, isOver));
    }
}

