/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.swing.util;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class FloatFilter
extends DocumentFilter {
    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attrs) throws BadLocationException {
        String current = FloatFilter.getText(fb);
        fb.insertString(offset, FloatFilter.cleanString(current.substring(0, offset), text, current.substring(offset, current.length())), attrs);
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        String current = FloatFilter.getText(fb);
        fb.replace(offset, length, FloatFilter.cleanString(current.substring(0, offset), text, current.substring(offset + length, current.length())), attrs);
    }

    private static String cleanString(String before, String text, String after) {
        boolean allowSign = before.isEmpty() && (after.isEmpty() || after.charAt(0) != '+' && after.charAt(0) != '-');
        boolean allowDot = !before.contains(".") && !after.contains(".");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '+' || c == '-') {
                if (i != 0 || !allowSign) continue;
                allowSign = false;
                sb.append(c);
                continue;
            }
            if (c == '.') {
                if (!allowDot) continue;
                sb.append('.');
                allowDot = false;
                continue;
            }
            if (c < '0' || c > '9') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static String getText(DocumentFilter.FilterBypass fb) throws BadLocationException {
        return fb.getDocument().getText(0, fb.getDocument().getLength());
    }
}

