/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.converter;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.sdk.AndroidSdks;
import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ModuleSettings;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.android.converter.AndroidConversionUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

public class AndroidModuleConverter1
extends ConversionProcessor<ModuleSettings> {
    private static final String PLATFORM_NAME_ATTRIBUTE = "PLATFORM_NAME";

    public boolean isConversionNeeded(ModuleSettings moduleSettings) {
        Element confElement = AndroidConversionUtil.findAndroidFacetConfigurationElement(moduleSettings);
        return confElement != null && AndroidConversionUtil.getOptionValue(confElement, PLATFORM_NAME_ATTRIBUTE) != null;
    }

    public void process(ModuleSettings moduleSettings) throws CannotConvertException {
        AndroidPlatform androidPlatform;
        String platformName;
        Element confElement = AndroidConversionUtil.findAndroidFacetConfigurationElement(moduleSettings);
        assert (confElement != null);
        Element platformNameElement = AndroidConversionUtil.getOptionElement(confElement, PLATFORM_NAME_ATTRIBUTE);
        String string = platformName = platformNameElement != null ? platformNameElement.getAttributeValue("value") : null;
        if (platformName == null) {
            return;
        }
        AndroidModuleConverter1.removeOldDependencies(moduleSettings, platformName);
        confElement.removeContent((Content)platformNameElement);
        Library androidLibrary = LibraryTablesRegistrar.getInstance().getLibraryTable().getLibraryByName(platformName);
        if (androidLibrary != null && (androidPlatform = AndroidPlatform.parse(androidLibrary, null, null)) != null) {
            IAndroidTarget target = androidPlatform.getTarget();
            Sdk androidSdk = AndroidSdkUtils.findAppropriateAndroidPlatform(target, androidPlatform.getSdkData(), false);
            if (androidSdk == null && (androidSdk = AndroidSdks.getInstance().create(target, androidPlatform.getSdkData().getLocation(), false)) != null) {
                SdkModificator modificator = androidSdk.getSdkModificator();
                for (OrderRootType type : OrderRootType.getAllTypes()) {
                    for (VirtualFile root : androidLibrary.getFiles(type)) {
                        modificator.addRoot(root, type);
                    }
                }
                modificator.commitChanges();
            }
            if (androidSdk != null) {
                AndroidModuleConverter1.addNewDependency(moduleSettings, androidSdk.getName());
            }
        }
    }

    private static void addNewDependency(ModuleSettings moduleSettings, @NotNull String jdkName) {
        Element moduleManagerElement;
        if (jdkName == null) {
            AndroidModuleConverter1.$$$reportNull$$$0(0);
        }
        if ((moduleManagerElement = moduleSettings.getComponentElement("NewModuleRootManager")) != null) {
            Element newEntryElement = new Element("orderEntry");
            newEntryElement.setAttribute("type", "jdk");
            newEntryElement.setAttribute("jdkName", jdkName);
            newEntryElement.setAttribute("jdkType", "Android SDK");
            moduleManagerElement.addContent(newEntryElement);
        }
    }

    private static void removeOldDependencies(ModuleSettings moduleSettings, @NotNull String libName) {
        Element moduleManagerElement;
        if (libName == null) {
            AndroidModuleConverter1.$$$reportNull$$$0(1);
        }
        if ((moduleManagerElement = moduleSettings.getComponentElement("NewModuleRootManager")) != null) {
            for (Element entryElement : moduleManagerElement.getChildren("orderEntry")) {
                if (libName.equals(entryElement.getAttributeValue("name")) && "library".equals(entryElement.getAttributeValue("type")) && "application".equals(entryElement.getAttributeValue("level"))) {
                    moduleManagerElement.removeContent((Content)entryElement);
                }
                if (!"jdk".equals(entryElement.getAttributeValue("type")) && !"inheritedJdk".equals(entryElement.getAttributeValue("type"))) continue;
                moduleManagerElement.removeContent((Content)entryElement);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/converter/AndroidModuleConverter1";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addNewDependency";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeOldDependencies";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

