/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.sdklib.IAndroidTarget;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetEditorTab;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.util.AndroidNativeLibData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.AndroidImportableProperty;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;
import org.jetbrains.jps.util.JpsPathUtil;

public class AndroidFacetConfiguration
implements FacetConfiguration,
PersistentStateComponent<JpsAndroidModuleProperties> {
    private static final FacetEditorTab[] NO_EDITOR_TABS = new FacetEditorTab[0];
    private AndroidFacet myFacet = null;
    private JpsAndroidModuleProperties myProperties = new JpsAndroidModuleProperties();

    public void init(@NotNull Module module, @NotNull VirtualFile contentRoot) {
        if (module == null) {
            AndroidFacetConfiguration.$$$reportNull$$$0(0);
        }
        if (contentRoot == null) {
            AndroidFacetConfiguration.$$$reportNull$$$0(1);
        }
        this.init(module, contentRoot.getPath());
    }

    public void init(@NotNull Module module, @NotNull String baseDirectoryPath) {
        String s;
        if (module == null) {
            AndroidFacetConfiguration.$$$reportNull$$$0(2);
        }
        if (baseDirectoryPath == null) {
            AndroidFacetConfiguration.$$$reportNull$$$0(3);
        }
        if ((s = AndroidRootUtil.getPathRelativeToModuleDir(module, baseDirectoryPath)) == null || s.length() == 0) {
            return;
        }
        this.myProperties.GEN_FOLDER_RELATIVE_PATH_APT = '/' + s + this.myProperties.GEN_FOLDER_RELATIVE_PATH_APT;
        this.myProperties.GEN_FOLDER_RELATIVE_PATH_AIDL = '/' + s + this.myProperties.GEN_FOLDER_RELATIVE_PATH_AIDL;
        this.myProperties.MANIFEST_FILE_RELATIVE_PATH = '/' + s + this.myProperties.MANIFEST_FILE_RELATIVE_PATH;
        this.myProperties.RES_FOLDER_RELATIVE_PATH = '/' + s + this.myProperties.RES_FOLDER_RELATIVE_PATH;
        this.myProperties.ASSETS_FOLDER_RELATIVE_PATH = '/' + s + this.myProperties.ASSETS_FOLDER_RELATIVE_PATH;
        this.myProperties.LIBS_FOLDER_RELATIVE_PATH = '/' + s + this.myProperties.LIBS_FOLDER_RELATIVE_PATH;
        this.myProperties.PROGUARD_LOGS_FOLDER_RELATIVE_PATH = '/' + s + this.myProperties.PROGUARD_LOGS_FOLDER_RELATIVE_PATH;
        for (int i = 0; i < this.myProperties.RES_OVERLAY_FOLDERS.size(); ++i) {
            this.myProperties.RES_OVERLAY_FOLDERS.set(i, '/' + s + (String)this.myProperties.RES_OVERLAY_FOLDERS.get(i));
        }
    }

    @Nullable
    public AndroidPlatform getAndroidPlatform() {
        return AndroidPlatform.getInstance(this.myFacet.getModule());
    }

    @Nullable
    public AndroidSdkData getAndroidSdk() {
        AndroidPlatform platform = this.getAndroidPlatform();
        return platform != null ? platform.getSdkData() : null;
    }

    @Nullable
    public IAndroidTarget getAndroidTarget() {
        AndroidPlatform platform = this.getAndroidPlatform();
        return platform != null ? platform.getTarget() : null;
    }

    public void setFacet(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidFacetConfiguration.$$$reportNull$$$0(4);
        }
        this.myFacet = facet;
        facet.androidPlatformChanged();
    }

    public FacetEditorTab[] createEditorTabs(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager) {
        JpsAndroidModuleProperties state = this.getState();
        assert (state != null);
        if (state.ALLOW_USER_CONFIGURATION) {
            return new FacetEditorTab[]{new AndroidFacetEditorTab(editorContext, this)};
        }
        return NO_EDITOR_TABS;
    }

    public void readExternal(Element element) throws InvalidDataException {
    }

    public void writeExternal(Element element) throws WriteExternalException {
    }

    @NotNull
    public List<AndroidNativeLibData> getAdditionalNativeLibraries() {
        ArrayList<AndroidNativeLibData> libDatas = new ArrayList<AndroidNativeLibData>();
        for (JpsAndroidModuleProperties.AndroidNativeLibDataEntry nativeLib : this.myProperties.myNativeLibs) {
            if (nativeLib.myArchitecture == null || nativeLib.myUrl == null || nativeLib.myTargetFileName == null) continue;
            libDatas.add(new AndroidNativeLibData(nativeLib.myArchitecture, JpsPathUtil.urlToPath((String)nativeLib.myUrl), nativeLib.myTargetFileName));
        }
        ArrayList<AndroidNativeLibData> arrayList = libDatas;
        if (arrayList == null) {
            AndroidFacetConfiguration.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public void setAdditionalNativeLibraries(@NotNull List<AndroidNativeLibData> additionalNativeLibraries) {
        if (additionalNativeLibraries == null) {
            AndroidFacetConfiguration.$$$reportNull$$$0(6);
        }
        this.myProperties.myNativeLibs = new ArrayList(additionalNativeLibraries.size());
        for (AndroidNativeLibData lib : additionalNativeLibraries) {
            JpsAndroidModuleProperties.AndroidNativeLibDataEntry data = new JpsAndroidModuleProperties.AndroidNativeLibDataEntry();
            data.myArchitecture = lib.getArchitecture();
            data.myUrl = VfsUtilCore.pathToUrl((String)lib.getPath());
            data.myTargetFileName = lib.getTargetFileName();
            this.myProperties.myNativeLibs.add(data);
        }
    }

    public boolean isImportedProperty(@NotNull AndroidImportableProperty property) {
        if (property == null) {
            AndroidFacetConfiguration.$$$reportNull$$$0(7);
        }
        return !this.myProperties.myNotImportedProperties.contains(property);
    }

    public boolean isIncludeAssetsFromLibraries() {
        return this.myProperties.myIncludeAssetsFromLibraries;
    }

    public void setIncludeAssetsFromLibraries(boolean includeAssetsFromLibraries) {
        this.myProperties.myIncludeAssetsFromLibraries = includeAssetsFromLibraries;
    }

    @Nullable
    public JpsAndroidModuleProperties getState() {
        return this.myProperties;
    }

    public void loadState(JpsAndroidModuleProperties properties) {
        this.myProperties = properties;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirectoryPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/facet/AndroidFacetConfiguration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalNativeLibraries";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/facet/AndroidFacetConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalNativeLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setFacet";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalNativeLibraries";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isImportedProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

