/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.artifact.ProGuardConfigFilesPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.maven.AndroidMavenProvider;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.AndroidImportableProperty;

public class AndroidFacetEditorTab
extends FacetEditorTab {
    private final AndroidFacetConfiguration myConfiguration;
    private final FacetEditorContext myContext;
    private JPanel myContentPanel;
    private TextFieldWithBrowseButton myRGenPathField;
    private TextFieldWithBrowseButton myAidlGenPathField;
    private JButton myResetPathsButton;
    private TextFieldWithBrowseButton myResFolderField;
    private TextFieldWithBrowseButton myAssetsFolderField;
    private TextFieldWithBrowseButton myNativeLibsFolder;
    private TextFieldWithBrowseButton myManifestFileField;
    private JRadioButton myUseAptResDirectoryFromPathRadio;
    private JRadioButton myUseCustomSourceDirectoryRadio;
    private TextFieldWithBrowseButton myCustomAptSourceDirField;
    private JCheckBox myIsLibraryProjectCheckbox;
    private JPanel myAaptCompilerPanel;
    private ComboboxWithBrowseButton myApkPathCombo;
    private JLabel myApkPathLabel;
    private JRadioButton myRunProcessResourcesRadio;
    private JRadioButton myCompileResourcesByIdeRadio;
    private JLabel myManifestFileLabel;
    private JLabel myResFolderLabel;
    private JLabel myAssetsFolderLabel;
    private JLabel myNativeLibsFolderLabel;
    private JLabel myAidlGenPathLabel;
    private JLabel myRGenPathLabel;
    private TextFieldWithBrowseButton myCustomDebugKeystoreField;
    private JBLabel myCustomKeystoreLabel;
    private JCheckBox myIncludeTestCodeAndCheckBox;
    private JBCheckBox myRunProguardCheckBox;
    private JBCheckBox myIncludeAssetsFromLibraries;
    private JBCheckBox myUseCustomManifestPackage;
    private JTextField myCustomManifestPackageField;
    private ComboBox myUpdateProjectPropertiesCombo;
    private CheckBoxList<AndroidImportableProperty> myImportedOptionsList;
    private JBTabbedPane myTabbedPane;
    private JBCheckBox myEnableManifestMerging;
    private JBCheckBox myPreDexEnabledCheckBox;
    private ProGuardConfigFilesPanel myProGuardConfigFilesPanel;
    private JBCheckBox myEnableSourcesAutogenerationCheckBox;
    private JPanel myAptAutogenerationOptionsPanel;
    private JPanel myAidlAutogenerationOptionsPanel;
    private RawCommandLineEditor myAdditionalPackagingCommandLineParametersField;
    private TextFieldWithBrowseButton myProguardLogsDirectoryField;
    private JBLabel myProGuardLogsDirectoryLabel;
    private JBCheckBox myEnableMultiDexCheckBox;
    private JBTextField myMainDexList;
    private JCheckBox myMinimalMainDexCheckBox;
    private static final String MAVEN_TAB_TITLE = "Maven";
    private final Component myMavenTabComponent;

    public AndroidFacetEditorTab(FacetEditorContext context, AndroidFacetConfiguration androidFacetConfiguration) {
        this.$$$setupUI$$$();
        Project project = context.getProject();
        this.myConfiguration = androidFacetConfiguration;
        this.myContext = context;
        this.myManifestFileLabel.setLabelFor((Component)this.myManifestFileField);
        this.myResFolderLabel.setLabelFor((Component)this.myResFolderField);
        this.myAssetsFolderLabel.setLabelFor((Component)this.myAssetsFolderField);
        this.myNativeLibsFolderLabel.setLabelFor((Component)this.myNativeLibsFolder);
        this.myAidlGenPathLabel.setLabelFor((Component)this.myAidlGenPathField);
        this.myRGenPathLabel.setLabelFor((Component)this.myRGenPathField);
        this.myCustomKeystoreLabel.setLabelFor((Component)this.myCustomDebugKeystoreField);
        AndroidFacet facet = (AndroidFacet)this.myContext.getFacet();
        this.myRGenPathField.getButton().addActionListener((ActionListener)new MyGenSourceFieldListener(this.myRGenPathField, AndroidRootUtil.getAptGenSourceRootPath(facet)));
        this.myAidlGenPathField.getButton().addActionListener((ActionListener)new MyGenSourceFieldListener(this.myAidlGenPathField, AndroidRootUtil.getAidlGenSourceRootPath(facet)));
        Module module = this.myContext.getModule();
        this.myManifestFileField.getButton().addActionListener((ActionListener)new MyFolderFieldListener(this.myManifestFileField, AndroidRootUtil.getManifestFile(facet), true, new MyManifestFilter()));
        this.myResFolderField.getButton().addActionListener((ActionListener)new MyFolderFieldListener(this.myResFolderField, AndroidRootUtil.getResourceDir(facet), false, null));
        this.myAssetsFolderField.getButton().addActionListener((ActionListener)new MyFolderFieldListener(this.myAssetsFolderField, AndroidRootUtil.getAssetsDir(facet), false, null));
        this.myNativeLibsFolder.getButton().addActionListener((ActionListener)new MyFolderFieldListener(this.myNativeLibsFolder, AndroidRootUtil.getLibsDir(facet), false, null));
        this.myCustomAptSourceDirField.getButton().addActionListener((ActionListener)new MyFolderFieldListener(this.myCustomAptSourceDirField, AndroidFacetEditorTab.getCustomResourceDirForApt(facet), false, null));
        this.myRunProguardCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidFacetEditorTab.this.myProGuardConfigFilesPanel.setEnabled(AndroidFacetEditorTab.this.myRunProguardCheckBox.isSelected());
            }
        });
        this.myCustomDebugKeystoreField.getButton().addActionListener((ActionListener)new MyFolderFieldListener(this.myCustomDebugKeystoreField, null, true, null));
        this.myResetPathsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidMavenProvider mavenProvider;
                AndroidFacetConfiguration configuration = new AndroidFacetConfiguration();
                configuration.setFacet((AndroidFacet)AndroidFacetEditorTab.this.myContext.getFacet());
                Module module = AndroidFacetEditorTab.this.myContext.getModule();
                VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
                if (contentRoots.length == 1) {
                    configuration.init(module, contentRoots[0]);
                }
                if (AndroidMavenUtil.isMavenizedModule(module) && (mavenProvider = AndroidMavenUtil.getMavenProvider()) != null) {
                    mavenProvider.setPathsToDefault(module, configuration);
                }
                AndroidFacetEditorTab.this.resetOptions(configuration);
            }
        });
        this.myEnableSourcesAutogenerationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidFacetEditorTab.this.updateAutogenerationPanels();
            }
        });
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidFacetEditorTab.this.myCustomAptSourceDirField.setEnabled(AndroidFacetEditorTab.this.myUseCustomSourceDirectoryRadio.isSelected());
            }
        };
        this.myUseCustomSourceDirectoryRadio.addActionListener(listener);
        this.myUseAptResDirectoryFromPathRadio.addActionListener(listener);
        this.myIsLibraryProjectCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidFacetEditorTab.this.updateLibAndAppSpecificFields();
            }
        });
        listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidFacetEditorTab.this.updateAptPanel();
            }
        };
        this.myRunProcessResourcesRadio.addActionListener(listener);
        this.myCompileResourcesByIdeRadio.addActionListener(listener);
        this.myApkPathLabel.setLabelFor((Component)this.myApkPathCombo);
        JComboBox apkPathComboBoxComponent = this.myApkPathCombo.getComboBox();
        apkPathComboBoxComponent.setEditable(true);
        apkPathComboBoxComponent.setModel(new DefaultComboBoxModel<String>(AndroidFacetEditorTab.getDefaultApks(module)));
        apkPathComboBoxComponent.setMinimumSize(new Dimension(JBUI.scale((int)10), apkPathComboBoxComponent.getMinimumSize().height));
        apkPathComboBoxComponent.setPreferredSize(new Dimension(JBUI.scale((int)10), apkPathComboBoxComponent.getPreferredSize().height));
        this.myApkPathCombo.addBrowseFolderListener(project, new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                if (!super.isFileVisible(file, showHiddenFiles)) {
                    return false;
                }
                return file.isDirectory() || "apk".equals(file.getExtension());
            }
        });
        this.myUseCustomManifestPackage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidFacetEditorTab.this.myCustomManifestPackageField.setEnabled(AndroidFacetEditorTab.this.myUseCustomManifestPackage.isSelected());
            }
        });
        this.myUpdateProjectPropertiesCombo.setModel(new DefaultComboBoxModel<Object>(new Object[]{"", Boolean.TRUE.toString(), Boolean.FALSE.toString()}));
        this.myUpdateProjectPropertiesCombo.setRenderer((ListCellRenderer)new ListCellRendererWrapper<String>(){

            public void customize(JList list, String value, int index, boolean selected, boolean hasFocus) {
                if (value != null && value.isEmpty()) {
                    this.setText("Ask");
                } else if (Boolean.parseBoolean(value)) {
                    this.setText("Yes");
                } else {
                    this.setText("No");
                }
            }
        });
        this.buildImportedOptionsList();
        int mavenTabIndex = this.myTabbedPane.indexOfTab(MAVEN_TAB_TITLE);
        assert (mavenTabIndex >= 0);
        this.myMavenTabComponent = this.myTabbedPane.getComponentAt(mavenTabIndex);
        this.myProguardLogsDirectoryField.getButton().addActionListener((ActionListener)new MyFolderFieldListener(this.myProguardLogsDirectoryField, null, false, null));
    }

    @Nullable
    public static VirtualFile getCustomResourceDirForApt(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidFacetEditorTab.$$$reportNull$$$0(0);
        }
        return AndroidRootUtil.getFileByRelativeModulePath(facet.getModule(), facet.getProperties().CUSTOM_APK_RESOURCE_FOLDER, false);
    }

    private void updateLibAndAppSpecificFields() {
        boolean lib = this.myIsLibraryProjectCheckbox.isSelected();
        this.myAssetsFolderField.setEnabled(!lib);
        this.myEnableManifestMerging.setEnabled(!lib);
        this.myIncludeAssetsFromLibraries.setEnabled(!lib);
        this.myUseCustomManifestPackage.setEnabled(!lib);
        this.myCustomManifestPackageField.setEnabled(!lib && this.myUseCustomManifestPackage.isSelected());
        this.myAdditionalPackagingCommandLineParametersField.setEnabled(!lib);
        this.myRunProguardCheckBox.setEnabled(!lib);
        this.myProGuardConfigFilesPanel.setEnabled(!lib && this.myRunProguardCheckBox.isSelected());
        this.myApkPathLabel.setEnabled(!lib);
        this.myApkPathCombo.setEnabled(!lib);
        this.myCustomKeystoreLabel.setEnabled(!lib);
        this.myCustomDebugKeystoreField.setEnabled(!lib);
        this.myPreDexEnabledCheckBox.setEnabled(!lib);
        this.myProGuardLogsDirectoryLabel.setEnabled(!lib);
        this.myProguardLogsDirectoryField.setEnabled(!lib);
    }

    private void updateAutogenerationPanels() {
        UIUtil.setEnabled((Component)this.myAidlAutogenerationOptionsPanel, (boolean)this.myEnableSourcesAutogenerationCheckBox.isSelected(), (boolean)true);
        this.updateAptPanel();
    }

    private void buildImportedOptionsList() {
        this.myImportedOptionsList.setItems(Arrays.asList(AndroidImportableProperty.values()), (Function)new Function<AndroidImportableProperty, String>(){

            public String fun(AndroidImportableProperty property) {
                return property.getDisplayName();
            }
        });
    }

    private void updateAptPanel() {
        if (!this.myEnableSourcesAutogenerationCheckBox.isSelected()) {
            UIUtil.setEnabled((Component)this.myAptAutogenerationOptionsPanel, (boolean)false, (boolean)true);
        } else {
            UIUtil.setEnabled((Component)this.myAptAutogenerationOptionsPanel, (boolean)true, (boolean)true);
            boolean enabled = !this.myRunProcessResourcesRadio.isVisible() || !this.myRunProcessResourcesRadio.isSelected();
            UIUtil.setEnabled((Component)this.myAaptCompilerPanel, (boolean)enabled, (boolean)true);
        }
    }

    private static String[] getDefaultApks(@NotNull Module module) {
        String buildDirectory;
        AndroidMavenProvider mavenProvider;
        if (module == null) {
            AndroidFacetEditorTab.$$$reportNull$$$0(1);
        }
        ArrayList<String> result = new ArrayList<String>();
        String path = AndroidCompileUtil.getOutputPackage(module);
        if (path != null) {
            result.add(path);
        }
        if ((mavenProvider = AndroidMavenUtil.getMavenProvider()) != null && mavenProvider.isMavenizedModule(module) && (buildDirectory = mavenProvider.getBuildDirectory(module)) != null) {
            result.add(FileUtil.toSystemDependentName((String)(buildDirectory + '/' + AndroidCompileUtil.getApkName(module))));
        }
        return ArrayUtil.toStringArray(result);
    }

    @Nls
    public String getDisplayName() {
        return "Android SDK Settings";
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.myContentPanel;
        if (jPanel == null) {
            AndroidFacetEditorTab.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public boolean isModified() {
        if (this.myIsLibraryProjectCheckbox.isSelected() != (this.myConfiguration.getState().PROJECT_TYPE == 1)) {
            return true;
        }
        if (this.checkRelativePath(this.myConfiguration.getState().GEN_FOLDER_RELATIVE_PATH_APT, this.myRGenPathField.getText())) {
            return true;
        }
        if (this.checkRelativePath(this.myConfiguration.getState().GEN_FOLDER_RELATIVE_PATH_AIDL, this.myAidlGenPathField.getText())) {
            return true;
        }
        if (this.checkRelativePath(this.myConfiguration.getState().MANIFEST_FILE_RELATIVE_PATH, this.myManifestFileField.getText())) {
            return true;
        }
        if (this.checkRelativePath(this.myConfiguration.getState().RES_FOLDER_RELATIVE_PATH, this.myResFolderField.getText())) {
            return true;
        }
        if (this.checkRelativePath(this.myConfiguration.getState().ASSETS_FOLDER_RELATIVE_PATH, this.myAssetsFolderField.getText())) {
            return true;
        }
        if (this.checkRelativePath(this.myConfiguration.getState().LIBS_FOLDER_RELATIVE_PATH, this.myNativeLibsFolder.getText())) {
            return true;
        }
        if (this.checkRelativePath(this.myConfiguration.getState().APK_PATH, (String)this.myApkPathCombo.getComboBox().getEditor().getItem())) {
            return true;
        }
        if (this.myUseCustomSourceDirectoryRadio.isSelected() != this.myConfiguration.getState().USE_CUSTOM_APK_RESOURCE_FOLDER) {
            return true;
        }
        if (this.checkRelativePath(this.myConfiguration.getState().CUSTOM_APK_RESOURCE_FOLDER, this.myCustomAptSourceDirField.getText())) {
            return true;
        }
        if (this.myRunProcessResourcesRadio.isSelected() != this.myConfiguration.getState().RUN_PROCESS_RESOURCES_MAVEN_TASK) {
            return true;
        }
        if (!this.myConfiguration.getState().CUSTOM_DEBUG_KEYSTORE_PATH.equals(this.getSelectedCustomKeystorePath())) {
            return true;
        }
        if (this.myConfiguration.getState().ENABLE_MANIFEST_MERGING != this.myEnableManifestMerging.isSelected()) {
            return true;
        }
        if (this.myConfiguration.getState().ENABLE_PRE_DEXING != this.myPreDexEnabledCheckBox.isSelected()) {
            return true;
        }
        if (this.myConfiguration.getState().PACK_TEST_CODE != this.myIncludeTestCodeAndCheckBox.isSelected()) {
            return true;
        }
        if (this.myConfiguration.getState().ENABLE_SOURCES_AUTOGENERATION != this.myEnableSourcesAutogenerationCheckBox.isSelected()) {
            return true;
        }
        if (this.myConfiguration.isIncludeAssetsFromLibraries() != this.myIncludeAssetsFromLibraries.isSelected()) {
            return true;
        }
        if (this.myConfiguration.getState().RUN_PROGUARD != this.myRunProguardCheckBox.isSelected()) {
            return true;
        }
        if (!this.myProGuardConfigFilesPanel.getUrls().equals(this.myConfiguration.getState().myProGuardCfgFiles)) {
            return true;
        }
        if (this.myConfiguration.getState().ENABLE_MULTI_DEX != this.myEnableMultiDexCheckBox.isSelected()) {
            return true;
        }
        if (this.myConfiguration.getState().MINIMAL_MAIN_DEX != this.myMinimalMainDexCheckBox.isSelected()) {
            return true;
        }
        if (!this.myMainDexList.getText().trim().equals(this.myConfiguration.getState().MAIN_DEX_LIST)) {
            return true;
        }
        if (this.myConfiguration.getState().USE_CUSTOM_MANIFEST_PACKAGE != this.myUseCustomManifestPackage.isSelected()) {
            return true;
        }
        if (!this.myCustomManifestPackageField.getText().trim().equals(this.myConfiguration.getState().CUSTOM_MANIFEST_PACKAGE)) {
            return true;
        }
        if (!this.myAdditionalPackagingCommandLineParametersField.getText().trim().equals(this.myConfiguration.getState().ADDITIONAL_PACKAGING_COMMAND_LINE_PARAMETERS)) {
            return true;
        }
        if (!this.myUpdateProjectPropertiesCombo.getSelectedItem().equals(this.myConfiguration.getState().UPDATE_PROPERTY_FILES)) {
            return true;
        }
        if (this.checkRelativePath(this.myConfiguration.getState().PROGUARD_LOGS_FOLDER_RELATIVE_PATH, this.myProguardLogsDirectoryField.getText())) {
            return true;
        }
        if (AndroidMavenUtil.isMavenizedModule(this.myContext.getModule())) {
            EnumSet<AndroidImportableProperty> newNotImportedProperties = EnumSet.noneOf(AndroidImportableProperty.class);
            for (int i = 0; i < this.myImportedOptionsList.getItemsCount(); ++i) {
                AndroidImportableProperty property = (AndroidImportableProperty)this.myImportedOptionsList.getItemAt(i);
                if (this.myImportedOptionsList.isItemSelected(i)) continue;
                newNotImportedProperties.add(property);
            }
            if (!this.myConfiguration.getState().myNotImportedProperties.equals(newNotImportedProperties)) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    private String getSelectedCustomKeystorePath() {
        String path = this.myCustomDebugKeystoreField.getText().trim();
        String string = path.length() > 0 ? VfsUtil.pathToUrl((String)FileUtil.toSystemIndependentName((String)path)) : "";
        if (string == null) {
            AndroidFacetEditorTab.$$$reportNull$$$0(3);
        }
        return string;
    }

    private boolean checkRelativePath(String relativePathFromConfig, String absPathFromTextField) {
        String pathFromTextField;
        String pathFromConfig = relativePathFromConfig;
        if (pathFromConfig != null && pathFromConfig.length() > 0) {
            pathFromConfig = this.toAbsolutePath(pathFromConfig);
        }
        return !FileUtil.pathsEqual((String)pathFromConfig, (String)(pathFromTextField = absPathFromTextField.trim()));
    }

    @Nullable
    private String toRelativePath(String absPath) {
        absPath = FileUtil.toSystemIndependentName((String)absPath);
        String moduleDirPath = AndroidRootUtil.getModuleDirPath(this.myContext.getModule());
        if (moduleDirPath != null) {
            moduleDirPath = FileUtil.toSystemIndependentName((String)moduleDirPath);
            return FileUtil.getRelativePath((String)moduleDirPath, (String)absPath, (char)'/');
        }
        return null;
    }

    public String getHelpTopic() {
        return "reference.settings.project.modules.android.facet";
    }

    public void apply() throws ConfigurationException {
        boolean useCustomAptSrc;
        if (!this.isModified()) {
            return;
        }
        String absGenPathR = this.myRGenPathField.getText().trim();
        String absGenPathAidl = this.myAidlGenPathField.getText().trim();
        boolean runApt = false;
        boolean runIdl = false;
        if (absGenPathR == null || absGenPathR.length() == 0 || absGenPathAidl == null || absGenPathAidl.length() == 0) {
            throw new ConfigurationException("Please specify source root for autogenerated files");
        }
        String relativeGenPathR = this.getAndCheckRelativePath(absGenPathR, false);
        String newAptDestDir = '/' + relativeGenPathR;
        if (!newAptDestDir.equals(this.myConfiguration.getState().GEN_FOLDER_RELATIVE_PATH_APT)) {
            runApt = true;
        }
        this.myConfiguration.getState().GEN_FOLDER_RELATIVE_PATH_APT = newAptDestDir;
        String relativeGenPathAidl = this.getAndCheckRelativePath(absGenPathAidl, false);
        String newIdlDestDir = '/' + relativeGenPathAidl;
        if (!newIdlDestDir.equals(this.myConfiguration.getState().GEN_FOLDER_RELATIVE_PATH_AIDL)) {
            runIdl = true;
        }
        this.myConfiguration.getState().GEN_FOLDER_RELATIVE_PATH_AIDL = newIdlDestDir;
        String absManifestPath = this.myManifestFileField.getText().trim();
        if (absManifestPath.length() == 0) {
            throw new ConfigurationException("Manifest file not specified");
        }
        String manifestRelPath = this.getAndCheckRelativePath(absManifestPath, true);
        if (!"AndroidManifest.xml".equals(AndroidUtils.getSimpleNameByRelativePath(manifestRelPath))) {
            throw new ConfigurationException("Manifest file must have name AndroidManifest.xml");
        }
        this.myConfiguration.getState().MANIFEST_FILE_RELATIVE_PATH = '/' + manifestRelPath;
        String absResPath = this.myResFolderField.getText().trim();
        if (absResPath.length() == 0) {
            throw new ConfigurationException("Resources folder not specified");
        }
        this.myConfiguration.getState().RES_FOLDER_RELATIVE_PATH = '/' + this.getAndCheckRelativePath(absResPath, false);
        String absAssetsPath = this.myAssetsFolderField.getText().trim();
        this.myConfiguration.getState().ASSETS_FOLDER_RELATIVE_PATH = absAssetsPath.length() > 0 ? '/' + this.getAndCheckRelativePath(absAssetsPath, false) : "";
        String absApkPath = (String)this.myApkPathCombo.getComboBox().getEditor().getItem();
        this.myConfiguration.getState().APK_PATH = absApkPath.length() == 0 ? "" : '/' + this.getAndCheckRelativePath(absApkPath, false);
        String absLibsPath = this.myNativeLibsFolder.getText().trim();
        this.myConfiguration.getState().LIBS_FOLDER_RELATIVE_PATH = absLibsPath.length() > 0 ? '/' + this.getAndCheckRelativePath(absLibsPath, false) : "";
        this.myConfiguration.getState().CUSTOM_DEBUG_KEYSTORE_PATH = this.getSelectedCustomKeystorePath();
        this.myConfiguration.getState().PROJECT_TYPE = this.myIsLibraryProjectCheckbox.isSelected() ? 1 : 0;
        this.myConfiguration.getState().RUN_PROCESS_RESOURCES_MAVEN_TASK = this.myRunProcessResourcesRadio.isSelected();
        this.myConfiguration.getState().ENABLE_MANIFEST_MERGING = this.myEnableManifestMerging.isSelected();
        this.myConfiguration.getState().ENABLE_PRE_DEXING = this.myPreDexEnabledCheckBox.isSelected();
        this.myConfiguration.getState().ENABLE_MULTI_DEX = this.myEnableMultiDexCheckBox.isSelected();
        this.myConfiguration.getState().MAIN_DEX_LIST = this.myMainDexList.getText().trim();
        this.myConfiguration.getState().MINIMAL_MAIN_DEX = this.myMinimalMainDexCheckBox.isSelected();
        this.myConfiguration.getState().PACK_TEST_CODE = this.myIncludeTestCodeAndCheckBox.isSelected();
        this.myConfiguration.getState().ENABLE_SOURCES_AUTOGENERATION = this.myEnableSourcesAutogenerationCheckBox.isSelected();
        this.myConfiguration.setIncludeAssetsFromLibraries(this.myIncludeAssetsFromLibraries.isSelected());
        if (AndroidMavenUtil.isMavenizedModule(this.myContext.getModule())) {
            Set notImportedProperties = this.myConfiguration.getState().myNotImportedProperties;
            notImportedProperties.clear();
            for (int i = 0; i < this.myImportedOptionsList.getItemsCount(); ++i) {
                AndroidImportableProperty property = (AndroidImportableProperty)this.myImportedOptionsList.getItemAt(i);
                if (this.myImportedOptionsList.isItemSelected(i)) continue;
                notImportedProperties.add(property);
            }
        }
        this.myConfiguration.getState().RUN_PROGUARD = this.myRunProguardCheckBox.isSelected();
        this.myConfiguration.getState().myProGuardCfgFiles = this.myProGuardConfigFilesPanel.getUrls();
        this.myConfiguration.getState().USE_CUSTOM_APK_RESOURCE_FOLDER = useCustomAptSrc = this.myUseCustomSourceDirectoryRadio.isSelected();
        this.myConfiguration.getState().USE_CUSTOM_MANIFEST_PACKAGE = this.myUseCustomManifestPackage.isSelected();
        this.myConfiguration.getState().CUSTOM_MANIFEST_PACKAGE = this.myCustomManifestPackageField.getText().trim();
        this.myConfiguration.getState().ADDITIONAL_PACKAGING_COMMAND_LINE_PARAMETERS = this.myAdditionalPackagingCommandLineParametersField.getText().trim();
        String absAptSourcePath = this.myCustomAptSourceDirField.getText().trim();
        if (useCustomAptSrc) {
            if (absAptSourcePath.length() == 0) {
                throw new ConfigurationException("Resources folder not specified");
            }
            this.myConfiguration.getState().CUSTOM_APK_RESOURCE_FOLDER = '/' + this.getAndCheckRelativePath(absAptSourcePath, false);
        } else {
            String relPath = this.toRelativePath(absAptSourcePath);
            this.myConfiguration.getState().CUSTOM_APK_RESOURCE_FOLDER = relPath != null ? '/' + relPath : "";
        }
        this.myConfiguration.getState().UPDATE_PROPERTY_FILES = (String)this.myUpdateProjectPropertiesCombo.getSelectedItem();
        String absProguardLogsPath = this.myProguardLogsDirectoryField.getText().trim();
        String string = this.myConfiguration.getState().PROGUARD_LOGS_FOLDER_RELATIVE_PATH = absProguardLogsPath.length() > 0 ? '/' + this.getAndCheckRelativePath(absProguardLogsPath, false) : "";
        if (runApt || runIdl) {
            Module module = this.myContext.getModule();
            if (runApt) {
                AndroidCompileUtil.generate(module, AndroidAutogeneratorMode.AAPT);
            }
            if (runIdl) {
                AndroidCompileUtil.generate(module, AndroidAutogeneratorMode.AIDL);
            }
        }
    }

    private String getAndCheckRelativePath(String absPath, boolean checkExists) throws ConfigurationException {
        if (absPath.indexOf(47) < 0 && absPath.indexOf(File.separatorChar) < 0) {
            throw new ConfigurationException(AndroidBundle.message("file.must.be.under.module.error", FileUtil.toSystemDependentName((String)absPath)));
        }
        String relativeGenPathR = this.toRelativePath(absPath);
        if (relativeGenPathR == null || relativeGenPathR.length() == 0) {
            throw new ConfigurationException(AndroidBundle.message("file.must.be.under.module.error", FileUtil.toSystemDependentName((String)absPath)));
        }
        if (checkExists && LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)absPath)) == null) {
            throw new ConfigurationException(AndroidBundle.message("android.file.not.exist.error", FileUtil.toSystemDependentName((String)absPath)));
        }
        return relativeGenPathR;
    }

    public void reset() {
        this.myIsLibraryProjectCheckbox.setSelected(this.myConfiguration.getState().PROJECT_TYPE == 1);
        this.resetOptions(this.myConfiguration);
    }

    private void resetOptions(AndroidFacetConfiguration configuration) {
        String aptGenPath = configuration.getState().GEN_FOLDER_RELATIVE_PATH_APT;
        String aptAbspath = aptGenPath.length() > 0 ? this.toAbsolutePath(aptGenPath) : "";
        this.myRGenPathField.setText(aptAbspath != null ? aptAbspath : "");
        String aidlGenPath = configuration.getState().GEN_FOLDER_RELATIVE_PATH_AIDL;
        String aidlAbsPath = aidlGenPath.length() > 0 ? this.toAbsolutePath(aidlGenPath) : "";
        this.myAidlGenPathField.setText(aidlAbsPath != null ? aidlAbsPath : "");
        String manifestPath = configuration.getState().MANIFEST_FILE_RELATIVE_PATH;
        String manifestAbsPath = manifestPath.length() > 0 ? this.toAbsolutePath(manifestPath) : "";
        this.myManifestFileField.setText(manifestAbsPath != null ? manifestAbsPath : "");
        String resPath = configuration.getState().RES_FOLDER_RELATIVE_PATH;
        String resAbsPath = resPath.length() > 0 ? this.toAbsolutePath(resPath) : "";
        this.myResFolderField.setText(resAbsPath != null ? resAbsPath : "");
        String assetsPath = configuration.getState().ASSETS_FOLDER_RELATIVE_PATH;
        String assetsAbsPath = assetsPath.length() > 0 ? this.toAbsolutePath(assetsPath) : "";
        this.myAssetsFolderField.setText(assetsAbsPath != null ? assetsAbsPath : "");
        String libsPath = configuration.getState().LIBS_FOLDER_RELATIVE_PATH;
        String libsAbsPath = libsPath.length() > 0 ? this.toAbsolutePath(libsPath) : "";
        this.myNativeLibsFolder.setText(libsAbsPath != null ? libsAbsPath : "");
        this.myCustomDebugKeystoreField.setText(FileUtil.toSystemDependentName((String)VfsUtil.urlToPath((String)configuration.getState().CUSTOM_DEBUG_KEYSTORE_PATH)));
        boolean runProguard = configuration.getState().RUN_PROGUARD;
        this.myRunProguardCheckBox.setSelected(runProguard);
        this.myProGuardConfigFilesPanel.setUrls(configuration.getState().myProGuardCfgFiles);
        this.myEnableMultiDexCheckBox.setSelected(configuration.getState().ENABLE_MULTI_DEX);
        this.myMainDexList.setText(configuration.getState().MAIN_DEX_LIST);
        this.myMinimalMainDexCheckBox.setSelected(configuration.getState().MINIMAL_MAIN_DEX);
        this.myUseCustomSourceDirectoryRadio.setSelected(configuration.getState().USE_CUSTOM_APK_RESOURCE_FOLDER);
        this.myUseAptResDirectoryFromPathRadio.setSelected(!configuration.getState().USE_CUSTOM_APK_RESOURCE_FOLDER);
        String aptSourcePath = configuration.getState().CUSTOM_APK_RESOURCE_FOLDER;
        String aptSourceAbsPath = aptSourcePath.length() > 0 ? this.toAbsolutePath(aptSourcePath) : "";
        this.myCustomAptSourceDirField.setText(aptSourceAbsPath != null ? aptSourceAbsPath : "");
        this.myCustomAptSourceDirField.setEnabled(configuration.getState().USE_CUSTOM_APK_RESOURCE_FOLDER);
        String apkPath = configuration.getState().APK_PATH;
        String apkAbsPath = apkPath.length() > 0 ? this.toAbsolutePath(apkPath) : "";
        this.myApkPathCombo.getComboBox().getEditor().setItem(apkAbsPath != null ? apkAbsPath : "");
        boolean mavenizedModule = AndroidMavenUtil.isMavenizedModule(this.myContext.getModule());
        this.myRunProcessResourcesRadio.setVisible(mavenizedModule);
        this.myRunProcessResourcesRadio.setSelected(this.myConfiguration.getState().RUN_PROCESS_RESOURCES_MAVEN_TASK);
        this.myCompileResourcesByIdeRadio.setVisible(mavenizedModule);
        this.myCompileResourcesByIdeRadio.setSelected(!this.myConfiguration.getState().RUN_PROCESS_RESOURCES_MAVEN_TASK);
        this.myEnableManifestMerging.setSelected(this.myConfiguration.getState().ENABLE_MANIFEST_MERGING);
        this.myPreDexEnabledCheckBox.setSelected(this.myConfiguration.getState().ENABLE_PRE_DEXING);
        this.myIncludeTestCodeAndCheckBox.setSelected(this.myConfiguration.getState().PACK_TEST_CODE);
        this.myIncludeAssetsFromLibraries.setSelected(this.myConfiguration.isIncludeAssetsFromLibraries());
        this.myUseCustomManifestPackage.setSelected(this.myConfiguration.getState().USE_CUSTOM_MANIFEST_PACKAGE);
        this.myCustomManifestPackageField.setEnabled(this.myConfiguration.getState().USE_CUSTOM_MANIFEST_PACKAGE);
        this.myCustomManifestPackageField.setText(this.myConfiguration.getState().CUSTOM_MANIFEST_PACKAGE);
        this.myAdditionalPackagingCommandLineParametersField.setText(this.myConfiguration.getState().ADDITIONAL_PACKAGING_COMMAND_LINE_PARAMETERS);
        String proguardLogsPath = configuration.getState().PROGUARD_LOGS_FOLDER_RELATIVE_PATH;
        String proguardLogsAbsPath = proguardLogsPath.length() > 0 ? this.toAbsolutePath(proguardLogsPath) : "";
        this.myProguardLogsDirectoryField.setText(proguardLogsAbsPath != null ? proguardLogsAbsPath : "");
        this.myUpdateProjectPropertiesCombo.setSelectedItem((Object)this.myConfiguration.getState().UPDATE_PROPERTY_FILES);
        this.myEnableSourcesAutogenerationCheckBox.setSelected(this.myConfiguration.getState().ENABLE_SOURCES_AUTOGENERATION);
        this.updateAutogenerationPanels();
        int mavenTabIndex = this.myTabbedPane.indexOfTab(MAVEN_TAB_TITLE);
        if (mavenTabIndex >= 0) {
            this.myTabbedPane.removeTabAt(mavenTabIndex);
        }
        if (mavenizedModule) {
            this.myTabbedPane.insertTab(MAVEN_TAB_TITLE, null, this.myMavenTabComponent, null, 2);
            for (int i = 0; i < this.myImportedOptionsList.getItemsCount(); ++i) {
                AndroidImportableProperty property = (AndroidImportableProperty)this.myImportedOptionsList.getItemAt(i);
                this.myImportedOptionsList.setItemSelected((Object)property, configuration.isImportedProperty(property));
            }
        }
        this.updateLibAndAppSpecificFields();
    }

    @Nullable
    private String toAbsolutePath(String genRelativePath) {
        if (genRelativePath == null) {
            return null;
        }
        if (genRelativePath.length() == 0) {
            return "";
        }
        String moduleDirPath = AndroidRootUtil.getModuleDirPath(this.myContext.getModule());
        if (moduleDirPath == null) {
            return null;
        }
        String path = PathUtil.getCanonicalPath((String)new File(moduleDirPath, genRelativePath).getPath());
        return path != null ? PathUtil.getLocalPath((String)path) : null;
    }

    private void createUIComponents() {
        this.myProGuardConfigFilesPanel = new ProGuardConfigFilesPanel(){

            @Override
            @Nullable
            protected AndroidFacet getFacet() {
                return (AndroidFacet)AndroidFacetEditorTab.this.myContext.getFacet();
            }
        };
    }

    private VirtualFile[] chooserDirsUnderModule(@Nullable VirtualFile initialFile, final boolean chooseFile, boolean chooseMultiple, final @Nullable Condition<VirtualFile> filter) {
        String p;
        if (initialFile == null) {
            initialFile = this.myContext.getModule().getModuleFile();
        }
        if (initialFile == null && (p = AndroidRootUtil.getModuleDirPath(this.myContext.getModule())) != null) {
            initialFile = LocalFileSystem.getInstance().findFileByPath(p);
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(chooseFile, !chooseFile, false, false, false, chooseMultiple){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                if (!super.isFileVisible(file, showHiddenFiles)) {
                    return false;
                }
                if (!file.isDirectory() && !chooseFile) {
                    return false;
                }
                return filter == null || filter.value((Object)file);
            }
        };
        return FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Component)this.myContentPanel, (Project)this.myContext.getProject(), (VirtualFile)initialFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/facet/AndroidFacetEditorTab";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/facet/AndroidFacetEditorTab";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedCustomKeystorePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomResourceDirForApt";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultApks";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JCheckBox jCheckBox;
        JBTextField jBTextField;
        JBCheckBox jBCheckBox;
        CheckBoxList checkBoxList;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JBLabel jBLabel2;
        JCheckBox jCheckBox2;
        RawCommandLineEditor rawCommandLineEditor;
        JBCheckBox jBCheckBox4;
        JTextField jTextField;
        JBCheckBox jBCheckBox5;
        JBCheckBox jBCheckBox6;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JBCheckBox jBCheckBox7;
        TextFieldWithBrowseButton textFieldWithBrowseButton4;
        JLabel jLabel2;
        JPanel jPanel;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        TextFieldWithBrowseButton textFieldWithBrowseButton5;
        JLabel jLabel3;
        JPanel jPanel2;
        JPanel jPanel3;
        TextFieldWithBrowseButton textFieldWithBrowseButton6;
        JLabel jLabel4;
        TextFieldWithBrowseButton textFieldWithBrowseButton7;
        JLabel jLabel5;
        TextFieldWithBrowseButton textFieldWithBrowseButton8;
        JLabel jLabel6;
        TextFieldWithBrowseButton textFieldWithBrowseButton9;
        JLabel jLabel7;
        JBTabbedPane jBTabbedPane;
        JCheckBox jCheckBox3;
        JButton jButton;
        JPanel jPanel4;
        this.createUIComponents();
        this.myContentPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myResetPathsButton = jButton = new JButton();
        jButton.setText("Reset paths to defaults");
        jPanel4.add((Component)jButton, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(3, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myIsLibraryProjectCheckbox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.facet.editor.is.library.checkbox"));
        jPanel4.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myTabbedPane = jBTabbedPane = new JBTabbedPane();
        jPanel4.add((Component)jBTabbedPane, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Structure", null, jPanel5, null);
        this.myManifestFileLabel = jLabel7 = new JLabel();
        jLabel7.setText("Manifest file:");
        jLabel7.setDisplayedMnemonic('M');
        jLabel7.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myManifestFileField = textFieldWithBrowseButton9 = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton9, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myResFolderLabel = jLabel6 = new JLabel();
        jLabel6.setText("Resources directory:");
        jLabel6.setDisplayedMnemonic('S');
        jLabel6.setDisplayedMnemonicIndex(2);
        jPanel5.add((Component)jLabel6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myResFolderField = textFieldWithBrowseButton8 = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton8, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myAssetsFolderLabel = jLabel5 = new JLabel();
        jLabel5.setText("Assets directory:");
        jLabel5.setDisplayedMnemonic('T');
        jLabel5.setDisplayedMnemonicIndex(4);
        jPanel5.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAssetsFolderField = textFieldWithBrowseButton7 = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton7, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myNativeLibsFolderLabel = jLabel4 = new JLabel();
        jLabel4.setText("Native libs directory:");
        jLabel4.setDisplayedMnemonic('L');
        jLabel4.setDisplayedMnemonicIndex(7);
        jPanel5.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNativeLibsFolder = textFieldWithBrowseButton6 = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton6, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 4, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Generated Sources", null, jPanel6, null);
        Spacer spacer4 = new Spacer();
        jPanel6.add((Component)spacer4, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAptAutogenerationOptionsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel6.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/AndroidBundle").getString("android.apt.settings.title"), (int)0, (int)0, null, null));
        this.myAaptCompilerPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRGenPathLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.dest.directory.title"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRGenPathField = textFieldWithBrowseButton5 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myCompileResourcesByIdeRadio = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.facet.settings.compile.resources.by.ide"));
        jPanel3.add((Component)jRadioButton4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRunProcessResourcesRadio = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/AndroidBundle").getString("copy.resources.from.artifacts.setting"));
        jPanel3.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAidlAutogenerationOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel6.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"AIDL files", (int)0, (int)0, null, null));
        this.myAidlGenPathLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.dest.directory.title"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAidlGenPathField = textFieldWithBrowseButton4 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton4, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myEnableSourcesAutogenerationCheckBox = jBCheckBox7 = new JBCheckBox();
        jBCheckBox7.setText("Generate sources automatically ");
        jBCheckBox7.setMnemonic('O');
        jBCheckBox7.setDisplayedMnemonicIndex(20);
        jPanel6.add((Component)jBCheckBox7, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 4, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Packaging", null, jPanel7, null);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel8.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/AndroidBundle").getString("android.apk.settings.title"), (int)0, (int)0, null, null));
        this.myUseAptResDirectoryFromPathRadio = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.generate.r.java.by.res.dir"));
        jPanel8.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myUseCustomSourceDirectoryRadio = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.use.custom.r.java.source.dir"));
        jPanel8.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCustomAptSourceDirField = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel8.add((Component)textFieldWithBrowseButton3, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myIncludeAssetsFromLibraries = jBCheckBox6 = new JBCheckBox();
        jBCheckBox6.setText("Include assets from dependencies into APK");
        jPanel8.add((Component)jBCheckBox6, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myUseCustomManifestPackage = jBCheckBox5 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox5, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.aapt.use.custom.package.name"));
        jPanel8.add((Component)jBCheckBox5, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCustomManifestPackageField = jTextField = new JTextField();
        jPanel8.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myEnableManifestMerging = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setText("Enable manifest merging");
        jPanel8.add((Component)jBCheckBox4, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Additional command line parameters:");
        jPanel8.add((Component)jBLabel3, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAdditionalPackagingCommandLineParametersField = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel8.add((Component)rawCommandLineEditor, new GridConstraints(5, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel7.add((Component)spacer5, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myIncludeTestCodeAndCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.facet.settings.pack.test.sources"));
        jPanel7.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myCustomKeystoreLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.facet.settings.custom.debug.keystore.label"));
        jPanel7.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCustomDebugKeystoreField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel7.add((Component)textFieldWithBrowseButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myApkPathLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.facet.settings.apk.path.label"));
        jPanel7.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myApkPathCombo = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        jPanel7.add((Component)comboboxWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myPreDexEnabledCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Pre-dex external jars and Android library dependencies");
        jPanel7.add((Component)jBCheckBox3, new GridConstraints(4, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 4, 0), -1, -1, false, false));
        jBTabbedPane.addTab("ProGuard", null, jPanel9, null);
        this.myRunProguardCheckBox = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.facet.settings.run.proguard"));
        jPanel9.add((Component)jBCheckBox2, new GridConstraints(1, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel9.add((Component)spacer6, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        ProGuardConfigFilesPanel proGuardConfigFilesPanel = this.myProGuardConfigFilesPanel;
        jPanel9.add((Component)proGuardConfigFilesPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myProGuardLogsDirectoryLabel = jBLabel = new JBLabel();
        jBLabel.setText("Proguard logs directory:");
        jPanel9.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProguardLogsDirectoryField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel9.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(MAVEN_TAB_TITLE, null, jPanel10, null);
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Import following options from pom.xml:");
        jPanel10.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myImportedOptionsList = checkBoxList = new CheckBoxList();
        jPanel10.add((Component)checkBoxList, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Multi-dex", null, jPanel11, null);
        this.myEnableMultiDexCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Enable multi-dex support");
        jPanel11.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel11.add((Component)spacer7, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myMainDexList = jBTextField = new JBTextField();
        jPanel11.add((Component)jBTextField, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Main dex list:");
        jPanel11.add((Component)jLabel8, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMinimalMainDexCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Minimal main dex");
        jPanel11.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Update \"project.properties\" file automatically:");
        jBLabel5.setDisplayedMnemonic('D');
        jBLabel5.setDisplayedMnemonicIndex(2);
        jPanel4.add((Component)jBLabel5, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myUpdateProjectPropertiesCombo = comboBox = new ComboBox();
        jPanel4.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 0, 0, 2, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel4.add((Component)spacer8, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        jBLabel3.setLabelFor((Component)rawCommandLineEditor);
        jLabel.setLabelFor((Component)comboboxWithBrowseButton);
        jBLabel.setLabelFor((Component)textFieldWithBrowseButton);
        jBLabel5.setLabelFor((Component)comboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MyManifestFilter
    implements Condition<VirtualFile> {
        private MyManifestFilter() {
        }

        public boolean value(VirtualFile file) {
            return file.isDirectory() || file.getName().equals("AndroidManifest.xml");
        }
    }

    private class MyFolderFieldListener
    implements ActionListener {
        private final TextFieldWithBrowseButton myTextField;
        private final VirtualFile myDefaultDir;
        private final boolean myChooseFile;
        private final Condition<VirtualFile> myFilter;

        public MyFolderFieldListener(TextFieldWithBrowseButton textField, VirtualFile defaultDir, @Nullable boolean chooseFile, Condition<VirtualFile> filter) {
            this.myTextField = textField;
            this.myDefaultDir = defaultDir;
            this.myChooseFile = chooseFile;
            this.myFilter = filter;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VirtualFile[] files;
            VirtualFile initialFile = null;
            String path = this.myTextField.getText().trim();
            if (path.length() == 0) {
                VirtualFile dir = this.myDefaultDir;
                String string = path = dir != null ? dir.getPath() : null;
            }
            if (path != null) {
                initialFile = LocalFileSystem.getInstance().findFileByPath(path);
            }
            if ((files = AndroidFacetEditorTab.this.chooserDirsUnderModule(initialFile, this.myChooseFile, false, (Condition<VirtualFile>)this.myFilter)).length > 0) {
                assert (files.length == 1);
                this.myTextField.setText(FileUtil.toSystemDependentName((String)files[0].getPath()));
            }
        }
    }

    private class MyGenSourceFieldListener
    implements ActionListener {
        private final TextFieldWithBrowseButton myTextField;
        private final String myDefaultPath;

        private MyGenSourceFieldListener(TextFieldWithBrowseButton textField, String defaultPath) {
            this.myTextField = textField;
            this.myDefaultPath = defaultPath;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Module module = AndroidFacetEditorTab.this.myContext.getModule();
            VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            if (contentRoots.length == 0) {
                return;
            }
            VirtualFile initialFile = null;
            String path = this.myTextField.getText().trim();
            if (path.length() == 0) {
                path = this.myDefaultPath;
            }
            if (path != null) {
                initialFile = LocalFileSystem.getInstance().findFileByPath(path);
            }
            if (initialFile == null) {
                ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
                VirtualFile[] sourceRoots = manager.getSourceRoots();
                if (sourceRoots.length > 0) {
                    initialFile = sourceRoots[0];
                } else {
                    String p;
                    initialFile = module.getModuleFile();
                    if (initialFile == null && (p = AndroidRootUtil.getModuleDirPath(AndroidFacetEditorTab.this.myContext.getModule())) != null) {
                        initialFile = LocalFileSystem.getInstance().findFileByPath(p);
                    }
                }
            }
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            descriptor.setRoots(contentRoots);
            VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)AndroidFacetEditorTab.this.myContentPanel, (Project)AndroidFacetEditorTab.this.myContext.getProject(), (VirtualFile)initialFile);
            if (file != null) {
                this.myTextField.setText(FileUtil.toSystemDependentName((String)file.getPath()));
            }
        }
    }
}

