/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.model.ioc;

import com.intellij.tapestry.core.ioc.ServiceBinding;
import com.intellij.tapestry.core.java.IJavaClassType;

public class Service {
    private final String _id;
    private final String _scope;
    private final boolean _eagerLoad;
    private final IJavaClassType _serviceClass;
    private final String _description;

    public Service(ServiceBinding serviceBinding, IJavaClassType serviceClass) {
        this._id = serviceBinding.getId();
        this._scope = serviceBinding.getScope();
        this._eagerLoad = serviceBinding.isEagerLoad();
        this._serviceClass = serviceClass;
        this._description = "";
    }

    public String getId() {
        return this._id;
    }

    public String getScope() {
        return this._scope;
    }

    public boolean isEagerLoad() {
        return this._eagerLoad;
    }

    public String getDescription() {
        if (this._description != null) {
            return this._description;
        }
        return this.getServiceClass().getDocumentation();
    }

    public IJavaClassType getServiceClass() {
        return this._serviceClass;
    }

    public String toString() {
        return this._id;
    }
}

