/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.actions.navigation;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.core.resource.IResource;
import com.intellij.tapestry.intellij.TapestryModuleSupportLoader;
import com.intellij.tapestry.intellij.core.java.IntellijJavaClassType;
import com.intellij.tapestry.intellij.core.resource.IntellijResource;
import com.intellij.tapestry.intellij.util.IdeaUtils;
import com.intellij.tapestry.intellij.util.TapestryUtils;
import com.intellij.tapestry.lang.TmlFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassTemplateNavigation
extends AnAction {
    public void update(AnActionEvent event) {
        Module module;
        Presentation presentation = event.getPresentation();
        try {
            module = (Module)event.getDataContext().getData(DataKeys.MODULE.getName());
        }
        catch (Throwable ex) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        if (!TapestryUtils.isTapestryModule(module)) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        PsiFile psiFile = ClassTemplateNavigation.getEventPsiFile(event);
        if (psiFile == null || !psiFile.getFileType().equals((Object)TmlFileType.INSTANCE) && "Tapestry Class".equals(event.getPresentation().getText())) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(true);
        presentation.setVisible(true);
    }

    public void actionPerformed(AnActionEvent event) {
        Project project = (Project)event.getDataContext().getData(DataKeys.PROJECT.getName());
        PsiFile psiFile = ClassTemplateNavigation.getEventPsiFile(event);
        Module module = (Module)event.getDataContext().getData(DataKeys.MODULE.getName());
        if (psiFile == null || module == null) {
            return;
        }
        String presentationText = event.getPresentation().getText();
        VirtualFile navigationTarget = ClassTemplateNavigation.findNavigationTarget(psiFile, module, presentationText);
        if (navigationTarget != null) {
            FileEditorManager.getInstance((Project)project).openFile(navigationTarget, true);
        } else {
            ClassTemplateNavigation.showCantNavigateMessage();
        }
    }

    @Nullable
    public static VirtualFile findNavigationTarget(@NotNull PsiFile psiFile, @NotNull Module module, String presentationText) {
        TapestryProject project;
        if (psiFile == null) {
            ClassTemplateNavigation.$$$reportNull$$$0(0);
        }
        if (module == null) {
            ClassTemplateNavigation.$$$reportNull$$$0(1);
        }
        if ((project = TapestryModuleSupportLoader.getTapestryProject(module)) == null) {
            return null;
        }
        if (psiFile instanceof PsiClassOwner && presentationText.equals("Class <-> Template Navigation")) {
            PsiClass psiClass = IdeaUtils.findPublicClass(psiFile);
            if (psiClass == null) {
                return null;
            }
            PresentationLibraryElement tapestryElement = PresentationLibraryElement.createProjectElementInstance(new IntellijJavaClassType(module, psiClass.getContainingFile()), project);
            if (!tapestryElement.allowsTemplate()) {
                return null;
            }
            IResource[] templates = tapestryElement.getTemplateConsiderSuperClass();
            return templates.length != 0 && templates[0] != null ? ((IntellijResource)templates[0]).getPsiFile().getVirtualFile() : null;
        }
        if (psiFile.getFileType().equals((Object)TmlFileType.INSTANCE) && (presentationText.equals("Class <-> Template Navigation") || presentationText.equals("Tapestry Class"))) {
            PresentationLibraryElement template = project.findElementByTemplate(psiFile);
            if (template == null) {
                return null;
            }
            IJavaClassType elementClass = template.getElementClass();
            if (elementClass != null) {
                return ((IntellijJavaClassType)elementClass).getPsiClass().getContainingFile().getVirtualFile();
            }
        }
        return null;
    }

    @Nullable
    public static PsiFile getEventPsiFile(AnActionEvent event) {
        Project project = (Project)event.getDataContext().getData(DataKeys.PROJECT.getName());
        if (project == null) {
            return null;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        if (fileEditorManager == null) {
            return null;
        }
        Editor editor = fileEditorManager.getSelectedTextEditor();
        if (editor == null) {
            return null;
        }
        return PsiManager.getInstance((Project)project).findFile(FileDocumentManager.getInstance().getFile(editor.getDocument()));
    }

    public static void showCantNavigateMessage() {
        Messages.showInfoMessage((String)"Couldn't find a file to navigate to.", (String)"Not Tapestry file");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
        }
        objectArray[1] = "com/intellij/tapestry/intellij/actions/navigation/ClassTemplateNavigation";
        objectArray[2] = "findNavigationTarget";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

