/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.lang.descriptor;

import com.intellij.psi.PsiElement;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.tapestry.core.model.presentation.Component;
import com.intellij.tapestry.core.model.presentation.Mixin;
import com.intellij.tapestry.intellij.core.java.IntellijJavaClassType;
import com.intellij.tapestry.intellij.lang.descriptor.DescriptorUtil;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryNamespaceDescriptor;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryXmlExtension;
import com.intellij.tapestry.intellij.util.TapestryUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TapestryHtmlTagDescriptor
implements XmlElementDescriptor,
PsiWritableMetaData {
    private final TapestryNamespaceDescriptor myNamespaceDescriptor;
    private final XmlElementDescriptor myHtmlDelegate;
    @Nullable
    private final Component myComponent;
    private final List<Mixin> myMixins;

    public TapestryHtmlTagDescriptor(@NotNull XmlElementDescriptor htmlDelegate, @Nullable Component component, List<Mixin> mixins, TapestryNamespaceDescriptor descriptor) {
        if (htmlDelegate == null) {
            TapestryHtmlTagDescriptor.$$$reportNull$$$0(0);
        }
        this.myHtmlDelegate = htmlDelegate;
        this.myComponent = component;
        this.myMixins = mixins;
        this.myNamespaceDescriptor = descriptor;
    }

    public String getQualifiedName() {
        return this.myHtmlDelegate.getQualifiedName();
    }

    public String getDefaultName() {
        return this.myHtmlDelegate.getDefaultName();
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        Object[] htmlDescriptors = this.myHtmlDelegate.getElementsDescriptors(context);
        Object[] tapestryDescriptors = DescriptorUtil.getTmlSubelementDescriptors(context, this.myNamespaceDescriptor);
        return (XmlElementDescriptor[])ArrayUtil.mergeArrays((Object[])htmlDescriptors, (Object[])tapestryDescriptors);
    }

    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        XmlElementDescriptor childDescriptor = this.myHtmlDelegate.getElementDescriptor(childTag, contextTag);
        if (childDescriptor != null) {
            return childDescriptor;
        }
        if ("http://www.w3.org/1999/xhtml".equals(childTag.getNamespace()) && (TapestryUtils.getIdentifyingAttribute(contextTag) != null || TapestryHtmlTagDescriptor.isContentTag(contextTag))) {
            return DescriptorUtil.getHtmlTagDescriptorViaNsDescriptor(childTag);
        }
        return DescriptorUtil.getTmlTagDescriptor(childTag);
    }

    private static boolean isContentTag(XmlTag tag) {
        return tag != null && "content".equals(tag.getLocalName()) && TapestryXmlExtension.isTapestryTemplateNamespace(tag.getNamespace());
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        Object[] tapestryAttrs = context != null ? DescriptorUtil.getAttributeDescriptors(context) : DescriptorUtil.getAttributeDescriptors(this.myComponent, null);
        return (XmlAttributeDescriptor[])ArrayUtil.mergeArrays((Object[])tapestryAttrs, (Object[])this.myHtmlDelegate.getAttributesDescriptors(context));
    }

    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
        XmlAttributeDescriptor attributeDescriptor = this.myHtmlDelegate.getAttributeDescriptor(attributeName, context);
        if (attributeDescriptor != null) {
            return attributeDescriptor;
        }
        return context != null ? DescriptorUtil.getAttributeDescriptor(attributeName, context) : DescriptorUtil.getAttributeDescriptor(attributeName, this.myComponent, this.myMixins);
    }

    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        String ns = attribute.getNamespace();
        return attribute.getNamespacePrefix().length() == 0 || TapestryXmlExtension.isTapestryTemplateNamespace(ns) || "http://www.w3.org/1999/xhtml".equals(ns) ? this.getAttributeDescriptor(attribute.getName(), attribute.getParent()) : null;
    }

    public XmlNSDescriptor getNSDescriptor() {
        return this.myHtmlDelegate.getNSDescriptor();
    }

    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        return this.myHtmlDelegate.getContentType();
    }

    public String getDefaultValue() {
        return null;
    }

    public PsiElement getDeclaration() {
        if (this.myComponent != null) {
            return ((IntellijJavaClassType)this.myComponent.getElementClass()).getPsiClass();
        }
        return this.myHtmlDelegate.getDeclaration();
    }

    public String getName(PsiElement context) {
        return this.myHtmlDelegate.getName(context);
    }

    public String getName() {
        return this.myHtmlDelegate.getName();
    }

    public void init(PsiElement element) {
    }

    @NotNull
    public Object[] getDependences() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            TapestryHtmlTagDescriptor.$$$reportNull$$$0(1);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public void setName(String name) throws IncorrectOperationException {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlDelegate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tapestry/intellij/lang/descriptor/TapestryHtmlTagDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tapestry/intellij/lang/descriptor/TapestryHtmlTagDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

