/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.util;

import com.intellij.facet.FacetManager;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.java.IJavaAnnotation;
import com.intellij.tapestry.core.java.IJavaField;
import com.intellij.tapestry.core.model.presentation.Component;
import com.intellij.tapestry.core.model.presentation.InjectedElement;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.core.model.presentation.TemplateElement;
import com.intellij.tapestry.core.util.PathUtils;
import com.intellij.tapestry.intellij.TapestryModuleSupportLoader;
import com.intellij.tapestry.intellij.core.java.IntellijJavaClassType;
import com.intellij.tapestry.intellij.facet.TapestryFacetType;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryXmlExtension;
import com.intellij.tapestry.intellij.util.IdeaUtils;
import com.intellij.tapestry.intellij.util.PsiElementBasedCachedUserDataCache;
import com.intellij.tapestry.lang.TmlFileType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TapestryUtils {
    private static final Logger _logger = Logger.getInstance((String)TapestryUtils.class.getName());
    private static final PsiElementBasedCachedUserDataCache<Component, XmlTag> outTagToComponentMap = new PsiElementBasedCachedUserDataCache<Component, XmlTag>("TapestryTagToComponentMap"){

        @Override
        @Nullable
        protected Component computeValue(XmlTag tag) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)tag);
            return module == null ? null : TapestryUtils.getTypeOfTag(module, tag);
        }
    };

    public static boolean isTapestryModule(Module module) {
        return module != null && FacetManager.getInstance((Module)module).getFacetsByType(TapestryFacetType.ID).size() > 0;
    }

    public static Module[] getAllTapestryModules(Project project) {
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        ArrayList<Module> result = new ArrayList<Module>();
        for (Module module : modules) {
            if (!TapestryUtils.isTapestryModule(module)) continue;
            result.add(module);
        }
        return result.toArray(new Module[result.size()]);
    }

    @Nullable
    public static XmlElement getComponentIdentifier(@Nullable XmlTag tag) {
        return tag == null ? null : (TapestryXmlExtension.isTapestryTemplateNamespace(tag.getNamespace()) ? IdeaUtils.getNameElement(tag) : TapestryUtils.getIdentifyingAttribute(tag));
    }

    @Nullable
    public static XmlAttribute getIdentifyingAttribute(@NotNull XmlTag tag) {
        XmlAttribute typeAttribute;
        if (tag == null) {
            TapestryUtils.$$$reportNull$$$0(0);
        }
        return (typeAttribute = TapestryUtils.getTTypeAttribute(tag)) != null ? typeAttribute : TapestryUtils.getTIdAttribute(tag);
    }

    @Nullable
    public static XmlAttribute getTIdAttribute(XmlTag tag) {
        return tag.getAttribute("id", TapestryXmlExtension.getTapestryNamespace(tag));
    }

    @Nullable
    public static XmlAttribute getTTypeAttribute(XmlTag tag) {
        return tag.getAttribute("type", TapestryXmlExtension.getTapestryNamespace(tag));
    }

    public static boolean parameterDefinedInClass(String paramName, IntellijJavaClassType elementClass, XmlTag tag) {
        IJavaField field = TapestryUtils.findIdentifyingField(elementClass, tag);
        if (field == null) {
            return false;
        }
        IJavaAnnotation annotation = field.getAnnotations().get("org.apache.tapestry5.annotations.Component");
        String[] fieldParameters = annotation.getParameters().get("parameters");
        if (fieldParameters == null) {
            return false;
        }
        for (String fieldParameter : fieldParameters) {
            String[] paramNameValue = fieldParameter.split("=");
            if (paramNameValue.length != 2 || !paramNameValue[0].equals(paramName)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getFieldId(IJavaField field) {
        IJavaAnnotation annotation = field.getAnnotations().get("org.apache.tapestry5.annotations.Component");
        if (annotation == null) {
            return null;
        }
        String[] fieldIds = annotation.getParameters().get("id");
        return fieldIds != null && fieldIds.length > 0 && fieldIds[0] != null && fieldIds[0].length() > 0 ? fieldIds[0] : field.getName();
    }

    @Nullable
    public static IJavaField findIdentifyingField(XmlTag tag) {
        TapestryProject tapestryProject = TapestryUtils.getTapestryProject((PsiElement)tag);
        if (tapestryProject == null) {
            return null;
        }
        PresentationLibraryElement element = tapestryProject.findElementByTemplate(tag.getContainingFile());
        return element != null ? TapestryUtils.findIdentifyingField((IntellijJavaClassType)element.getElementClass(), tag) : null;
    }

    @NotNull
    public static List<String> getEmbeddedComponentIds(XmlTag tag) {
        TapestryProject tapestryProject = TapestryUtils.getTapestryProject((PsiElement)tag);
        if (tapestryProject == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                TapestryUtils.$$$reportNull$$$0(1);
            }
            return list;
        }
        PresentationLibraryElement element = tapestryProject.findElementByTemplate(tag.getContainingFile());
        if (element == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                TapestryUtils.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList<String> embeddedIds = new ArrayList<String>();
        for (TemplateElement injectedElement : element.getEmbeddedComponents()) {
            ContainerUtil.addIfNotNull(embeddedIds, (Object)injectedElement.getElement().getElementId());
        }
        ArrayList<String> arrayList = embeddedIds;
        if (arrayList == null) {
            TapestryUtils.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    private static IJavaField findIdentifyingField(IntellijJavaClassType elementClass, XmlTag tag) {
        String tagId = tag.getAttributeValue("id", TapestryXmlExtension.getTapestryNamespace(tag));
        if (tagId == null) {
            return null;
        }
        for (IJavaField field : elementClass.getFields(false).values()) {
            if (!tagId.equals(TapestryUtils.getFieldId(field))) continue;
            return field;
        }
        return null;
    }

    @Nullable
    public static TapestryProject getTapestryProject(PsiElement psiElement) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            return null;
        }
        return TapestryModuleSupportLoader.getTapestryProject(module);
    }

    @Nullable
    public static XmlAttribute getTapestryAttribute(XmlTag tag, String attrName) {
        XmlAttribute attribute = tag.getAttribute(attrName, TapestryXmlExtension.getTapestryNamespace(tag));
        return attribute != null ? attribute : tag.getAttribute(attrName, "");
    }

    public static void createComponent(Module module, PsiDirectory classSourceDirectory, PsiDirectory templateSourceDirectory, String pageName, boolean replaceExistingFiles) throws IllegalStateException {
        String errorMsg = "";
        try {
            TapestryUtils.createClass(classSourceDirectory, TapestryModuleSupportLoader.getTapestryProject(module).getComponentsRootPackage(), pageName, replaceExistingFiles, "Tapestry Component Class.java");
            if (templateSourceDirectory != null) {
                TapestryUtils.createTemplate(module, templateSourceDirectory, TapestryModuleSupportLoader.getTapestryProject(module).getComponentsRootPackage(), pageName, replaceExistingFiles, "Tapestry Component Template.html");
            }
        }
        catch (IncorrectOperationException ex) {
            errorMsg = "An error occurred creating the component!\n\n";
            _logger.error((Throwable)ex);
        }
        catch (FileAlreadyExistsException ex) {
            errorMsg = "Some component file already exists, the existing version was kept!\n\n";
        }
        if (errorMsg.length() > 0) {
            throw new IllegalStateException(errorMsg);
        }
    }

    public static void createPage(Module module, PsiDirectory classSourceDirectory, PsiDirectory templateSourceDirectory, String pageName, boolean replaceExistingFiles) throws IllegalStateException {
        String errorMsg = "";
        try {
            TapestryUtils.createClass(classSourceDirectory, TapestryModuleSupportLoader.getTapestryProject(module).getPagesRootPackage(), pageName, replaceExistingFiles, "Tapestry Page Class.java");
            if (templateSourceDirectory != null) {
                TapestryUtils.createTemplate(module, templateSourceDirectory, TapestryModuleSupportLoader.getTapestryProject(module).getPagesRootPackage(), pageName, replaceExistingFiles, "Tapestry Page Template.html");
            }
        }
        catch (IncorrectOperationException ex) {
            errorMsg = "An error occurred creating the page!\n\n";
            _logger.error((Throwable)ex);
        }
        catch (FileAlreadyExistsException e) {
            errorMsg = "Some page file already exists, the existing version was kept!\n\n";
        }
        if (errorMsg.length() > 0) {
            throw new IllegalStateException(errorMsg);
        }
    }

    public static void createMixin(Module module, PsiDirectory classSourceDirectory, String mixinName, boolean replaceExistingFiles) throws IllegalStateException {
        String errorMsg = "";
        try {
            TapestryUtils.createClass(classSourceDirectory, TapestryModuleSupportLoader.getTapestryProject(module).getMixinsRootPackage(), mixinName, replaceExistingFiles, "Tapestry Mixin Class.java");
        }
        catch (IncorrectOperationException ex) {
            errorMsg = "An error occurred creating the mixin!\n\n";
            _logger.error((Throwable)ex);
        }
        catch (FileAlreadyExistsException e) {
            errorMsg = "Some mixin file already exists, the existing version was kept!\n\n";
        }
        if (errorMsg.length() > 0) {
            throw new IllegalStateException(errorMsg);
        }
    }

    @Nullable
    public static Component getTypeOfTag(XmlTag tag) {
        return (Component)outTagToComponentMap.get(tag);
    }

    @Nullable
    private static Component getTypeOfTag(@NotNull Module module, @NotNull XmlTag tag) {
        TapestryProject tapestryProject;
        if (module == null) {
            TapestryUtils.$$$reportNull$$$0(4);
        }
        if (tag == null) {
            TapestryUtils.$$$reportNull$$$0(5);
        }
        if ((tapestryProject = TapestryModuleSupportLoader.getTapestryProject(module)) == null) {
            return null;
        }
        XmlElement identifier = TapestryUtils.getComponentIdentifier(tag);
        if (identifier == null) {
            return null;
        }
        if (identifier instanceof XmlAttribute) {
            PresentationLibraryElement element;
            String attrName = ((XmlAttribute)identifier).getLocalName();
            String attrValue = ((XmlAttribute)identifier).getValue();
            if (attrValue == null) {
                return null;
            }
            if (attrName.equals("type")) {
                return tapestryProject.findComponent(attrValue);
            }
            if (attrName.equals("id") && (element = tapestryProject.findElementByTemplate(tag.getContainingFile())) != null) {
                for (TemplateElement embeddedComponent : element.getEmbeddedComponents()) {
                    InjectedElement element1 = embeddedComponent.getElement();
                    if (!attrValue.equals(element1.getElementId())) continue;
                    return (Component)element1.getElement();
                }
            }
            return null;
        }
        String tagLocalName = tag.getLocalName().toLowerCase().replace('.', '/');
        return tapestryProject.findComponent(tagLocalName);
    }

    @Nullable
    public static String getTapestryNamespacePrefix(XmlFile template) {
        XmlDocument doc = template.getDocument();
        if (doc == null) {
            return null;
        }
        XmlTag rootTag = doc.getRootTag();
        if (rootTag == null) {
            return null;
        }
        for (XmlAttribute attribute : rootTag.getAttributes()) {
            if (!attribute.getName().startsWith("xmlns:") || !TapestryXmlExtension.isTapestryTemplateNamespace(attribute.getValue())) continue;
            return attribute.getName().substring(6);
        }
        return null;
    }

    private static void createClass(PsiDirectory sourceDirectory, String basePackage, String pageName, boolean replaceExistingFiles, String templateName) throws FileAlreadyExistsException, IncorrectOperationException {
        String fileName;
        PsiDirectory classDirectory = IdeaUtils.findOrCreateDirectoryForPackage(sourceDirectory, PathUtils.getFullComponentPackage(basePackage, pageName));
        PsiFile file = classDirectory.findFile((fileName = PathUtils.getComponentFileName(pageName)) + ".java");
        if (file != null) {
            if (!replaceExistingFiles) {
                throw new FileAlreadyExistsException();
            }
            file.delete();
        }
        JavaDirectoryService.getInstance().createClass(classDirectory, PathUtils.getComponentFileName(pageName), templateName);
    }

    private static void createTemplate(Module module, PsiDirectory sourceDirectory, String basePackage, String pageName, boolean replaceExistingFiles, String template) throws FileAlreadyExistsException, IncorrectOperationException {
        String fileName;
        PsiDirectory templateDirectory;
        PsiFile psiFile;
        if (IdeaUtils.isWebRoot(module, sourceDirectory.getVirtualFile())) {
            basePackage = "";
        }
        if ((psiFile = (templateDirectory = IdeaUtils.findOrCreateDirectoryForPackage(sourceDirectory, PathUtils.getFullComponentPackage(basePackage, pageName))).findFile(fileName = PathUtils.getComponentFileName(pageName) + "." + "tml")) != null) {
            if (!replaceExistingFiles) {
                throw new FileAlreadyExistsException();
            }
            psiFile.delete();
        }
        PsiFile pageTemplate = PsiFileFactory.getInstance((Project)module.getProject()).createFileFromText(fileName, (FileType)TmlFileType.INSTANCE, (CharSequence)FileTemplateManager.getInstance((Project)module.getProject()).getInternalTemplate(template).getText());
        templateDirectory.add((PsiElement)pageTemplate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tapestry/intellij/util/TapestryUtils";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tapestry/intellij/util/TapestryUtils";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmbeddedComponentIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIdentifyingAttribute";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTypeOfTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class FileAlreadyExistsException
    extends Exception {
        FileAlreadyExistsException() {
        }
    }
}

