/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.tapestry.psi.TelCompositeElement;
import com.intellij.tapestry.psi.TelPsiUtil;
import com.intellij.tapestry.psi.TelQualifiedReference;
import com.intellij.tapestry.psi.TelReferenceQualifier;
import com.intellij.tapestry.psi.TelTokenTypes;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TelReferenceExpression
extends TelCompositeElement
implements TelReferenceQualifier {
    private final TelQualifiedReference myReference;

    protected TelReferenceExpression(@NotNull ASTNode node) {
        if (node == null) {
            TelReferenceExpression.$$$reportNull$$$0(0);
        }
        super(node);
        this.myReference = new TelQualifiedReference(this){

            public TextRange getRangeInElement() {
                PsiElement element = TelReferenceExpression.this.getReferenceNameElement();
                if (element == null) {
                    return TextRange.from((int)0, (int)TelReferenceExpression.this.getTextLength());
                }
                return TextRange.from((int)element.getStartOffsetInParent(), (int)element.getTextLength());
            }

            @Override
            @Nullable
            public String getReferenceName() {
                PsiElement element = TelReferenceExpression.this.getReferenceNameElement();
                return element == null ? null : element.getText();
            }

            @Override
            @Nullable
            public TelReferenceQualifier getReferenceQualifier() {
                return (TelReferenceQualifier)TelReferenceExpression.this.findChildByClass(TelReferenceQualifier.class);
            }

            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                String newPropertyName;
                PsiElement resolve = this.resolve();
                if (resolve instanceof PsiMethod && PropertyUtilBase.getPropertyName((PsiMethod)((PsiMethod)resolve)) != null && (newPropertyName = PropertyUtilBase.getPropertyName((String)newElementName)) != null) {
                    newElementName = newPropertyName;
                }
                PsiElement newReferenceName = TelPsiUtil.parseReference(newElementName, TelReferenceExpression.this.getProject()).getReferenceNameElement();
                TelReferenceExpression.this.getNode().replaceChild(TelReferenceExpression.this.getReferenceNameElement().getNode(), newReferenceName.getNode());
                return TelReferenceExpression.this;
            }
        };
    }

    private PsiElement getReferenceNameElement() {
        return this.findChildByType(TelTokenTypes.TAP5_EL_IDENTIFIER);
    }

    @NotNull
    public TelQualifiedReference getReference() {
        TelQualifiedReference telQualifiedReference = this.myReference;
        if (telQualifiedReference == null) {
            TelReferenceExpression.$$$reportNull$$$0(1);
        }
        return telQualifiedReference;
    }

    @Override
    @Nullable
    public PsiType getPsiType() {
        return this.myReference.getPsiType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tapestry/psi/TelReferenceExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tapestry/psi/TelReferenceExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

