/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.timeTracking;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.TaskListener;
import com.intellij.tasks.TaskListenerAdapter;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.actions.GotoTaskAction;
import com.intellij.tasks.actions.SwitchTaskAction;
import com.intellij.tasks.timeTracking.SendTimeTrackingInformationDialog;
import com.intellij.tasks.timeTracking.TimeTrackingManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.table.TableView;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import icons.TasksCoreIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nullable;

public class TasksToolWindowPanel
extends SimpleToolWindowPanel
implements Disposable {
    private final ListTableModel<LocalTask> myTableModel;
    private final TimeTrackingManager myTimeTrackingManager;
    private final Project myProject;
    private Timer myTimer;
    private final TableView<LocalTask> myTable;
    private final TaskManager myTaskManager;

    public TasksToolWindowPanel(Project project, boolean vertical) {
        super(vertical);
        this.myProject = project;
        this.myTimeTrackingManager = TimeTrackingManager.getInstance(project);
        this.myTaskManager = TaskManager.getManager((Project)project);
        this.myTable = new TableView(this.createListModel());
        this.myTableModel = this.myTable.getListTableModel();
        this.updateTable();
        this.setContent(ScrollPaneFactory.createScrollPane(this.myTable, (boolean)true));
        this.setToolbar(this.createToolbar());
        this.myTaskManager.addTaskListener((TaskListener)new TaskListenerAdapter(){

            public void taskDeactivated(LocalTask task) {
                TasksToolWindowPanel.this.myTable.repaint();
            }

            public void taskActivated(LocalTask task) {
                TasksToolWindowPanel.this.myTable.repaint();
            }

            public void taskAdded(LocalTask task) {
                TasksToolWindowPanel.this.updateTable();
            }

            public void taskRemoved(LocalTask task) {
                TasksToolWindowPanel.this.updateTable();
            }
        }, (Disposable)this);
        this.myTimer = UIUtil.createNamedTimer((String)"TasksToolRepaint", (int)60000, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TasksToolWindowPanel.this.myTable.repaint();
            }
        });
        this.myTimer.start();
    }

    private static SimpleTextAttributes getAttributes(boolean isClosed, boolean isActive, boolean isSelected) {
        return new SimpleTextAttributes(isActive ? 1 : 0, isSelected ? UIUtil.getTableSelectionForeground() : (isClosed && !isActive ? UIUtil.getLabelDisabledForeground() : UIUtil.getTableForeground()));
    }

    private static String formatDuration(long milliseconds) {
        int second = 1000;
        int minute = 60000;
        int hour = 3600000;
        int day = 86400000;
        int days = (int)milliseconds / 86400000;
        String daysString = days != 0 ? days + "d " : "";
        return daysString + String.format("%d:%02d", milliseconds % 86400000L / 3600000L, milliseconds % 3600000L / 60000L);
    }

    private JComponent createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        AnAction action = ActionManager.getInstance().getAction("tasks.goto");
        assert (action instanceof GotoTaskAction);
        GotoTaskAction gotoTaskAction = (GotoTaskAction)action;
        group.add((AnAction)gotoTaskAction);
        group.add((AnAction)new DumbAwareAction("Remove Task", "Remove Task", IconUtil.getRemoveIcon()){

            public void actionPerformed(AnActionEvent e) {
                for (LocalTask localTask : TasksToolWindowPanel.this.myTable.getSelectedObjects()) {
                    SwitchTaskAction.removeTask((Project)TasksToolWindowPanel.this.myProject, (LocalTask)localTask, (TaskManager)TasksToolWindowPanel.this.myTaskManager);
                }
            }
        });
        group.add((AnAction)new ToggleAction("Show closed tasks", "Show closed tasks", AllIcons.Actions.Checked){

            public boolean isSelected(AnActionEvent e) {
                return ((TasksToolWindowPanel)TasksToolWindowPanel.this).myTimeTrackingManager.getState().showClosedTasks;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                ((TasksToolWindowPanel)TasksToolWindowPanel.this).myTimeTrackingManager.getState().showClosedTasks = state;
                TasksToolWindowPanel.this.updateTable();
            }
        });
        group.add((AnAction)new ModeToggleAction());
        group.add((AnAction)new StartStopAction());
        group.add(new AnAction("Post work item to bugtracker", "Post work item to bugtracker", AllIcons.Actions.Export){

            public void actionPerformed(AnActionEvent e) {
                LocalTask localTask = (LocalTask)TasksToolWindowPanel.this.myTable.getSelectedObject();
                if (localTask == null) {
                    return;
                }
                new SendTimeTrackingInformationDialog(TasksToolWindowPanel.this.myProject, localTask).show();
            }

            public void update(AnActionEvent e) {
                LocalTask localTask = (LocalTask)TasksToolWindowPanel.this.myTable.getSelectedObject();
                if (localTask == null) {
                    e.getPresentation().setEnabled(false);
                } else {
                    TaskRepository repository = localTask.getRepository();
                    e.getPresentation().setEnabled(repository != null && repository.isSupported(4));
                }
            }
        });
        group.add((AnAction)new ToggleAction("Show time spent from last post of work item", "Show time spent from last post of work item", TasksCoreIcons.Clock){

            public boolean isSelected(AnActionEvent e) {
                return ((TasksToolWindowPanel)TasksToolWindowPanel.this).myTimeTrackingManager.getState().showSpentTimeFromLastPost;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                ((TasksToolWindowPanel)TasksToolWindowPanel.this).myTimeTrackingManager.getState().showSpentTimeFromLastPost = state;
                TasksToolWindowPanel.this.myTable.repaint();
            }
        });
        ActionToolbar actionToolBar = ActionManager.getInstance().createActionToolbar("TasksToolWindow", (ActionGroup)group, this.myVertical);
        return actionToolBar.getComponent();
    }

    private void updateTable() {
        UIUtil.invokeLaterIfNeeded(() -> this.myTableModel.setItems(ContainerUtil.filter((Collection)this.myTaskManager.getLocalTasks(), task -> task.isActive() || task.getTotalTimeSpent() != 0L && (this.myTimeTrackingManager.getState().showClosedTasks || !this.myTaskManager.isLocallyClosed(task)))));
    }

    private ListTableModel<LocalTask> createListModel() {
        ColumnInfo<LocalTask, String> task = new ColumnInfo<LocalTask, String>("Task"){

            @Nullable
            public String valueOf(LocalTask task) {
                return task.getPresentableName();
            }

            @Nullable
            public TableCellRenderer getRenderer(final LocalTask task) {
                return new TableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        JPanel panel = new JPanel(new BorderLayout());
                        panel.setBackground(UIUtil.getTableBackground((boolean)isSelected));
                        SimpleColoredComponent component = new SimpleColoredComponent();
                        boolean isClosed = task.isClosed() || TasksToolWindowPanel.this.myTaskManager.isLocallyClosed(task);
                        boolean isActive = task.isActive();
                        boolean isRunning = ((TasksToolWindowPanel)TasksToolWindowPanel.this).myTimeTrackingManager.getState().autoMode ? isActive : isActive && task.isRunning();
                        component.append((String)value, TasksToolWindowPanel.getAttributes(isClosed, isActive, isSelected));
                        component.setIcon(isRunning ? LayeredIcon.create((Icon)task.getIcon(), (Icon)AllIcons.Nodes.RunnableMark) : (isClosed && !isActive ? IconLoader.getTransparentIcon((Icon)task.getIcon()) : task.getIcon()));
                        component.setOpaque(false);
                        panel.add((Component)component, "Center");
                        panel.setOpaque(true);
                        return panel;
                    }
                };
            }

            @Nullable
            public Comparator<LocalTask> getComparator() {
                return (o1, o2) -> {
                    int i = Comparing.compare((Comparable)o2.getUpdated(), (Comparable)o1.getUpdated());
                    return i == 0 ? Comparing.compare((Comparable)o2.getCreated(), (Comparable)o1.getCreated()) : i;
                };
            }
        };
        ColumnInfo<LocalTask, String> spentTime = new ColumnInfo<LocalTask, String>("Time Spent"){

            @Nullable
            public String valueOf(LocalTask task) {
                long timeSpent;
                long l = timeSpent = ((TasksToolWindowPanel)TasksToolWindowPanel.this).myTimeTrackingManager.getState().showSpentTimeFromLastPost ? task.getTimeSpentFromLastPost() : task.getTotalTimeSpent();
                if (task.isActive()) {
                    return TasksToolWindowPanel.formatDuration(timeSpent);
                }
                return DateFormatUtil.formatDuration((long)timeSpent);
            }

            @Nullable
            public TableCellRenderer getRenderer(final LocalTask task) {
                return new TableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        JPanel panel = new JPanel(new BorderLayout());
                        panel.setBackground(UIUtil.getTableBackground((boolean)isSelected));
                        SimpleColoredComponent component = new SimpleColoredComponent();
                        boolean isClosed = task.isClosed() || TasksToolWindowPanel.this.myTaskManager.isLocallyClosed(task);
                        boolean isActive = task.isActive();
                        component.append((String)value, TasksToolWindowPanel.getAttributes(isClosed, isActive, isSelected));
                        component.setOpaque(false);
                        panel.add((Component)component, "Center");
                        panel.setOpaque(true);
                        return panel;
                    }
                };
            }

            @Nullable
            public Comparator<LocalTask> getComparator() {
                return (o1, o2) -> {
                    long timeSpent1 = ((TasksToolWindowPanel)TasksToolWindowPanel.this).myTimeTrackingManager.getState().showSpentTimeFromLastPost ? o1.getTimeSpentFromLastPost() : o1.getTotalTimeSpent();
                    long timeSpent2 = ((TasksToolWindowPanel)TasksToolWindowPanel.this).myTimeTrackingManager.getState().showSpentTimeFromLastPost ? o2.getTimeSpentFromLastPost() : o2.getTotalTimeSpent();
                    return Comparing.compare((long)timeSpent1, (long)timeSpent2);
                };
            }
        };
        return new ListTableModel(new ColumnInfo[]{task, spentTime});
    }

    public void dispose() {
        this.myTimer.stop();
        this.myTimer = null;
    }

    private class ModeToggleAction
    extends ToggleAction {
        public ModeToggleAction() {
            super("Auto mode", "Automatic starting and stopping of timer", TasksCoreIcons.AutoMode);
        }

        public boolean isSelected(AnActionEvent e) {
            return ((TasksToolWindowPanel)TasksToolWindowPanel.this).myTimeTrackingManager.getState().autoMode;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            TasksToolWindowPanel.this.myTimeTrackingManager.setAutoMode(state);
            TasksToolWindowPanel.this.updateTable();
        }
    }

    private class StartStopAction
    extends AnAction {
        private StartStopAction() {
        }

        public void update(AnActionEvent e) {
            if (((TasksToolWindowPanel)TasksToolWindowPanel.this).myTimeTrackingManager.getState().autoMode) {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setIcon(TasksCoreIcons.StartTimer);
                e.getPresentation().setText("Start timer for active task");
            } else {
                e.getPresentation().setEnabled(true);
                if (TasksToolWindowPanel.this.myTaskManager.getActiveTask().isRunning()) {
                    e.getPresentation().setIcon(TasksCoreIcons.StopTimer);
                    e.getPresentation().setText("Stop timer for active task");
                } else {
                    e.getPresentation().setIcon(TasksCoreIcons.StartTimer);
                    e.getPresentation().setText("Start timer for active task");
                }
            }
        }

        public void actionPerformed(AnActionEvent e) {
            LocalTask activeTask = TasksToolWindowPanel.this.myTaskManager.getActiveTask();
            if (activeTask.isRunning()) {
                activeTask.setRunning(false);
            } else {
                activeTask.setRunning(true);
            }
        }
    }
}

